/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.FXCollectors;
import io.github.palexdev.materialfx.utils.StringUtils;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;

public class StringFilter<T>
extends AbstractFilter<T, String> {
    public StringFilter(String name, Function<T, String> extractor) {
        this(name, extractor, new StringConverter<String>(){

            public String toString(String object) {
                return object;
            }

            public String fromString(String string) {
                return string;
            }
        });
    }

    public StringFilter(String name, Function<T, String> extractor, StringConverter<String> converter) {
        super(name, extractor, converter);
    }

    @Override
    protected ObservableList<BiPredicateBean<String, String>> defaultPredicates() {
        return Stream.of(new BiPredicateBean<String, String>(I18N.getOrDefault("filter.contains", new Object[0]), String::contains), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.containsIgnCase", new Object[0]), StringUtils::containsIgnoreCase), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.containsAny", new Object[0]), (x$0, x$1) -> StringUtils.containsAny(x$0, x$1, new String[0])), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.containsAll", new Object[0]), (x$0, x$1) -> StringUtils.containsAll(x$0, x$1, new String[0])), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.endsWith", new Object[0]), String::endsWith), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.endsWithIgnCase", new Object[0]), StringUtils::endsWithIgnoreCase), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.equals", new Object[0]), String::equals), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.equalsIgnCase", new Object[0]), String::equalsIgnoreCase), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.notEqual", new Object[0]), (aString, aString2) -> !aString.equals(aString2)), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.startsWith", new Object[0]), String::startsWith), new BiPredicateBean<String, String>(I18N.getOrDefault("filter.startsWithIgnCase", new Object[0]), StringUtils::startsWithIgnoreCase)).collect(FXCollectors.toList());
    }

    @SafeVarargs
    protected final StringFilter<T> extend(BiPredicateBean<String, String> ... predicateBeans) {
        Collections.addAll(this.predicates, predicateBeans);
        return this;
    }
}

