/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.selection;

import io.github.palexdev.materialfx.controls.MFXCheckTreeItem;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import io.github.palexdev.materialfx.selection.TreeSelectionModel;
import io.github.palexdev.materialfx.selection.base.ITreeCheckModel;
import io.github.palexdev.materialfx.utils.TreeItemStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;

public class TreeCheckModel<T>
extends TreeSelectionModel<T>
implements ITreeCheckModel<T> {
    private final ListProperty<MFXCheckTreeItem<T>> checkedItems = new SimpleListProperty(FXCollections.observableArrayList());

    public TreeCheckModel() {
        this.checkedItems.addListener(change -> {
            ArrayList tmpRemoved = new ArrayList();
            ArrayList tmpAdded = new ArrayList();
            while (change.next()) {
                tmpRemoved.addAll(change.getRemoved());
                tmpAdded.addAll(change.getAddedSubList());
            }
            tmpRemoved.forEach(item -> item.setChecked(false));
            tmpAdded.forEach(item -> item.setChecked(true));
        });
    }

    private void check(MFXCheckTreeItem<T> item) {
        if (item.isChecked()) {
            this.checkedItems.remove(item);
        } else {
            this.checkedItems.add(item);
        }
    }

    private void checkAll(List<MFXCheckTreeItem<T>> items) {
        this.checkedItems.addAll(items);
    }

    private void uncheckAll(List<MFXCheckTreeItem<T>> items) {
        this.checkedItems.removeAll(items);
    }

    private int checkedChildren(MFXCheckTreeItem<T> item) {
        int cnt = 0;
        for (AbstractMFXTreeItem treeItem : item.getItems()) {
            MFXCheckTreeItem cItem = (MFXCheckTreeItem)treeItem;
            if (!cItem.isChecked()) continue;
            ++cnt;
        }
        return cnt;
    }

    private int indeterminateChildren(MFXCheckTreeItem<T> item) {
        int cnt = 0;
        for (AbstractMFXTreeItem treeItem : item.getItems()) {
            MFXCheckTreeItem cItem = (MFXCheckTreeItem)treeItem;
            if (!cItem.isIndeterminate()) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public void scanTree(MFXCheckTreeItem<T> item) {
        TreeItemStream.flattenTree(item).forEach(treeItem -> {
            MFXCheckTreeItem cItem = (MFXCheckTreeItem)treeItem;
            if (cItem.isChecked() && !this.checkedItems.contains((Object)cItem)) {
                this.check(cItem, null);
            }
        });
    }

    @Override
    public void check(MFXCheckTreeItem<T> item, MFXCheckTreeItem.CheckTreeItemEvent<?> event) {
        if (event == null) {
            List<MFXCheckTreeItem<T>> items = TreeItemStream.flattenTree(item).map(cItem -> (MFXCheckTreeItem)cItem).collect(Collectors.toList());
            this.checkAll(items);
            return;
        }
        if (event.getItemRef() != null && event.getItemRef() == item) {
            List<MFXCheckTreeItem<T>> items = TreeItemStream.flattenTree(item).map(cItem -> (MFXCheckTreeItem)cItem).collect(Collectors.toList());
            if (!item.isChecked() || item.isIndeterminate()) {
                this.checkAll(items);
            } else {
                this.uncheckAll(items);
            }
            return;
        }
        if (this.checkedChildren(item) == item.getItems().size()) {
            item.setIndeterminate(false);
            this.check(item);
        } else if (this.indeterminateChildren(item) != 0) {
            this.checkedItems.remove(item);
            item.setIndeterminate(true);
        } else if (this.checkedChildren(item) == 0) {
            this.checkedItems.remove(item);
            item.setIndeterminate(false);
        } else {
            this.checkedItems.remove(item);
            item.setIndeterminate(true);
        }
    }

    @Override
    public void clearChecked() {
        if (this.checkedItems.isEmpty()) {
            return;
        }
        this.checkedItems.forEach(item -> item.setChecked(false));
        this.checkedItems.clear();
    }

    @Override
    public ListProperty<MFXCheckTreeItem<T>> getCheckedItems() {
        return this.checkedItems;
    }
}

