/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.selection;

import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import io.github.palexdev.materialfx.selection.base.ITreeSelectionModel;
import io.github.palexdev.materialfx.utils.TreeItemStream;
import java.util.ArrayList;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.scene.input.MouseEvent;

public class TreeSelectionModel<T>
implements ITreeSelectionModel<T> {
    private final ListProperty<AbstractMFXTreeItem<T>> selectedItems = new SimpleListProperty(FXCollections.observableArrayList());
    private boolean allowsMultipleSelection = false;

    public TreeSelectionModel() {
        this.selectedItems.addListener(change -> {
            ArrayList tmpRemoved = new ArrayList();
            ArrayList tmpAdded = new ArrayList();
            while (change.next()) {
                tmpRemoved.addAll(change.getRemoved());
                tmpAdded.addAll(change.getAddedSubList());
            }
            tmpRemoved.forEach(item -> item.setSelected(false));
            tmpAdded.forEach(item -> item.setSelected(true));
        });
    }

    protected void select(AbstractMFXTreeItem<T> item) {
        if (!this.allowsMultipleSelection) {
            this.clearSelection();
            this.selectedItems.setAll((Object[])new AbstractMFXTreeItem[]{item});
        } else {
            this.selectedItems.add(item);
        }
    }

    @Override
    public void scanTree(AbstractMFXTreeItem<T> item) {
        TreeItemStream.flattenTree(item).forEach(treeItem -> {
            if (treeItem.isSelected() && !this.selectedItems.contains(treeItem)) {
                this.select((AbstractMFXTreeItem<T>)treeItem);
            }
        });
    }

    @Override
    public void select(AbstractMFXTreeItem<T> item, MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            this.select(item);
            return;
        }
        if (!this.allowsMultipleSelection) {
            this.clearSelection();
            this.selectedItems.setAll((Object[])new AbstractMFXTreeItem[]{item});
            return;
        }
        if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
            if (item.isSelected()) {
                this.selectedItems.remove(item);
            } else {
                this.selectedItems.add(item);
            }
        } else {
            this.clearSelection();
            this.selectedItems.setAll((Object[])new AbstractMFXTreeItem[]{item});
        }
    }

    @Override
    public void clearSelection() {
        if (this.selectedItems.isEmpty()) {
            return;
        }
        this.selectedItems.forEach(item -> item.setSelected(false));
        this.selectedItems.clear();
    }

    @Override
    public AbstractMFXTreeItem<T> getSelectedItem() {
        if (this.selectedItems.isEmpty()) {
            return null;
        }
        return (AbstractMFXTreeItem)this.selectedItems.get(0);
    }

    @Override
    public ListProperty<AbstractMFXTreeItem<T>> getSelectedItems() {
        return this.selectedItems;
    }

    @Override
    public boolean allowsMultipleSelection() {
        return this.allowsMultipleSelection;
    }

    @Override
    public void setAllowsMultipleSelection(boolean multipleSelection) {
        this.allowsMultipleSelection = multipleSelection;
    }
}

