/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXCheckbox;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.skins.base.MFXLabeledSkinBase;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;

public class MFXCheckboxSkin
extends MFXLabeledSkinBase<MFXCheckbox> {
    private final MFXIconWrapper box;
    private final StackPane rippleContainer;
    private final Circle rippleContainerClip;
    private final MFXCircleRippleGenerator rippleGenerator;

    public MFXCheckboxSkin(MFXCheckbox checkbox) {
        super(checkbox);
        MFXFontIcon mark = new MFXFontIcon();
        mark.getStyleClass().add((Object)"mark");
        this.box = new MFXIconWrapper((Node)mark, -1.0);
        this.box.getStyleClass().add((Object)"box");
        this.rippleContainer = new StackPane();
        this.rippleGenerator = new MFXCircleRippleGenerator((Region)this.rippleContainer);
        this.rippleGenerator.setManaged(false);
        this.rippleGenerator.setAnimateBackground(false);
        this.rippleGenerator.setCheckBounds(false);
        this.rippleGenerator.setClipSupplier(() -> null);
        this.rippleGenerator.setRipplePositionFunction(event -> {
            PositionBean position = new PositionBean();
            position.setX(Math.min(event.getX(), this.rippleContainer.getWidth()));
            position.setY(Math.min(event.getY(), this.rippleContainer.getHeight()));
            return position;
        });
        this.rippleContainer.getChildren().addAll((Object[])new Node[]{this.rippleGenerator, this.box});
        this.rippleContainer.getStyleClass().add((Object)"ripple-container");
        this.rippleContainerClip = new Circle();
        this.rippleContainerClip.centerXProperty().bind((ObservableValue)this.rippleContainer.widthProperty().divide(2.0));
        this.rippleContainerClip.centerYProperty().bind((ObservableValue)this.rippleContainer.heightProperty().divide(2.0));
        this.rippleContainer.setClip((Node)this.rippleContainerClip);
        this.updateAlignment();
        this.initContainer();
        this.getChildren().setAll((Object[])new Node[]{this.topContainer});
        this.addListeners();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        MFXCheckbox checkbox = (MFXCheckbox)this.getSkinnable();
        checkbox.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            this.rippleGenerator.generateRipple((MouseEvent)event);
            checkbox.fire();
        });
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        double boxSize = this.box.getSize();
        Insets boxPadding = this.rippleContainer.getPadding();
        double boxClipRadius = boxPadding.getLeft() + boxSize / 2.0 + boxPadding.getRight();
        this.rippleContainerClip.setRadius(boxClipRadius);
    }

    @Override
    protected Pane getControlContainer() {
        return this.rippleContainer;
    }
}

