/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXCircleToggleNode;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.enums.TextPosition;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.TextUtils;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;

public class MFXCircleToggleNodeSkin
extends SkinBase<MFXCircleToggleNode> {
    private final VBox topContainer;
    private final StackPane rippleContainer;
    private final Circle circle = new Circle();
    private final MFXTextField label;
    private final MFXCircleRippleGenerator rippleGenerator;

    public MFXCircleToggleNodeSkin(MFXCircleToggleNode toggleNode) {
        super((Control)toggleNode);
        this.circle.getStyleClass().add((Object)"circle");
        this.circle.radiusProperty().bind((ObservableValue)toggleNode.sizeProperty());
        this.label = new MFXTextField();
        this.label.alignmentProperty().bind((ObservableValue)toggleNode.alignmentProperty());
        this.label.fontProperty().bind((ObservableValue)toggleNode.fontProperty());
        this.label.graphicTextGapProperty().bind((ObservableValue)toggleNode.graphicTextGapProperty());
        this.label.textFillProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> (Color)toggleNode.getTextFill(), (Observable[])new Observable[]{toggleNode.textFillProperty()}));
        this.label.textProperty().bind((ObservableValue)toggleNode.textProperty());
        this.label.leadingIconProperty().bind(toggleNode.labelLeadingIconProperty());
        this.label.trailingIconProperty().bind(toggleNode.labelTrailingIconProperty());
        this.label.setEditable(false);
        this.label.setSelectable(false);
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.rippleContainer = new StackPane();
        this.rippleGenerator = new MFXCircleRippleGenerator((Region)this.rippleContainer);
        this.rippleGenerator.setMouseTransparent(true);
        this.rippleGenerator.setManaged(false);
        Node graphic = toggleNode.getGraphic();
        if (graphic != null) {
            graphic.setMouseTransparent(true);
            this.rippleContainer.getChildren().setAll((Object[])new Node[]{this.circle, this.rippleGenerator, graphic});
        } else {
            this.rippleContainer.getChildren().setAll((Object[])new Node[]{this.circle, this.rippleGenerator});
        }
        this.topContainer = new VBox();
        this.topContainer.setAlignment(Pos.TOP_CENTER);
        this.topContainer.spacingProperty().bind((ObservableValue)toggleNode.gapProperty());
        if (toggleNode.getTextPosition() == TextPosition.TOP) {
            this.topContainer.getChildren().setAll((Object[])new Node[]{this.label, this.rippleContainer});
        } else {
            this.topContainer.getChildren().setAll((Object[])new Node[]{this.rippleContainer, this.label});
        }
        this.setupRippleGenerator();
        this.addListeners();
        this.getChildren().setAll((Object[])new Node[]{this.topContainer});
    }

    private void addListeners() {
        MFXCircleToggleNode toggleNode = (MFXCircleToggleNode)this.getSkinnable();
        toggleNode.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (!NodeUtils.inHierarchy(event, (Node)this.rippleContainer)) {
                return;
            }
            Node leadingIcon = this.label.getLeadingIcon();
            Node trailingIcon = this.label.getTrailingIcon();
            if (leadingIcon != null && NodeUtils.inHierarchy(event, leadingIcon) || trailingIcon != null && NodeUtils.inHierarchy(event, trailingIcon) || NodeUtils.inHierarchy(event, (Node)this.label)) {
                return;
            }
            toggleNode.setSelected(!toggleNode.isSelected());
        });
        toggleNode.graphicProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.rippleContainer.getChildren().remove(oldValue);
            }
            if (newValue != null) {
                newValue.setMouseTransparent(true);
                this.rippleContainer.getChildren().add(newValue);
            }
        });
        toggleNode.textPositionProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == TextPosition.TOP) {
                this.topContainer.getChildren().setAll((Object[])new Node[]{this.label, this.rippleContainer});
            } else {
                this.topContainer.getChildren().setAll((Object[])new Node[]{this.rippleContainer, this.label});
            }
        });
        this.rippleContainer.addEventHandler(MouseEvent.MOUSE_CLICKED, this.rippleGenerator::generateRipple);
    }

    protected void setupRippleGenerator() {
        this.rippleGenerator.setAnimateBackground(false);
        this.rippleGenerator.setAnimationSpeed(1.3);
        this.rippleGenerator.setClipSupplier(() -> {
            Circle clip = new Circle();
            clip.radiusProperty().bind((ObservableValue)this.circle.radiusProperty());
            clip.centerXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.circle.getBoundsInParent().getCenterX(), (Observable[])new Observable[]{this.circle.boundsInParentProperty()}));
            clip.centerYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.circle.getBoundsInParent().getCenterY(), (Observable[])new Observable[]{this.circle.boundsInParentProperty()}));
            return clip;
        });
        this.rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
        this.rippleGenerator.rippleRadiusProperty().bind((ObservableValue)this.circle.radiusProperty().add(5));
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXCircleToggleNode toggleNode = (MFXCircleToggleNode)this.getSkinnable();
        double containerWidth = this.rippleContainer.prefWidth(-1.0);
        double gap = this.label.getGraphicTextGap();
        Node leading = toggleNode.getLabelLeadingIcon();
        Node trailing = toggleNode.getLabelTrailingIcon();
        double labelWidth = TextUtils.computeTextWidth(toggleNode.getFont(), toggleNode.getText()) + this.label.snappedLeftInset() + this.label.snappedRightInset() + (leading != null ? leading.prefWidth(-1.0) + gap : 0.0) + (trailing != null ? trailing.prefWidth(-1.0) + gap : 0.0);
        return leftInset + Math.max(containerWidth, labelWidth) + rightInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXCircleToggleNode)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXCircleToggleNode)this.getSkinnable()).prefWidth(-1.0);
    }
}

