/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXMagnifierPane;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.ScrollUtils;
import io.github.palexdev.materialfx.utils.SwingFXUtils;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.PauseTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.SnapshotResult;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.imageio.ImageIO;

public class MFXMagnifierPaneSkin
extends SkinBase<MFXMagnifierPane> {
    private final StackPane lensContainer;
    private final MFXMagnifierLens lens = new MFXMagnifierLens();
    private final ColorPicker picker;

    public MFXMagnifierPaneSkin(MFXMagnifierPane magnifier) {
        super((Control)magnifier);
        magnifier.setSnapToPixel(false);
        this.lensContainer = new StackPane(new Node[]{this.lens});
        this.lensContainer.setManaged(false);
        this.lensContainer.setSnapToPixel(false);
        this.lensContainer.getStyleClass().add((Object)"lens-container");
        Circle circle = new Circle();
        circle.radiusProperty().bind((ObservableValue)magnifier.lensSizeProperty().divide(2.0).multiply((ObservableNumberValue)magnifier.zoomProperty()));
        circle.centerXProperty().bind((ObservableValue)this.lensContainer.widthProperty().divide(2.0));
        circle.centerYProperty().bind((ObservableValue)this.lensContainer.heightProperty().divide(2.0));
        this.lens.setClip((Node)circle);
        this.picker = new ColorPicker();
        Node content = magnifier.getContent();
        if (content != null) {
            this.getChildren().addAll((Object[])new Node[]{content, this.lensContainer, this.picker});
        } else {
            this.getChildren().addAll((Object[])new Node[]{this.lensContainer, this.picker});
        }
        this.setBehavior();
    }

    private void setBehavior() {
        MFXMagnifierPane magnifier = (MFXMagnifierPane)this.getSkinnable();
        magnifier.addEventFilter(MouseEvent.MOUSE_MOVED, this::updatePosition);
        magnifier.addEventFilter(ScrollEvent.SCROLL, this::updateZoom);
        magnifier.contentProperty().addListener((observable, oldValue, newValue) -> {
            ObservableList children = this.getChildren();
            if (newValue == null && children.size() == 3) {
                children.remove(0);
            } else if (newValue != null) {
                if (children.size() == 3) {
                    children.set(0, newValue);
                } else {
                    children.add(0, newValue);
                }
            }
        });
        magnifier.lensSizeProperty().addListener(invalidated -> magnifier.requestLayout());
        magnifier.zoomProperty().addListener(invalidated -> magnifier.requestLayout());
        this.picker.translateXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double halfPickerW = this.picker.getWidth() / 2.0;
            double halfLensW = this.lensContainer.getWidth() / 2.0;
            return this.lensContainer.getTranslateX() - (halfPickerW - halfLensW);
        }, (Observable[])new Observable[]{magnifier.pickedColorProperty(), this.picker.widthProperty(), this.lensContainer.widthProperty(), this.lensContainer.translateXProperty()}));
        this.picker.translateYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double value;
            VPos pos = magnifier.getPickerPos();
            if (pos == VPos.TOP) {
                double pickerH = this.picker.getHeight();
                value = this.lensContainer.getTranslateY() - pickerH - magnifier.getPickerSpacing();
            } else {
                double lensHeight = this.lensContainer.getHeight();
                value = this.lensContainer.getTranslateY() + lensHeight + magnifier.getPickerSpacing();
            }
            return value;
        }, (Observable[])new Observable[]{magnifier.pickedColorProperty(), magnifier.pickerPosProperty(), magnifier.pickerSpacingProperty(), this.picker.heightProperty(), this.lensContainer.heightProperty(), this.lensContainer.translateYProperty()}));
    }

    private void updatePosition(MouseEvent me) {
        MFXMagnifierPane magnifier = (MFXMagnifierPane)this.getSkinnable();
        double meX = me.getX();
        double meY = me.getY();
        double magnWidth = magnifier.getWidth();
        double magnHeight = magnifier.getHeight();
        if (meX < 0.0 || meY < 0.0 || meX > magnWidth || meY > magnHeight) {
            this.lensContainer.setVisible(false);
            return;
        }
        magnifier.setPosition(new PositionBean(meX, meY));
        this.lensContainer.setVisible(true);
        this.updateMagnifier();
    }

    private void updateMagnifier() {
        MFXMagnifierPane magnifier = (MFXMagnifierPane)this.getSkinnable();
        PositionBean position = magnifier.getPosition();
        this.lensContainer.setTranslateX(position.getX() - this.lensContainer.getWidth() / 2.0);
        this.lensContainer.setTranslateY(position.getY() - this.lensContainer.getHeight() / 2.0);
        Node content = magnifier.getContent();
        if (content == null) {
            return;
        }
        double size = magnifier.getLensSize();
        SnapshotParameters params = this.snapshotParamsFor(position, size, size);
        content.snapshot(x$0 -> this.lens.update((SnapshotResult)x$0), params, null);
    }

    private void updateZoom(ScrollEvent se) {
        ScrollUtils.ScrollDirection scrollDirection = ScrollUtils.determineScrollDirection(se);
        switch (scrollDirection) {
            case UP: {
                this.lens.zoomIn();
                break;
            }
            case DOWN: {
                this.lens.zoomOut();
            }
        }
        this.updateMagnifier();
    }

    private SnapshotParameters snapshotParamsFor(PositionBean positionBean, double width, double height) {
        MFXMagnifierPane magnifier = (MFXMagnifierPane)this.getSkinnable();
        SnapshotParameters sp = new SnapshotParameters();
        double offset = magnifier.getLensSize() / (magnifier.getZoom() - (magnifier.getZoom() - magnifier.getMinZoom()));
        double xOffset = positionBean.getX() - offset;
        double yOffset = positionBean.getY() - offset;
        sp.setViewport(new Rectangle2D(xOffset, yOffset, width, height));
        return sp;
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        this.picker.autosize();
        MFXMagnifierPane magnifier = (MFXMagnifierPane)this.getSkinnable();
        double lensSize = magnifier.getLensSize();
        double zoom = magnifier.getZoom();
        double size = lensSize * zoom;
        this.lensContainer.resize(size, size);
        if (magnifier.getPosition() != null) {
            this.updateMagnifier();
        }
    }

    class MFXMagnifierLens
    extends StackPane {
        private final String STYLE_CLASS = "lens";
        private final ObjectProperty<Image> image = new SimpleObjectProperty<Image>(){

            public void set(Image newValue) {
                super.set(newValue != null ? MFXMagnifierLens.this.postProcess(newValue) : null);
            }
        };
        private final ImageView view;
        private final Rectangle cursor;
        private final Label zoomLabel;
        private final Animation zlShowAnimation;
        private final PauseTransition zlHideAnimation;

        MFXMagnifierLens() {
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            magnifier.magnifierViewProperty().bind(this.image);
            this.view = new ImageView();
            this.view.imageProperty().bind(this.image);
            this.cursor = new Rectangle(1.0, 1.0, (Paint)Color.TRANSPARENT);
            this.cursor.setManaged(false);
            this.cursor.getStyleClass().add((Object)"cursor");
            this.cursor.visibleProperty().bind((ObservableValue)magnifier.hideCursorProperty().not());
            this.updateZoom(0.0);
            this.zoomLabel = new Label();
            this.zoomLabel.textProperty().bind((ObservableValue)magnifier.zoomProperty().asString());
            this.zoomLabel.visibleProperty().bind((ObservableValue)magnifier.showZoomLabelProperty());
            this.zoomLabel.setManaged(false);
            this.zoomLabel.setOpacity(0.0);
            this.zlHideAnimation = AnimationUtils.PauseBuilder.build().setDuration(magnifier.getHideZoomLabelAfter()).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(400.0, this.zoomLabel.opacityProperty(), Double.valueOf(0.0), Interpolator.EASE_BOTH)).getAnimation().play())).getAnimation();
            this.zlShowAnimation = AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(400.0, this.zoomLabel.opacityProperty(), Double.valueOf(1.0), Interpolator.EASE_BOTH)).getAnimation();
            magnifier.zoomProperty().addListener(invalidated -> {
                this.zlHideAnimation.stop();
                this.zlShowAnimation.play();
                this.zlHideAnimation.play();
            });
            this.zlHideAnimation.durationProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> Duration.millis((double)magnifier.getHideZoomLabelAfter()), (Observable[])new Observable[]{magnifier.hideZoomLabelAfterProperty()}));
            this.getStyleClass().add((Object)"lens");
            this.getChildren().addAll((Object[])new Node[]{this.view, this.cursor, this.zoomLabel});
        }

        private Void update(SnapshotResult snapshot) {
            this.setImage((Image)snapshot.getImage());
            return null;
        }

        private Image postProcess(Image input) {
            if (input == null) {
                throw new NullPointerException("Cannot post process null input!");
            }
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            Image output = input;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                double w = magnifier.getZoom() * input.getWidth();
                double h = magnifier.getZoom() * input.getHeight();
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage(input, null), "png", baos);
                output = new Image((InputStream)new ByteArrayInputStream(baos.toByteArray()), w, h, false, false);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return output;
        }

        private void zoomIn() {
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            if (magnifier.getZoom() == magnifier.getMaxZoom()) {
                return;
            }
            this.updateZoom(magnifier.getZoomIncrement());
        }

        private void zoomOut() {
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            if (magnifier.getZoom() == magnifier.getMinZoom()) {
                return;
            }
            this.updateZoom(-magnifier.getZoomIncrement());
        }

        private void updateZoom(double increment) {
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            magnifier.setZoom(magnifier.getZoom() + increment);
            this.cursor.setScaleX(magnifier.getZoom());
            this.cursor.setScaleY(magnifier.getZoom());
        }

        protected double computeMinWidth(double height) {
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            return magnifier.getLensSize();
        }

        protected double computeMinHeight(double width) {
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            return magnifier.getLensSize();
        }

        protected void layoutChildren() {
            super.layoutChildren();
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            double zoom = magnifier.getZoom() / 2.0;
            MFXMagnifierLens.layoutInArea((Node)this.cursor, (double)zoom, (double)zoom, (double)this.getWidth(), (double)this.getHeight(), (double)0.0, (Insets)this.getPadding(), (boolean)false, (boolean)false, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (boolean)false);
            MFXMagnifierLens.layoutInArea((Node)this.zoomLabel, (double)-10.0, (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (double)0.0, (Insets)this.getPadding(), (boolean)false, (boolean)false, (HPos)HPos.RIGHT, (VPos)VPos.CENTER, (boolean)true);
        }

        public Image getImage() {
            return (Image)this.image.get();
        }

        public ObjectProperty<Image> imageProperty() {
            return this.image;
        }

        public void setImage(Image image) {
            this.image.set((Object)image);
        }
    }

    class ColorPicker
    extends HBox {
        private final String STYLE_CLASS = "color-picker";
        private final Rectangle colorSquare;
        private final Label colorLabel;

        ColorPicker() {
            MFXMagnifierPane magnifier = (MFXMagnifierPane)MFXMagnifierPaneSkin.this.getSkinnable();
            this.setSpacing(10.0);
            this.setAlignment(Pos.CENTER);
            this.visibleProperty().bind((ObservableValue)magnifier.pickedColorProperty().isNotNull().and((ObservableBooleanValue)MFXMagnifierPaneSkin.this.lensContainer.visibleProperty()));
            this.colorSquare = new Rectangle(20.0, 20.0);
            this.colorSquare.getStyleClass().add((Object)"color-square");
            this.colorSquare.fillProperty().bind(magnifier.pickedColorProperty());
            this.colorLabel = new Label();
            this.colorLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                StringConverter<Color> converter = magnifier.getColorConverter();
                Color color = magnifier.getPickedColor();
                return converter != null ? converter.toString((Object)color) : color.toString();
            }, (Observable[])new Observable[]{magnifier.contentProperty(), magnifier.pickedColorProperty()}));
            this.colorLabel.setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow((Node)this.colorLabel, (Priority)Priority.ALWAYS);
            this.getStyleClass().add((Object)"color-picker");
            this.getChildren().addAll((Object[])new Node[]{this.colorSquare, this.colorLabel});
        }
    }
}

