/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.Alignment;
import io.github.palexdev.materialfx.controls.MFXContextMenu;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXNotificationCenter;
import io.github.palexdev.materialfx.controls.MFXPopup;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.controls.MFXToggleButton;
import io.github.palexdev.materialfx.controls.cell.MFXNotificationCell;
import io.github.palexdev.materialfx.enums.NotificationCounterStyle;
import io.github.palexdev.materialfx.enums.NotificationState;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.notifications.base.INotification;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.virtualizedfx.unused.simple.SimpleVirtualFlow;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.css.Styleable;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;

public class MFXNotificationCenterSkin
extends SkinBase<MFXNotificationCenter> {
    private final MFXIconWrapper bellWrapped = new MFXIconWrapper("fas-bell", 36.0, 56.0);
    private final NotificationsCounter counter;
    private final MFXPopup popup;

    public MFXNotificationCenterSkin(MFXNotificationCenter notificationCenter, SimpleVirtualFlow<INotification, MFXNotificationCell> virtualFlow) {
        super((Control)notificationCenter);
        this.bellWrapped.getIcon().setMouseTransparent(true);
        this.bellWrapped.getStyleClass().add((Object)"notifications-icon");
        this.counter = new NotificationsCounter();
        this.counter.setManaged(false);
        MFXTextField headerLabel = MFXTextField.asLabel();
        headerLabel.textProperty().bind((ObservableValue)notificationCenter.headerTextPropertyProperty());
        headerLabel.setAlignment(Pos.CENTER_LEFT);
        headerLabel.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)headerLabel, (Priority)Priority.ALWAYS);
        MFXToggleButton dndToggle = new MFXToggleButton(I18N.getOrDefault("notificationCenter.dnd", new Object[0]));
        dndToggle.setContentDisplay(ContentDisplay.RIGHT);
        dndToggle.setGraphicTextGap(15.0);
        notificationCenter.doNotDisturbProperty().bindBidirectional((Property)dndToggle.selectedProperty());
        HBox header = new HBox(new Node[]{headerLabel, dndToggle});
        header.getStyleClass().add((Object)"header");
        header.setAlignment(Pos.CENTER_LEFT);
        MFXIconWrapper select = new MFXIconWrapper("fas-check", 24.0, 36.0).defaultRippleGeneratorBehavior();
        MFXIconWrapper markAsRead = new MFXIconWrapper("fas-eye", 20.0, 36.0).defaultRippleGeneratorBehavior();
        MFXIconWrapper markAsUnread = new MFXIconWrapper("fas-eye-slash", 20.0, 36.0).defaultRippleGeneratorBehavior();
        MFXIconWrapper dismiss = new MFXIconWrapper("fas-trash", 20.0, 36.0).defaultRippleGeneratorBehavior();
        MFXIconWrapper options = new MFXIconWrapper("fas-ellipsis", 18.0, 36.0).defaultRippleGeneratorBehavior();
        select.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> notificationCenter.setSelectionMode(!notificationCenter.isSelectionMode()));
        markAsRead.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> notificationCenter.markSelectedNotificationsAs(NotificationState.READ));
        markAsUnread.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> notificationCenter.markSelectedNotificationsAs(NotificationState.UNREAD));
        dismiss.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> notificationCenter.dismissSelected());
        options.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            MFXContextMenu contextMenu = notificationCenter.getMFXContextMenu();
            Bounds toScreen = options.localToScreen(options.getLayoutBounds());
            contextMenu.show((Node)options, toScreen.getMinX(), toScreen.getMinY());
        });
        NodeUtils.makeRegionCircular((Region)select);
        NodeUtils.makeRegionCircular((Region)markAsRead);
        NodeUtils.makeRegionCircular((Region)markAsUnread);
        NodeUtils.makeRegionCircular((Region)dismiss);
        NodeUtils.makeRegionCircular((Region)options);
        HBox actions = new HBox(40.0, new Node[]{select, markAsRead, markAsUnread, dismiss, options});
        actions.getStyleClass().add((Object)"actions");
        actions.setAlignment(Pos.CENTER);
        BorderPane borderPane = new BorderPane();
        borderPane.setTop((Node)header);
        borderPane.setCenter(virtualFlow);
        borderPane.setBottom((Node)actions);
        borderPane.getStyleClass().add((Object)"notifications-container");
        borderPane.setMinHeight(Double.NEGATIVE_INFINITY);
        borderPane.setMaxHeight(Double.NEGATIVE_INFINITY);
        borderPane.prefWidthProperty().bind((ObservableValue)notificationCenter.popupWidthProperty());
        borderPane.prefHeightProperty().bind((ObservableValue)notificationCenter.popupHeightProperty());
        BorderPane.setMargin(virtualFlow, (Insets)InsetsFactory.all(5.0));
        this.popup = new MFXPopup((Node)borderPane){

            @Override
            public Styleable getStyleableParent() {
                return MFXNotificationCenterSkin.this.getSkinnable();
            }
        };
        this.popup.getStyleClass().add((Object)"popup");
        this.popup.setAnimated(false);
        this.popup.setConsumeAutoHidingEvents(true);
        this.getChildren().setAll((Object[])new Node[]{this.bellWrapped, this.counter});
        this.addListeners();
    }

    private void addListeners() {
        MFXNotificationCenter notificationCenter = (MFXNotificationCenter)this.getSkinnable();
        this.popup.showingProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && notificationCenter.isShowing()) {
                notificationCenter.setShowing(false);
            }
        });
        this.bellWrapped.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> notificationCenter.getOnIconClicked().handle(event));
        notificationCenter.showingProperty().addListener((observable, oldValue, newValue) -> this.managePopup((boolean)newValue));
        notificationCenter.addEventFilter(MFXPopup.MFXPopupEvent.REPOSITION_EVENT, event -> this.popup.reposition());
        notificationCenter.popupHoverProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.popup.isHover() || notificationCenter.getMFXContextMenu().isShowing(), (Observable[])new Observable[]{this.popup.hoverProperty(), notificationCenter.getMFXContextMenu().showingProperty()}));
    }

    protected void managePopup(boolean showing) {
        if (!showing) {
            this.popup.hide();
            return;
        }
        this.popup.show((Node)this.bellWrapped, Alignment.of(HPos.CENTER, VPos.BOTTOM), 0.0, ((MFXNotificationCenter)this.getSkinnable()).getPopupSpacing());
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.bellWrapped.prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.bellWrapped.prefHeight(-1.0);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        double bellCenterX = this.bellWrapped.getBoundsInParent().getCenterX();
        double bellCenterY = this.bellWrapped.getBoundsInParent().getCenterY();
        double radius = this.bellWrapped.getSize() / 2.0;
        double angle = 45.0;
        double angleToRadians = Math.PI / 180;
        double size = this.counter.getSize();
        double counterX = bellCenterX + radius * Math.cos(angle * angleToRadians) - size / 2.0;
        double counterY = bellCenterY - radius * Math.sin(angle * angleToRadians) - size / 2.0;
        this.counter.resizeRelocate(counterX, counterY, size, size);
    }

    private class NotificationsCounter
    extends MFXIconWrapper {
        public NotificationsCounter() {
            MFXNotificationCenter notificationCenter = (MFXNotificationCenter)MFXNotificationCenterSkin.this.getSkinnable();
            Text counterText = new Text();
            counterText.getStyleClass().add((Object)"text");
            counterText.textProperty().addListener(invalidated -> {
                double padding = notificationCenter.getCounterStyle() == NotificationCounterStyle.DOT ? 3.0 : 7.0;
                double textW = counterText.prefWidth(-1.0);
                double textH = counterText.prefHeight(-1.0);
                double size = textW > textH ? this.snapSizeX(textW + padding) : this.snapSizeY(textH + padding);
                this.setSize(size);
                notificationCenter.requestLayout();
                this.requestLayout();
            });
            counterText.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> notificationCenter.getCounterStyle() == NotificationCounterStyle.NUMBER, (Observable[])new Observable[]{notificationCenter.counterStyleProperty()}));
            counterText.textProperty().bind((ObservableValue)notificationCenter.unreadCountProperty().asString());
            counterText.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> notificationCenter.getCounterStyle() == NotificationCounterStyle.NUMBER ? Long.toString(notificationCenter.getUnreadCount()) : "", (Observable[])new Observable[]{notificationCenter.unreadCountProperty(), notificationCenter.counterStyleProperty()}));
            counterText.setMouseTransparent(true);
            this.getStyleClass().add((Object)"counter");
            this.visibleProperty().bind((ObservableValue)notificationCenter.unreadCountProperty().greaterThan(0));
            this.setIcon((Node)counterText);
        }
    }
}

