/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXRectangleToggleNode;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.TextUtils;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;

public class MFXRectangleToggleNodeSkin
extends SkinBase<MFXRectangleToggleNode> {
    private final StackPane container;
    private final MFXTextField label = new MFXTextField();
    private final MFXCircleRippleGenerator rippleGenerator;

    public MFXRectangleToggleNodeSkin(MFXRectangleToggleNode toggleNode) {
        super((Control)toggleNode);
        this.label.alignmentProperty().bind((ObservableValue)toggleNode.alignmentProperty());
        this.label.fontProperty().bind((ObservableValue)toggleNode.fontProperty());
        this.label.graphicTextGapProperty().bind((ObservableValue)toggleNode.graphicTextGapProperty());
        this.label.textProperty().bind((ObservableValue)toggleNode.textProperty());
        this.label.textFillProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> (Color)toggleNode.getTextFill(), (Observable[])new Observable[]{toggleNode.textFillProperty()}));
        this.label.setLeadingIcon(toggleNode.getLabelLeadingIcon());
        this.label.setTrailingIcon(toggleNode.getLabelTrailingIcon());
        this.label.setEditable(false);
        this.label.setSelectable(false);
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.label.setMouseTransparent(true);
        this.container = new StackPane();
        this.container.alignmentProperty().bind((ObservableValue)toggleNode.alignmentProperty());
        this.rippleGenerator = new MFXCircleRippleGenerator((Region)this.container);
        this.rippleGenerator.setManaged(false);
        this.container.getChildren().setAll((Object[])new Node[]{this.rippleGenerator, this.label});
        this.handleGraphics();
        this.setupRippleGenerator();
        this.setListeners();
        this.getChildren().setAll((Object[])new Node[]{this.container});
    }

    protected void setupRippleGenerator() {
        MFXRectangleToggleNode toggleNode = (MFXRectangleToggleNode)this.getSkinnable();
        this.rippleGenerator.setAnimateBackground(false);
        this.rippleGenerator.setClipSupplier(() -> toggleNode.getRippleClipTypeFactory().build((Region)this.container));
        this.rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
        this.rippleGenerator.rippleRadiusProperty().bind((ObservableValue)toggleNode.widthProperty().divide(2.0));
    }

    private void setListeners() {
        MFXRectangleToggleNode toggleNode = (MFXRectangleToggleNode)this.getSkinnable();
        toggleNode.rippleClipTypeFactoryProperty().addListener((observable, oldValue, newValue) -> this.rippleGenerator.setClipSupplier(() -> newValue.build((Region)this.container)));
        toggleNode.graphicProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.container.getChildren().remove(oldValue);
            }
            this.handleGraphics();
        });
        toggleNode.labelLeadingIconProperty().addListener((observable, oldValue, newValue) -> this.handleGraphics());
        toggleNode.labelTrailingIconProperty().addListener((observable, oldValue, newValue) -> this.handleGraphics());
        this.container.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            Node leadingIcon = this.label.getLeadingIcon();
            Node trailingIcon = this.label.getTrailingIcon();
            if (leadingIcon != null && NodeUtils.inHierarchy(event, leadingIcon)) {
                return;
            }
            if (trailingIcon != null && NodeUtils.inHierarchy(event, trailingIcon)) {
                return;
            }
            toggleNode.fire();
            this.rippleGenerator.generateRipple((MouseEvent)event);
        });
    }

    protected void handleGraphics() {
        MFXRectangleToggleNode toggleNode = (MFXRectangleToggleNode)this.getSkinnable();
        Node graphic = toggleNode.getGraphic();
        Node leading = toggleNode.getLabelLeadingIcon();
        Node trailing = toggleNode.getLabelTrailingIcon();
        this.label.setLeadingIcon(leading);
        this.label.setTrailingIcon(trailing);
        if (leading != null || trailing != null) {
            this.label.setVisible(graphic == null);
        }
        if (graphic != null) {
            this.label.setVisible(false);
            if (!this.container.getChildren().contains((Object)graphic)) {
                this.container.getChildren().add((Object)graphic);
            }
        } else {
            this.label.setVisible(true);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXRectangleToggleNode toggleNode = (MFXRectangleToggleNode)this.getSkinnable();
        Node graphic = toggleNode.getGraphic();
        if (graphic != null) {
            return leftInset + graphic.prefWidth(-1.0) + rightInset;
        }
        double gap = this.label.getGraphicTextGap();
        Node leading = toggleNode.getLabelLeadingIcon();
        Node trailing = toggleNode.getLabelTrailingIcon();
        double textWidth = TextUtils.computeTextWidth(toggleNode.getFont(), toggleNode.getText()) + this.label.snappedLeftInset() + this.label.snappedRightInset() + 10.0;
        return leftInset + (leading != null ? leading.prefWidth(-1.0) + gap : 0.0) + textWidth + (trailing != null ? trailing.prefWidth(-1.0) + gap : 0.0) + rightInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXRectangleToggleNode)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXRectangleToggleNode)this.getSkinnable()).prefHeight(-1.0);
    }
}

