/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.MFXSpinner;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.controls.models.spinner.SpinnerModel;
import io.github.palexdev.materialfx.enums.FloatMode;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.TextUtils;
import java.util.function.BiFunction;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.util.StringConverter;

public class MFXSpinnerSkin<T>
extends SkinBase<MFXSpinner<T>> {
    private final BorderPane container;
    private final MFXTextField field = new MFXTextField();
    private Node nextIcon;
    private Node prevIcon;
    private ChangeListener<SpinnerModel<T>> modelListener;
    private ChangeListener<StringConverter<T>> converterListener;
    private StringBinding textBinding;
    private static final PseudoClass FOCUS_WITHIN_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"focus-within");

    public MFXSpinnerSkin(MFXSpinner<T> spinner) {
        super(spinner);
        this.field.setFloatMode(FloatMode.DISABLED);
        this.field.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.field.allowEditProperty().bind((ObservableValue)spinner.editableProperty());
        this.field.selectableProperty().bind((ObservableValue)spinner.selectableProperty());
        this.field.promptTextProperty().bind((ObservableValue)spinner.promptTextProperty());
        this.textBinding = Bindings.createStringBinding(() -> {
            Object value = spinner.getValue();
            SpinnerModel model = spinner.getSpinnerModel();
            String s = model == null ? (value != null ? value.toString() : "") : model.getConverter().toString(value);
            BiFunction<Boolean, String, String> textTransformer = spinner.getTextTransformer();
            return textTransformer != null ? textTransformer.apply(this.field.delegateIsFocused(), s) : s;
        }, (Observable[])new Observable[]{spinner.valueProperty(), spinner.spinnerModelProperty(), this.field.delegateFocusedProperty()});
        if (this.textBinding.get() != null && !this.textBinding.get().isEmpty()) {
            this.field.setText(this.textBinding.get());
        }
        this.modelListener = (observable, oldValue, newValue) -> this.initializeModel((SpinnerModel<T>)oldValue, (SpinnerModel<T>)newValue);
        this.converterListener = (observable, oldValue, newValue) -> this.textBinding.invalidate();
        this.nextIcon = spinner.getNextIconSupplier() != null ? spinner.getNextIconSupplier().get() : null;
        this.prevIcon = spinner.getPrevIconSupplier() != null ? spinner.getPrevIconSupplier().get() : null;
        this.container = new BorderPane();
        this.manageContainer();
        this.manageGap();
        this.getChildren().setAll((Object[])new Node[]{this.container});
        this.addListeners();
    }

    private void addListeners() {
        MFXSpinner spinner = (MFXSpinner)this.getSkinnable();
        spinner.spinnerModelProperty().addListener(this.modelListener);
        this.textBinding.addListener(invalidated -> this.field.setText(this.textBinding.getValue()));
        this.field.delegateFocusedProperty().addListener((observable, oldValue, newValue) -> spinner.pseudoClassStateChanged(FOCUS_WITHIN_PSEUDO_CLASS, (boolean)newValue));
        spinner.orientationProperty().addListener(invalidated -> this.manageContainer());
        spinner.graphicTextGapProperty().addListener(invalidated -> this.manageGap());
        spinner.prevIconSupplierProperty().addListener((observable, oldValue, newValue) -> {
            this.prevIcon = newValue != null ? (Node)newValue.get() : null;
            this.manageContainer();
        });
        spinner.nextIconSupplierProperty().addListener((observable, oldValue, newValue) -> {
            this.nextIcon = newValue != null ? (Node)newValue.get() : null;
            this.manageContainer();
        });
        spinner.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            if (NodeUtils.inHierarchy(event, this.nextIcon) || NodeUtils.inHierarchy(event, this.prevIcon)) {
                boolean iconsFocused = this.nextIcon != null && this.nextIcon.isFocused() || this.prevIcon != null && this.prevIcon.isFocused();
                spinner.pseudoClassStateChanged(FOCUS_WITHIN_PSEUDO_CLASS, iconsFocused);
                return;
            }
            spinner.pseudoClassStateChanged(FOCUS_WITHIN_PSEUDO_CLASS, false);
            spinner.requestFocus();
        });
        spinner.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            switch (event.getCode()) {
                case ENTER: {
                    spinner.commit(this.field.getText());
                    break;
                }
                case Z: {
                    SpinnerModel model;
                    if (!event.isControlDown() || !event.isShiftDown() || (model = spinner.getSpinnerModel()) == null) break;
                    String s = model.getConverter().toString(spinner.getValue());
                    this.field.setText(s);
                }
            }
        });
    }

    private void manageContainer() {
        MFXSpinner spinner = (MFXSpinner)this.getSkinnable();
        Orientation orientation = spinner.getOrientation();
        this.container.getChildren().clear();
        if (orientation == Orientation.HORIZONTAL) {
            if (this.prevIcon != null) {
                this.container.setLeft(this.prevIcon);
            }
            if (this.nextIcon != null) {
                this.container.setRight(this.nextIcon);
            }
        } else {
            if (this.nextIcon != null) {
                this.container.setTop(this.nextIcon);
            }
            if (this.prevIcon != null) {
                this.container.setBottom(this.prevIcon);
            }
        }
        this.container.setCenter((Node)this.field);
        this.manageGap();
    }

    private void manageGap() {
        MFXSpinner spinner = (MFXSpinner)this.getSkinnable();
        Orientation orientation = spinner.getOrientation();
        double gap = spinner.getGraphicTextGap();
        if (orientation == Orientation.HORIZONTAL) {
            if (this.prevIcon != null) {
                BorderPane.setMargin((Node)this.prevIcon, (Insets)InsetsFactory.right(gap));
            }
            if (this.nextIcon != null) {
                BorderPane.setMargin((Node)this.nextIcon, (Insets)InsetsFactory.left(gap));
            }
        } else {
            if (this.prevIcon != null) {
                BorderPane.setMargin((Node)this.prevIcon, (Insets)InsetsFactory.top(gap));
            }
            if (this.nextIcon != null) {
                BorderPane.setMargin((Node)this.nextIcon, (Insets)InsetsFactory.bottom(gap));
            }
        }
    }

    private void initializeModel(SpinnerModel<T> oldModel, SpinnerModel<T> newModel) {
        if (oldModel != newModel) {
            oldModel.converterProperty().removeListener(this.converterListener);
        }
        if (newModel != null) {
            newModel.converterProperty().addListener(this.converterListener);
        }
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return super.computeMinWidth(height, topInset, rightInset, bottomInset, leftInset) + 5.0;
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        MFXSpinner spinner = (MFXSpinner)this.getSkinnable();
        Orientation orientation = spinner.getOrientation();
        double gap = spinner.getGraphicTextGap();
        double textW = this.field.snappedLeftInset() + Math.max(TextUtils.computeTextWidth(this.field.getFont(), this.field.getText()), TextUtils.computeTextWidth(this.field.getFont(), this.field.getPromptText())) + this.field.snappedRightInset();
        double prevIconW = this.prevIcon.prefWidth(-1.0);
        double nextIconW = this.nextIcon.prefWidth(-1.0);
        if (orientation == Orientation.HORIZONTAL) {
            return leftInset + (this.prevIcon != null ? prevIconW + gap : 0.0) + textW + (this.nextIcon != null ? nextIconW + gap : 0.0) + rightInset;
        }
        return leftInset + Math.max(textW, Math.max(prevIconW, nextIconW)) + rightInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXSpinner)this.getSkinnable()).prefWidth(-1.0);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXSpinner)this.getSkinnable()).prefHeight(-1.0);
    }

    public void dispose() {
        super.dispose();
        this.textBinding = null;
        this.modelListener = null;
        this.converterListener = null;
    }
}

