/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.BoundLabel;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXTableColumn;
import io.github.palexdev.materialfx.enums.SortState;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.utils.DragResizer;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.PositionUtils;
import java.util.Comparator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class MFXTableColumnSkin<T>
extends SkinBase<MFXTableColumn<T>> {
    private final HBox container;
    private final BoundLabel label;
    private final MFXIconWrapper sortIcon;
    private final DragResizer dragResizer;

    public MFXTableColumnSkin(MFXTableColumn<T> column) {
        super(column);
        this.label = new BoundLabel(column);
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        this.sortIcon = new MFXIconWrapper("fas-caret-up", 14.0, 18.0).defaultRippleGeneratorBehavior();
        NodeUtils.makeRegionCircular((Region)this.sortIcon);
        this.container = new HBox(new Node[]{this.label});
        this.container.setMinWidth(Double.NEGATIVE_INFINITY);
        this.positionIcon(column.getAlignment());
        this.dragResizer = new DragResizer((Region)column, DragResizer.Direction.RIGHT).setWidthConstraintFunction(region -> region.snappedLeftInset() + region.prefWidth(-1.0) + region.snappedRightInset());
        if (column.isColumnResizable()) {
            this.dragResizer.makeResizable();
        }
        this.getChildren().setAll((Object[])new Node[]{this.container});
        this.addListeners();
    }

    private void addListeners() {
        MFXTableColumn column = (MFXTableColumn)this.getSkinnable();
        column.alignmentProperty().addListener((observable, oldValue, newValue) -> this.positionIcon((Pos)newValue));
        column.sortStateProperty().addListener((observable, oldValue, newValue) -> this.animateIcon((SortState)((Object)newValue)));
        column.columnResizableProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.dragResizer.uninstall();
            } else {
                this.dragResizer.makeResizable();
            }
        });
        NodeUtils.waitForSkin((Control)column, () -> {
            SortState sortState = column.getSortState();
            this.animateIcon(sortState);
            if (sortState == SortState.UNSORTED) {
                return;
            }
            Comparator comparator = sortState == SortState.DESCENDING ? column.getComparator().reversed() : column.getComparator();
            column.fireEvent(new MFXTableColumn.MFXTableColumnEvent(MFXTableColumn.MFXTableColumnEvent.SORTING_EVENT, column, comparator, sortState));
        }, false, true);
    }

    private void animateIcon(SortState sortState) {
        Timeline animation = new Timeline();
        switch (sortState) {
            case ASCENDING: {
                this.sortIcon.setVisible(true);
                animation = MFXAnimationFactory.FADE_IN.build((Node)this.sortIcon, 250.0);
                break;
            }
            case DESCENDING: {
                this.sortIcon.setVisible(true);
                KeyFrame kf = new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{new KeyValue((WritableValue)this.sortIcon.rotateProperty(), (Object)180)});
                animation = new Timeline(new KeyFrame[]{kf});
                break;
            }
            case UNSORTED: {
                animation = MFXAnimationFactory.FADE_OUT.build((Node)this.sortIcon, 250.0);
                animation.setOnFinished(event -> {
                    this.sortIcon.setVisible(false);
                    this.sortIcon.setRotate(0.0);
                });
            }
        }
        animation.play();
    }

    private void positionIcon(Pos alignment) {
        this.container.getChildren().remove((Object)this.sortIcon);
        if (PositionUtils.isRight(alignment)) {
            this.container.getChildren().add(0, (Object)this.sortIcon);
            return;
        }
        this.container.getChildren().add((Object)this.sortIcon);
    }
}

