/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PopupPositionBean;
import io.github.palexdev.materialfx.controls.MFXTooltip;
import java.util.List;
import javafx.animation.Animation;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.WindowEvent;

public class MFXTooltipSkin
implements Skin<MFXTooltip> {
    private MFXTooltip tooltip;
    private final StackPane container;
    private final Label label;
    private final Scale scale;
    private Animation animation;
    private EventHandler<WindowEvent> initHandler;
    private EventHandler<WindowEvent> closeHandler;

    public MFXTooltipSkin(MFXTooltip tooltip) {
        this.tooltip = tooltip;
        this.label = new Label();
        this.label.setWrapText(true);
        this.label.textProperty().bind((ObservableValue)tooltip.textProperty());
        this.label.graphicProperty().bind(tooltip.iconProperty());
        this.scale = new Scale(0.1, 0.1, 0.0, 0.0);
        this.container = new StackPane(new Node[]{this.label});
        this.container.getStyleClass().add((Object)"container");
        this.container.getTransforms().addAll((Object[])new Transform[]{this.scale});
        tooltip.setContent((Node)this.container);
        this.initHandler = event -> {
            this.init();
            if (tooltip.isAnimated()) {
                this.animation = tooltip.getAnimationProvider().apply((Node)this.container, this.scale);
                this.animation.play();
            } else {
                this.scale.setX(1.0);
                this.scale.setY(1.0);
                this.container.setOpacity(1.0);
            }
        };
        this.closeHandler = event -> {
            this.container.setOpacity(0.0);
            this.scale.setX(0.1);
            this.scale.setY(0.1);
        };
        tooltip.addEventHandler(WindowEvent.WINDOW_SHOWN, this.initHandler);
        tooltip.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.closeHandler);
        Bindings.bindContent((List)this.container.getStylesheets(), tooltip.getStyleSheets());
    }

    protected void init() {
        this.container.setOpacity(0.0);
        PopupPositionBean position = this.tooltip.getPosition();
        if (position == null) {
            return;
        }
        if (position.getAlignment() != null) {
            double containerW = this.container.prefWidth(-1.0);
            double containerH = this.container.prefHeight(-1.0);
            HPos hPos = position.getHPos();
            VPos vPos = position.getVPos();
            double xOffset = position.getXOffset();
            double yOffset = position.getYOffset();
            double px = hPos == HPos.RIGHT ? xOffset : containerW + xOffset;
            double py = vPos == VPos.BOTTOM ? yOffset : containerH + yOffset;
            this.scale.setPivotX(px);
            this.scale.setPivotY(py);
        }
        this.tooltip.reposition();
    }

    public MFXTooltip getSkinnable() {
        return this.tooltip;
    }

    public Node getNode() {
        return this.container;
    }

    public void dispose() {
        this.animation.stop();
        this.animation = null;
        this.tooltip.removeEventHandler(WindowEvent.WINDOW_SHOWN, this.initHandler);
        this.tooltip.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.closeHandler);
        this.initHandler = null;
        this.closeHandler = null;
        this.tooltip = null;
    }
}

