/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import java.util.HashSet;
import java.util.Set;

public class ListChangeProcessor {
    private Set<Integer> indexes;

    public ListChangeProcessor(Set<Integer> indexes) {
        this.indexes = indexes;
    }

    public void computeAddition(int addedSize, int offset) {
        int max = this.indexes.stream().max(Integer::compare).orElse(-1);
        if (max != -1 && offset > max) {
            return;
        }
        HashSet<Integer> tmp = new HashSet<Integer>(this.indexes);
        for (Integer i : this.indexes) {
            tmp.remove(i);
            int index = i + addedSize;
            tmp.add(index);
        }
        this.indexes = tmp;
    }

    public void computeRemoval(Set<Integer> removed, int offset) {
        int min = this.indexes.stream().min(Integer::compare).orElse(-1);
        int max = this.indexes.stream().max(Integer::compare).orElse(-1);
        if (min == -1 || offset > max) {
            return;
        }
        HashSet<Integer> tmp = new HashSet<Integer>();
        for (Integer i : this.indexes) {
            if (i < offset) {
                tmp.add(i);
                continue;
            }
            int index = Math.max(i - this.findShift(removed, i), 0);
            tmp.add(index);
        }
        this.indexes = tmp;
    }

    private int findShift(Set<Integer> removed, int index) {
        return (int)removed.stream().filter(i -> i <= index).count();
    }

    public Set<Integer> getIndexes() {
        return this.indexes;
    }
}

