/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.utils;

import javafx.event.EventHandler;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;

public class ToggleButtonsUtil {
    private static final EventHandler<MouseEvent> consumeMouseEventFilter = mouseEvent -> {
        if (((Toggle)mouseEvent.getSource()).isSelected()) {
            mouseEvent.consume();
        }
    };

    private static void addConsumeMouseEventFilter(Toggle toggle) {
        ((ToggleButton)toggle).addEventFilter(MouseEvent.MOUSE_PRESSED, consumeMouseEventFilter);
        ((ToggleButton)toggle).addEventFilter(MouseEvent.MOUSE_RELEASED, consumeMouseEventFilter);
        ((ToggleButton)toggle).addEventFilter(MouseEvent.MOUSE_CLICKED, consumeMouseEventFilter);
    }

    public static void addAlwaysOneSelectedSupport(ToggleGroup toggleGroup) {
        toggleGroup.getToggles().addListener(c -> {
            while (c.next()) {
                for (Toggle addedToggle : c.getAddedSubList()) {
                    ToggleButtonsUtil.addConsumeMouseEventFilter(addedToggle);
                }
            }
        });
        toggleGroup.getToggles().forEach(ToggleButtonsUtil::addConsumeMouseEventFilter);
    }

    public static void clearSelectedToggle(ToggleGroup toggleGroup) {
        Toggle selectedToggle = toggleGroup.getSelectedToggle();
        if (!selectedToggle.isSelected()) {
            for (Toggle toggle : toggleGroup.getToggles()) {
                if (!toggle.isSelected()) continue;
                return;
            }
        }
        toggleGroup.selectToggle(null);
    }
}

