/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.enums.ChainMode;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import java.util.function.Predicate;

public class FilterBean<T, U> {
    private final String query;
    private final AbstractFilter<T, U> filter;
    private final BiPredicateBean<U, U> predicateBean;
    private ChainMode mode;

    public FilterBean(String query, AbstractFilter<T, U> filter, BiPredicateBean<U, U> predicateBean) {
        this(query, filter, predicateBean, ChainMode.OR);
    }

    public FilterBean(String query, AbstractFilter<T, U> filter, BiPredicateBean<U, U> predicateBean, ChainMode mode) {
        this.query = query;
        this.filter = filter;
        this.predicateBean = predicateBean;
        this.mode = mode;
    }

    public Predicate<T> predicate() {
        return this.filter.predicateFor(this.query, this);
    }

    public String getQuery() {
        return this.query;
    }

    public AbstractFilter<T, U> getFilter() {
        return this.filter;
    }

    public String getFilterName() {
        return this.filter.name();
    }

    public BiPredicateBean<U, U> getPredicateBean() {
        return this.predicateBean;
    }

    public String getPredicateName() {
        return this.predicateBean.name();
    }

    public ChainMode getMode() {
        return this.mode;
    }

    public void setMode(ChainMode mode) {
        this.mode = mode;
    }
}

