/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.beans.properties.synced;

import io.github.palexdev.materialfx.beans.properties.base.SynchronizedProperty;
import io.github.palexdev.materialfx.bindings.BiBindingManager;
import io.github.palexdev.materialfx.bindings.BindingManager;
import io.github.palexdev.materialfx.utils.ExecutionUtils;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;

public class SynchronizedStringProperty
extends SimpleStringProperty
implements SynchronizedProperty<String> {
    private final ReadOnlyBooleanWrapper waiting = new ReadOnlyBooleanWrapper();

    public SynchronizedStringProperty() {
        this.initialize();
    }

    public SynchronizedStringProperty(String initialValue) {
        super(initialValue);
        this.initialize();
    }

    public SynchronizedStringProperty(Object bean, String name) {
        super(bean, name);
        this.initialize();
    }

    public SynchronizedStringProperty(Object bean, String name, String initialValue) {
        super(bean, name, initialValue);
        this.initialize();
    }

    private void initialize() {
        ExecutionUtils.executeWhen((BooleanExpression)this.waiting, () -> {}, this::fireValueChangedEvent, false, false, false, false);
    }

    @Override
    public void setAndWait(String value, ObservableValue<?> observable) {
        if (!SynchronizedProperty.Helper.check(this, value, observable)) {
            return;
        }
        this.waiting.set(true);
        ExecutionUtils.executeWhen(observable, this::awake, false, () -> true, true);
        this.set(value);
    }

    @Override
    public boolean isWaiting() {
        return this.waiting.get();
    }

    @Override
    public ReadOnlyBooleanProperty waiting() {
        return this.waiting.getReadOnlyProperty();
    }

    @Override
    public void awake() {
        this.waiting.set(false);
    }

    protected void fireValueChangedEvent() {
        if (this.isWaiting()) {
            return;
        }
        super.fireValueChangedEvent();
    }

    public void bind(ObservableValue<? extends String> source) {
        if (this == source) {
            throw new IllegalArgumentException("Cannot bind to itself!");
        }
        if (this.isBound()) {
            this.unbind();
        }
        BindingManager.instance().bind(this).to(source).create();
    }

    public void bindBidirectional(Property<String> other) {
        if (this == other) {
            throw new IllegalArgumentException("Cannot bind to itself!");
        }
        if (this.isBound()) {
            this.unbind();
        }
        BiBindingManager.instance().bindBidirectional(this).to(other).create();
    }

    public void unbind() {
        BindingManager.instance().unbind(this);
    }

    public void unbindBidirectional(Property<String> other) {
        BiBindingManager.instance().unbind(this, other);
    }

    public void clearBidirectional() {
        BiBindingManager.instance().disposeFor(this);
    }

    public boolean isBound() {
        return BindingManager.instance().isBound((ObservableValue)this) && !BindingManager.instance().isIgnoreBinding((ObservableValue)this);
    }
}

