/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.bindings;

import io.github.palexdev.materialfx.bindings.BindingsMap;
import io.github.palexdev.materialfx.bindings.base.AbstractBindingHelper;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class BiBindingHelper<T>
extends AbstractBindingHelper<T> {
    protected boolean fromSource;
    protected boolean fromTarget;
    private final BindingsMap<ObservableValue<? extends T>, BiConsumer<T, T>> sources = new BindingsMap();
    private final ChangeListener<? super T> targetListener = (observable, oldValue, newValue) -> this.updateSources(oldValue, newValue);

    @Override
    public BiBindingHelper<T> bind(ObservableValue<? extends T> target) {
        this.target = target;
        target.addListener(this.targetListener);
        return this;
    }

    @Override
    public BiBindingHelper<T> with(BiConsumer<T, T> targetUpdater) {
        this.targetUpdater = targetUpdater;
        return this;
    }

    public BiBindingHelper<T> addSource(ObservableValue<? extends T> source, BiConsumer<T, T> updater) {
        this.sources.put(source, updater);
        this.beforeBind();
        source.addListener(this.sourceListener);
        this.afterBind();
        return this;
    }

    public BiBindingHelper<T> addSources(BindingsMap<ObservableValue<? extends T>, BiConsumer<T, T>> sources) {
        this.beforeBind();
        sources.keySet().forEach(observable -> observable.addListener(this.sourceListener));
        this.sources.combine(sources);
        this.afterBind();
        return this;
    }

    protected void updateSources(T oldValue, T newValue) {
        if (this.isFromTarget()) {
            return;
        }
        try {
            this.fromSource = true;
            this.beforeUpdateSources();
            this.sources.forEach((source, updater) -> this.updateSource((ObservableValue<? extends T>)source, (BiConsumer<T, T>)updater, oldValue, newValue));
            this.afterUpdateSources();
        }
        finally {
            this.fromSource = false;
        }
    }

    protected void updateSource(ObservableValue<? extends T> source, BiConsumer<T, T> updater, T oldValue, T newValue) {
        updater.accept(oldValue, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateTarget(ObservableValue<? extends T> updatingSource, T oldValue, T newValue) {
        if (this.isFromSource()) {
            return;
        }
        try {
            this.fromTarget = true;
            this.beforeUpdateTarget();
            this.targetUpdater.accept(oldValue, newValue);
            this.fromSource = true;
            this.sources.forEach((source, updater) -> {
                if (source == updatingSource) {
                    return;
                }
                this.updateSource((ObservableValue<? extends T>)source, (BiConsumer<T, T>)updater, oldValue, newValue);
            });
            this.afterUpdateTarget();
        }
        finally {
            this.fromTarget = false;
            this.fromSource = false;
        }
    }

    @Override
    public void invalidate() {
        ObservableValue<? extends T> lastSource = this.sources.getLastKey();
        if (lastSource != null) {
            Object value = lastSource.getValue();
            this.targetUpdater.accept(value, value);
        }
    }

    public void unbind(ObservableValue<? extends T> source) {
        if (this.sources.remove(source) != null) {
            this.beforeUnbind();
            source.removeListener(this.sourceListener);
            this.afterUnbind();
        }
    }

    public void clear() {
        this.sources.forEach((observable, updater) -> observable.removeListener(this.sourceListener));
        this.sources.clear();
    }

    @Override
    public void dispose() {
        this.clear();
        this.target.removeListener(this.targetListener);
        this.target = null;
    }

    protected void beforeUpdateSources() {
    }

    protected void afterUpdateSources() {
    }

    public boolean isFromTarget() {
        return this.fromTarget;
    }

    public boolean isFromSource() {
        return this.fromSource;
    }

    @Override
    public boolean isDispose() {
        return this.target == null;
    }

    public int size() {
        return this.sources.size();
    }

    protected BindingsMap<ObservableValue<? extends T>, BiConsumer<T, T>> getSources() {
        return this.sources;
    }

    public LinkedList<WeakReference<ObservableValue<? extends T>>> getUnmodifiableSources() {
        return this.sources.unmodifiableKeysList();
    }

    public static <T> BiBindingHelper<T> newFor(BiBindingHelper<T> first, BiBindingHelper<T> second, boolean overrideTargetUpdater) {
        BiBindingHelper<Object> newHelper = new BiBindingHelper<Object>();
        newHelper.bind(second.target);
        if (overrideTargetUpdater) {
            newHelper.with(second.targetUpdater);
        } else {
            newHelper.with(first.targetUpdater);
        }
        first.sources.forEach((source, updater) -> source.removeListener(first.sourceListener));
        second.sources.forEach((source, updater) -> source.removeListener(second.sourceListener));
        newHelper.addSources(first.getSources());
        newHelper.addSources(second.getSources());
        first.sources.clear();
        second.sources.clear();
        first.target.removeListener(first.targetListener);
        first.target = null;
        second.target.removeListener(second.targetListener);
        second.target = null;
        return newHelper;
    }
}

