/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.effects.DepthLevel;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.enums.ButtonType;
import io.github.palexdev.materialfx.skins.MFXButtonSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MFXButton
extends Button
implements Themable {
    private static final StyleablePropertyFactory<MFXButton> FACTORY = new StyleablePropertyFactory(Button.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-button";
    private final MFXCircleRippleGenerator rippleGenerator = new MFXCircleRippleGenerator((Region)this);
    private final BooleanProperty computeRadiusMultiplier = new SimpleBooleanProperty(this.rippleGenerator.isComputeRadiusMultiplier());
    private final BooleanProperty rippleAnimateBackground = new SimpleBooleanProperty(this.rippleGenerator.isAnimateBackground());
    private final BooleanProperty rippleAnimateShadow = new SimpleBooleanProperty(this.rippleGenerator.isAnimateShadow());
    private final DoubleProperty rippleAnimationSpeed = new SimpleDoubleProperty(this.rippleGenerator.getAnimationSpeed());
    private final DoubleProperty rippleBackgroundOpacity = new SimpleDoubleProperty(this.rippleGenerator.getBackgroundOpacity());
    private final ObjectProperty<Paint> rippleColor = new SimpleObjectProperty((Object)this.rippleGenerator.getRippleColor());
    private final DoubleProperty rippleRadius = new SimpleDoubleProperty(this.rippleGenerator.getRippleRadius());
    private final DoubleProperty rippleRadiusMultiplier = new SimpleDoubleProperty(this.rippleGenerator.getRadiusMultiplier());
    private final StyleableObjectProperty<DepthLevel> depthLevel = new SimpleStyleableObjectProperty(StyleableProperties.DEPTH_LEVEL, (Object)this, "depthLevel", (Object)DepthLevel.LEVEL2);
    private final StyleableObjectProperty<ButtonType> buttonType = new SimpleStyleableObjectProperty<ButtonType>(StyleableProperties.BUTTON_TYPE, (Object)this, "buttonType", ButtonType.FLAT){

        public void set(ButtonType v) {
            if (v == ButtonType.FLAT) {
                MFXButton.this.setEffect(null);
            }
            super.set((Object)v);
        }
    };

    public MFXButton() {
        this.setText("Button");
        this.initialize();
    }

    public MFXButton(String text) {
        super(text);
        this.initialize();
    }

    public MFXButton(String text, double prefWidth, double prefHeight) {
        super(text);
        this.setPrefSize(prefWidth, prefHeight);
        this.initialize();
    }

    public MFXButton(String text, Node graphic) {
        super(text, graphic);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-button");
        this.setAlignment(Pos.CENTER);
        this.setupRippleGenerator();
        this.sceneBuilderIntegration();
    }

    public MFXCircleRippleGenerator getRippleGenerator() {
        return this.rippleGenerator;
    }

    protected void setupRippleGenerator() {
        MFXCircleRippleGenerator rippleGenerator = this.getRippleGenerator();
        rippleGenerator.rippleColorProperty().bindBidirectional((Property)this.rippleColorProperty());
        rippleGenerator.rippleRadiusProperty().bindBidirectional((Property)this.rippleRadiusProperty());
        rippleGenerator.animationSpeedProperty().bindBidirectional((Property)this.rippleAnimationSpeedProperty());
        rippleGenerator.backgroundOpacityProperty().bindBidirectional((Property)this.rippleBackgroundOpacityProperty());
        rippleGenerator.radiusMultiplierProperty().bind((ObservableValue)this.rippleRadiusMultiplierProperty());
        rippleGenerator.computeRadiusMultiplierProperty().bind((ObservableValue)this.computeRadiusMultiplierProperty());
        rippleGenerator.animateBackgroundProperty().bind((ObservableValue)this.rippleAnimateBackgroundProperty());
        rippleGenerator.animateShadowProperty().bind((ObservableValue)this.rippleAnimateShadowProperty());
        this.setRippleColor((Paint)Color.rgb((int)190, (int)190, (int)190));
        this.setRippleRadius(25.0);
        this.setComputeRadiusMultiplier(true);
        rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
    }

    public boolean isComputeRadiusMultiplier() {
        return this.computeRadiusMultiplier.get();
    }

    public BooleanProperty computeRadiusMultiplierProperty() {
        return this.computeRadiusMultiplier;
    }

    public void setComputeRadiusMultiplier(boolean computeRadiusMultiplier) {
        this.computeRadiusMultiplier.set(computeRadiusMultiplier);
    }

    public boolean isRippleAnimateBackground() {
        return this.rippleAnimateBackground.get();
    }

    public BooleanProperty rippleAnimateBackgroundProperty() {
        return this.rippleAnimateBackground;
    }

    public void setRippleAnimateBackground(boolean rippleAnimateBackground) {
        this.rippleAnimateBackground.set(rippleAnimateBackground);
    }

    public boolean isRippleAnimateShadow() {
        return this.rippleAnimateShadow.get();
    }

    public BooleanProperty rippleAnimateShadowProperty() {
        return this.rippleAnimateShadow;
    }

    public void setRippleAnimateShadow(boolean rippleAnimateShadow) {
        this.rippleAnimateShadow.set(rippleAnimateShadow);
    }

    public double getRippleAnimationSpeed() {
        return this.rippleAnimationSpeed.get();
    }

    public DoubleProperty rippleAnimationSpeedProperty() {
        return this.rippleAnimationSpeed;
    }

    public void setRippleAnimationSpeed(double rippleAnimationSpeed) {
        this.rippleAnimationSpeed.set(rippleAnimationSpeed);
    }

    public double getRippleBackgroundOpacity() {
        return this.rippleBackgroundOpacity.get();
    }

    public DoubleProperty rippleBackgroundOpacityProperty() {
        return this.rippleBackgroundOpacity;
    }

    public void setRippleBackgroundOpacity(double rippleBackgroundOpacity) {
        this.rippleBackgroundOpacity.set(rippleBackgroundOpacity);
    }

    public final Paint getRippleColor() {
        return (Paint)this.rippleColor.get();
    }

    public final ObjectProperty<Paint> rippleColorProperty() {
        return this.rippleColor;
    }

    public final void setRippleColor(Paint rippleColor) {
        this.rippleColor.set((Object)rippleColor);
    }

    public double getRippleRadius() {
        return this.rippleRadius.get();
    }

    public DoubleProperty rippleRadiusProperty() {
        return this.rippleRadius;
    }

    public void setRippleRadius(double rippleRadius) {
        this.rippleRadius.set(rippleRadius);
    }

    public double getRippleRadiusMultiplier() {
        return this.rippleRadiusMultiplier.get();
    }

    public DoubleProperty rippleRadiusMultiplierProperty() {
        return this.rippleRadiusMultiplier;
    }

    public void setRippleRadiusMultiplier(double rippleRadiusMultiplier) {
        this.rippleRadiusMultiplier.set(rippleRadiusMultiplier);
    }

    public DepthLevel getDepthLevel() {
        return (DepthLevel)((Object)this.depthLevel.get());
    }

    public StyleableObjectProperty<DepthLevel> depthLevelProperty() {
        return this.depthLevel;
    }

    public void setDepthLevel(DepthLevel depthLevel) {
        this.depthLevel.set((Object)depthLevel);
    }

    public ButtonType getButtonType() {
        return (ButtonType)((Object)this.buttonType.get());
    }

    public StyleableObjectProperty<ButtonType> buttonTypeProperty() {
        return this.buttonType;
    }

    public void setButtonType(ButtonType buttonType) {
        this.buttonType.set((Object)buttonType);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.BUTTON;
    }

    @Override
    public boolean sceneBuilderIntegration() {
        if (Themable.super.sceneBuilderIntegration()) {
            this.setText("Button");
            return true;
        }
        return false;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXButtonSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXButton.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXButton, DepthLevel> DEPTH_LEVEL;
        private static final CssMetaData<MFXButton, ButtonType> BUTTON_TYPE;

        private StyleableProperties() {
        }

        static {
            DEPTH_LEVEL = FACTORY.createEnumCssMetaData(DepthLevel.class, "-mfx-depth-level", MFXButton::depthLevelProperty, (Enum)DepthLevel.LEVEL2);
            BUTTON_TYPE = FACTORY.createEnumCssMetaData(ButtonType.class, "-mfx-button-type", MFXButton::buttonTypeProperty, (Enum)ButtonType.FLAT);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(Button.getClassCssMetaData(), DEPTH_LEVEL, BUTTON_TYPE);
        }
    }
}

