/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.MFXTreeItem;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeCell;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import io.github.palexdev.materialfx.controls.cell.MFXCheckTreeCell;
import io.github.palexdev.materialfx.selection.TreeCheckModel;
import io.github.palexdev.materialfx.selection.base.ITreeCheckModel;
import io.github.palexdev.materialfx.skins.MFXCheckTreeItemSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import java.lang.ref.WeakReference;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.control.Skin;
import javafx.util.Callback;

public class MFXCheckTreeItem<T>
extends MFXTreeItem<T> {
    private final String STYLE_CLASS = "mfx-check-tree-item";
    private final BooleanProperty checked = new SimpleBooleanProperty(false);
    private final BooleanProperty indeterminate = new SimpleBooleanProperty(false);

    public MFXCheckTreeItem(T data) {
        super(data);
        this.initialize();
    }

    public MFXCheckTreeItem(T data, Callback<AbstractMFXTreeItem<T>, AbstractMFXTreeCell<T>> cellFactory) {
        super(data, cellFactory);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-check-tree-item");
        this.treeViewProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && this.isRoot()) {
                TreeCheckModel treeCheckModel = (TreeCheckModel)this.getSelectionModel();
                treeCheckModel.scanTree((MFXCheckTreeItem)this.getRoot());
            }
        });
    }

    public boolean isChecked() {
        return this.checked.get();
    }

    public BooleanProperty checkedProperty() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked.set(checked);
    }

    public boolean isIndeterminate() {
        return this.indeterminate.get();
    }

    public BooleanProperty indeterminateProperty() {
        return this.indeterminate;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.indeterminate.set(indeterminate);
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.TREE_ITEM;
    }

    @Override
    public ITreeCheckModel<T> getSelectionModel() {
        return (ITreeCheckModel)super.getSelectionModel();
    }

    @Override
    protected void defaultCellFactory() {
        this.cellFactory.set(cell -> new MFXCheckTreeCell(this));
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new MFXCheckTreeItemSkin(this);
    }

    public static final class CheckTreeItemEvent<T>
    extends Event {
        private final WeakReference<AbstractMFXTreeItem<T>> itemRef;
        public static final EventType<CheckTreeItemEvent<?>> CHECK_EVENT = new EventType(ANY, "CHECK_EVENT");

        public CheckTreeItemEvent(EventType<? extends Event> eventType, AbstractMFXTreeItem<T> item) {
            super(eventType);
            this.itemRef = new WeakReference<AbstractMFXTreeItem<AbstractMFXTreeItem<T>>>(item);
        }

        public AbstractMFXTreeItem<T> getItemRef() {
            return (AbstractMFXTreeItem)this.itemRef.get();
        }
    }
}

