/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.base.MFXLabeled;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.skins.MFXCheckboxSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Parent;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Skin;

public class MFXCheckbox
extends CheckBox
implements MFXLabeled,
Themable {
    private static final StyleablePropertyFactory<MFXCheckbox> FACTORY = new StyleablePropertyFactory(CheckBox.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-checkbox";
    private final StyleableObjectProperty<ContentDisplay> contentDisposition = new SimpleStyleableObjectProperty<ContentDisplay>(StyleableProperties.CONTENT_DISPOSITION, (Object)this, "contentDisposition", ContentDisplay.LEFT){

        public StyleOrigin getStyleOrigin() {
            return StyleOrigin.USER_AGENT;
        }
    };
    private final StyleableDoubleProperty gap = new SimpleStyleableDoubleProperty(StyleableProperties.GAP, (Object)this, "gap", Double.valueOf(8.0));
    private final StyleableBooleanProperty textExpand = new SimpleStyleableBooleanProperty(StyleableProperties.TEXT_EXPAND, (Object)this, "textExpand", false);

    public MFXCheckbox() {
        this("");
    }

    public MFXCheckbox(String text) {
        super(text);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-checkbox");
        this.sceneBuilderIntegration();
    }

    @Override
    public ContentDisplay getContentDisposition() {
        return (ContentDisplay)this.contentDisposition.get();
    }

    @Override
    public StyleableObjectProperty<ContentDisplay> contentDispositionProperty() {
        return this.contentDisposition;
    }

    @Override
    public void setContentDisposition(ContentDisplay contentDisposition) {
        this.contentDisposition.set((Object)contentDisposition);
    }

    @Override
    public double getGap() {
        return this.gap.get();
    }

    @Override
    public StyleableDoubleProperty gapProperty() {
        return this.gap;
    }

    @Override
    public void setGap(double gap) {
        this.gap.set(gap);
    }

    @Override
    public boolean isTextExpand() {
        return this.textExpand.get();
    }

    @Override
    public StyleableBooleanProperty textExpandProperty() {
        return this.textExpand;
    }

    @Override
    public void setTextExpand(boolean textExpand) {
        this.textExpand.set(textExpand);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.CHECKBOX;
    }

    @Override
    public boolean sceneBuilderIntegration() {
        if (Themable.super.sceneBuilderIntegration()) {
            this.setText("Checkbox");
            return true;
        }
        return false;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXCheckboxSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXCheckbox.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXCheckbox, ContentDisplay> CONTENT_DISPOSITION;
        private static final CssMetaData<MFXCheckbox, Number> GAP;
        private static final CssMetaData<MFXCheckbox, Boolean> TEXT_EXPAND;

        private StyleableProperties() {
        }

        static {
            CONTENT_DISPOSITION = FACTORY.createEnumCssMetaData(ContentDisplay.class, "-mfx-content-disposition", MFXCheckbox::contentDispositionProperty, (Enum)ContentDisplay.LEFT);
            GAP = FACTORY.createSizeCssMetaData("-mfx-gap", MFXCheckbox::gapProperty, (Number)8.0);
            TEXT_EXPAND = FACTORY.createBooleanCssMetaData("-mfx-text-expand", MFXCheckbox::textExpandProperty, false);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(CheckBox.getClassCssMetaData(), CONTENT_DISPOSITION, GAP, TEXT_EXPAND);
        }
    }
}

