/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.EventHandlerProperty;
import io.github.palexdev.materialfx.beans.properties.functional.SupplierProperty;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.skins.MFXContextMenuItemSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import java.util.function.Supplier;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import javafx.scene.control.Skin;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCombination;

public class MFXContextMenuItem
extends Labeled
implements Themable {
    private final String STYLE_CLASS = "mfx-menu-item";
    private final StringProperty accelerator = new SimpleStringProperty();
    private final SupplierProperty<Tooltip> tooltipSupplier = new SupplierProperty();
    private final EventHandlerProperty<ActionEvent> onAction = new EventHandlerProperty<ActionEvent>(){

        protected void invalidated() {
            MFXContextMenuItem.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }
    };

    public MFXContextMenuItem() {
        this("");
    }

    public MFXContextMenuItem(String text) {
        this(text, null);
    }

    public MFXContextMenuItem(String text, Node graphic) {
        super(text, graphic);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-menu-item");
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.CONTEXT_MENU_ITEM;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXContextMenuItemSkin(this);
    }

    public String getAccelerator() {
        return (String)this.accelerator.get();
    }

    public StringProperty acceleratorProperty() {
        return this.accelerator;
    }

    public void setAccelerator(String accelerator) {
        this.accelerator.set((Object)accelerator);
    }

    public void setAccelerator(KeyCombination combination) {
        this.setAccelerator(combination.getDisplayText());
    }

    public Supplier<Tooltip> getTooltipSupplier() {
        return (Supplier)this.tooltipSupplier.get();
    }

    public SupplierProperty<Tooltip> tooltipSupplierProperty() {
        return this.tooltipSupplier;
    }

    public void setTooltipSupplier(Supplier<Tooltip> tooltipSupplier) {
        this.tooltipSupplier.set(tooltipSupplier);
    }

    public EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onAction.get();
    }

    public EventHandlerProperty<ActionEvent> onActionProperty() {
        return this.onAction;
    }

    public void setOnAction(EventHandler<ActionEvent> onAction) {
        this.onAction.set(onAction);
    }

    public static class Builder {
        private final MFXContextMenuItem item = new MFXContextMenuItem();

        public static Builder build() {
            return new Builder();
        }

        public Builder setIcon(Node icon) {
            this.item.setGraphic(icon);
            return this;
        }

        public Builder setText(String text) {
            this.item.setText(text);
            return this;
        }

        public Builder setAccelerator(String accelerator) {
            this.item.setAccelerator(accelerator);
            return this;
        }

        public Builder setAccelerator(KeyCombination combination) {
            this.item.setAccelerator(combination);
            return this;
        }

        public Builder setTooltipSupplier(Supplier<Tooltip> tooltipSupplier) {
            this.item.setTooltipSupplier(tooltipSupplier);
            return this;
        }

        public Builder setOnAction(EventHandler<ActionEvent> onAction) {
            this.item.setOnAction(onAction);
            return this;
        }

        public MFXContextMenuItem get() {
            return this.item;
        }
    }
}

