/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.FilterBean;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.enums.ChainMode;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.skins.MFXFilterPaneSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.PredicateUtils;
import java.util.function.Predicate;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;

public class MFXFilterPane<T>
extends Control
implements Themable {
    private final String STYLE_CLASS = "mfx-filter-pane";
    private final StringProperty headerText = new SimpleStringProperty(I18N.getOrDefault("filterPane.headerText", new Object[0]));
    private final ObservableList<AbstractFilter<T, ?>> filters = FXCollections.observableArrayList();
    private final ObservableList<FilterBean<T, ?>> activeFilters = FXCollections.observableArrayList();
    private EventHandler<MouseEvent> onFilter = event -> {};
    private EventHandler<MouseEvent> onReset = event -> {};

    public MFXFilterPane() {
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-filter-pane");
        this.sceneBuilderIntegration();
    }

    public Predicate<T> filter() {
        Predicate<Object> filter = null;
        ChainMode mode = null;
        for (FilterBean activeFilter : this.activeFilters) {
            if (filter == null) {
                filter = activeFilter.predicate();
                mode = activeFilter.getMode();
                continue;
            }
            filter = PredicateUtils.chain(filter, activeFilter.predicate(), mode);
            mode = activeFilter.getMode();
        }
        return filter != null ? filter : t -> true;
    }

    public String getHeaderText() {
        return (String)this.headerText.get();
    }

    public StringProperty headerTextProperty() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText.set((Object)headerText);
    }

    public ObservableList<AbstractFilter<T, ?>> getFilters() {
        return this.filters;
    }

    public ObservableList<FilterBean<T, ?>> getActiveFilters() {
        return this.activeFilters;
    }

    public EventHandler<MouseEvent> getOnFilter() {
        return this.onFilter;
    }

    public void setOnFilter(EventHandler<MouseEvent> onFilter) {
        this.onFilter = onFilter;
    }

    public EventHandler<MouseEvent> getOnReset() {
        return this.onReset;
    }

    public void setOnReset(EventHandler<MouseEvent> onReset) {
        this.onReset = onReset;
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.FILTER_PANE;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXFilterPaneSkin(this);
    }
}

