/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableBooleanProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.skins.MFXMagnifierPaneSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.ColorUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.materialfx.utils.others.FunctionalStringConverter;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.paint.Color;
import javafx.util.StringConverter;

public class MFXMagnifierPane
extends Control
implements Themable {
    private final String STYLE_CLASS = "mfx-magnifier";
    private final ObjectProperty<Node> content = new SimpleObjectProperty();
    private final ObjectProperty<PositionBean> position = new SimpleObjectProperty();
    private final ObjectProperty<Image> magnifierView = new SimpleObjectProperty<Image>(){

        public void unbind() {
        }
    };
    private final ReadOnlyObjectWrapper<Color> pickedColor = new ReadOnlyObjectWrapper();
    private final ObjectProperty<StringConverter<Color>> colorConverter = new SimpleObjectProperty(FunctionalStringConverter.to(ColorUtils::rgb));
    private final StyleableDoubleProperty lensSize = new StyleableDoubleProperty(StyleableProperties.LENS_SIZE, this, "lensSize", 100.0);
    private final StyleableDoubleProperty zoom = new StyleableDoubleProperty(StyleableProperties.ZOOM, this, "zoom", 2.0);
    private final StyleableDoubleProperty zoomIncrement = new StyleableDoubleProperty(StyleableProperties.ZOOM_INCREMENT, this, "zoomIncrement", 0.25);
    private final StyleableDoubleProperty minZoom = new StyleableDoubleProperty(StyleableProperties.MIN_ZOOM, this, "minZoom", 2.0);
    private final StyleableDoubleProperty maxZoom = new StyleableDoubleProperty(StyleableProperties.MAX_ZOOM, this, "maxZoom", 8.0);
    private final StyleableObjectProperty<VPos> pickerPos = new StyleableObjectProperty<VPos>(StyleableProperties.PICKER_POS, this, "pickerPos", VPos.BOTTOM);
    private final StyleableDoubleProperty pickerSpacing = new StyleableDoubleProperty(StyleableProperties.PICKER_SPACING, this, "pickerSpacing", 10.0);
    private final StyleableBooleanProperty hideCursor = new StyleableBooleanProperty(StyleableProperties.HIDE_CURSOR, this, "hideCursor", false);
    private final StyleableBooleanProperty showZoomLabel = new StyleableBooleanProperty(StyleableProperties.SHOW_ZOOM_LABEL, this, "showZoomLabel", true);
    private final StyleableDoubleProperty hideZoomLabelAfter = new StyleableDoubleProperty(StyleableProperties.HIDE_ZOOM_LABEL_AFTER, this, "hideZoomLabelAfter", 2000.0);

    public MFXMagnifierPane(Node content) {
        this.setContent(content);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-magnifier");
        this.setCursor(Cursor.NONE);
        this.setSnapToPixel(false);
        this.sceneBuilderIntegration();
    }

    public void updatePickedColor() {
        Image currentView = this.getMagnifierView();
        if (currentView != null) {
            PixelReader pixelReader = currentView.getPixelReader();
            Color color = pixelReader.getColor((int)(currentView.getWidth() / 2.0), (int)(currentView.getHeight() / 2.0));
            this.setPickedColor(color);
        }
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.MAGNIFIER;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXMagnifierPaneSkin(this);
    }

    public double getLensSize() {
        return this.lensSize.get();
    }

    public StyleableDoubleProperty lensSizeProperty() {
        return this.lensSize;
    }

    public void setLensSize(double lensSize) {
        this.lensSize.set(lensSize);
    }

    public double getZoom() {
        return this.zoom.get();
    }

    public StyleableDoubleProperty zoomProperty() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom.set(zoom);
    }

    public double getZoomIncrement() {
        return this.zoomIncrement.get();
    }

    public StyleableDoubleProperty zoomIncrementProperty() {
        return this.zoomIncrement;
    }

    public void setZoomIncrement(double zoomIncrement) {
        this.zoomIncrement.set(zoomIncrement);
    }

    public double getMinZoom() {
        return this.minZoom.get();
    }

    public StyleableDoubleProperty minZoomProperty() {
        return this.minZoom;
    }

    public void setMinZoom(double minZoom) {
        this.minZoom.set(minZoom);
    }

    public double getMaxZoom() {
        return this.maxZoom.get();
    }

    public StyleableDoubleProperty maxZoomProperty() {
        return this.maxZoom;
    }

    public void setMaxZoom(double maxZoom) {
        this.maxZoom.set(maxZoom);
    }

    public VPos getPickerPos() {
        return (VPos)this.pickerPos.get();
    }

    public StyleableObjectProperty<VPos> pickerPosProperty() {
        return this.pickerPos;
    }

    public void setPickerPos(VPos pickerPos) {
        this.pickerPos.set(pickerPos);
    }

    public double getPickerSpacing() {
        return this.pickerSpacing.get();
    }

    public StyleableDoubleProperty pickerSpacingProperty() {
        return this.pickerSpacing;
    }

    public void setPickerSpacing(double pickerSpacing) {
        this.pickerSpacing.set(pickerSpacing);
    }

    public boolean isHideCursor() {
        return this.hideCursor.get();
    }

    public StyleableBooleanProperty hideCursorProperty() {
        return this.hideCursor;
    }

    public void setHideCursor(boolean hideCursor) {
        this.hideCursor.set(hideCursor);
    }

    public boolean isShowZoomLabel() {
        return this.showZoomLabel.get();
    }

    public StyleableBooleanProperty showZoomLabelProperty() {
        return this.showZoomLabel;
    }

    public void setShowZoomLabel(boolean showZoomLabel) {
        this.showZoomLabel.set(showZoomLabel);
    }

    public double getHideZoomLabelAfter() {
        return this.hideZoomLabelAfter.get();
    }

    public StyleableDoubleProperty hideZoomLabelAfterProperty() {
        return this.hideZoomLabelAfter;
    }

    public void setHideZoomLabelAfter(double hideZoomLabelAfter) {
        this.hideZoomLabelAfter.set(hideZoomLabelAfter);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.cssMetaDataList;
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXMagnifierPane.getClassCssMetaData();
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content.set((Object)content);
    }

    public PositionBean getPosition() {
        return (PositionBean)this.position.get();
    }

    public ObjectProperty<PositionBean> positionProperty() {
        return this.position;
    }

    public void setPosition(PositionBean position) {
        this.position.set((Object)position);
    }

    public Image getMagnifierView() {
        return (Image)this.magnifierView.get();
    }

    public ObjectProperty<Image> magnifierViewProperty() {
        return this.magnifierView;
    }

    private void setMagnifierView(Image magnifierView) {
        this.magnifierView.set((Object)magnifierView);
    }

    public Color getPickedColor() {
        return (Color)this.pickedColor.get();
    }

    public ReadOnlyObjectProperty<Color> pickedColorProperty() {
        return this.pickedColor.getReadOnlyProperty();
    }

    private void setPickedColor(Color pickedColor) {
        this.pickedColor.set((Object)pickedColor);
    }

    public StringConverter<Color> getColorConverter() {
        return (StringConverter)this.colorConverter.get();
    }

    public ObjectProperty<StringConverter<Color>> colorConverterProperty() {
        return this.colorConverter;
    }

    public void setColorConverter(StringConverter<Color> colorConverter) {
        this.colorConverter.set(colorConverter);
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXMagnifierPane> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXMagnifierPane, Number> LENS_SIZE;
        private static final CssMetaData<MFXMagnifierPane, Number> ZOOM;
        private static final CssMetaData<MFXMagnifierPane, Number> ZOOM_INCREMENT;
        private static final CssMetaData<MFXMagnifierPane, Number> MIN_ZOOM;
        private static final CssMetaData<MFXMagnifierPane, Number> MAX_ZOOM;
        private static final CssMetaData<MFXMagnifierPane, VPos> PICKER_POS;
        private static final CssMetaData<MFXMagnifierPane, Number> PICKER_SPACING;
        private static final CssMetaData<MFXMagnifierPane, Boolean> HIDE_CURSOR;
        private static final CssMetaData<MFXMagnifierPane, Boolean> SHOW_ZOOM_LABEL;
        private static final CssMetaData<MFXMagnifierPane, Number> HIDE_ZOOM_LABEL_AFTER;

        private StyleableProperties() {
        }

        static {
            LENS_SIZE = FACTORY.createSizeCssMetaData("-mfx-lens-size", MFXMagnifierPane::lensSizeProperty, (Number)100.0);
            ZOOM = FACTORY.createSizeCssMetaData("-mfx-zoom", MFXMagnifierPane::zoomProperty, (Number)2.0);
            ZOOM_INCREMENT = FACTORY.createSizeCssMetaData("-mfx-zoom-increment", MFXMagnifierPane::zoomIncrementProperty, (Number)0.25);
            MIN_ZOOM = FACTORY.createSizeCssMetaData("-mfx-min-zoom", MFXMagnifierPane::minZoomProperty, (Number)2.0);
            MAX_ZOOM = FACTORY.createSizeCssMetaData("-mfx-max-zoom", MFXMagnifierPane::maxZoomProperty, (Number)8.0);
            PICKER_POS = FACTORY.createEnumCssMetaData(VPos.class, "-mfx-picker-pos", MFXMagnifierPane::pickerPosProperty, (Enum)VPos.BOTTOM);
            PICKER_SPACING = FACTORY.createSizeCssMetaData("-mfx-picker-spacing", MFXMagnifierPane::pickerSpacingProperty, (Number)10.0);
            HIDE_CURSOR = FACTORY.createBooleanCssMetaData("-mfx-hide-cursor", MFXMagnifierPane::hideCursorProperty, false);
            SHOW_ZOOM_LABEL = FACTORY.createBooleanCssMetaData("-mfx-show-zoom-label", MFXMagnifierPane::showZoomLabelProperty, true);
            HIDE_ZOOM_LABEL_AFTER = FACTORY.createSizeCssMetaData("-mfx-hide-zoom-label-after", MFXMagnifierPane::hideZoomLabelAfterProperty, (Number)2000.0);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(Control.getClassCssMetaData(), LENS_SIZE, ZOOM, ZOOM_INCREMENT, MIN_ZOOM, MAX_ZOOM, PICKER_POS, PICKER_SPACING, HIDE_CURSOR, SHOW_ZOOM_LABEL, HIDE_ZOOM_LABEL_AFTER);
        }
    }
}

