/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.collections.TransformableListWrapper;
import io.github.palexdev.materialfx.controls.MFXContextMenu;
import io.github.palexdev.materialfx.controls.MFXContextMenuItem;
import io.github.palexdev.materialfx.controls.base.MFXMenuControl;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.controls.cell.MFXNotificationCell;
import io.github.palexdev.materialfx.enums.NotificationCounterStyle;
import io.github.palexdev.materialfx.enums.NotificationState;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.notifications.base.INotification;
import io.github.palexdev.materialfx.selection.MultipleSelectionModel;
import io.github.palexdev.materialfx.skins.MFXNotificationCenterSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.ListChangeHelper;
import io.github.palexdev.materialfx.utils.ListChangeProcessor;
import io.github.palexdev.materialfx.utils.others.ReusableScheduledExecutor;
import io.github.palexdev.mfxcore.base.TriConsumer;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.virtualizedfx.unused.simple.SimpleVirtualFlow;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.LongBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;

public class MFXNotificationCenter
extends Control
implements MFXMenuControl,
Themable {
    private final String STYLE_CLASS = "mfx-notification-center";
    private final TransformableListWrapper<INotification> notifications = new TransformableListWrapper(FXCollections.observableArrayList());
    private final SimpleVirtualFlow<INotification, MFXNotificationCell> virtualFlow;
    private final MultipleSelectionModel<INotification> selectionModel = new MultipleSelectionModel<INotification>(this.notifications);
    private final BooleanProperty selectionMode = new SimpleBooleanProperty(false);
    private final ReadOnlyLongWrapper unreadCount = new ReadOnlyLongWrapper(0L);
    private final LongBinding unreadCountBinding;
    private final ObjectProperty<NotificationCounterStyle> counterStyle = new SimpleObjectProperty((Object)NotificationCounterStyle.NUMBER);
    private final StringProperty headerTextProperty = new SimpleStringProperty(I18N.getOrDefault("notificationCenter.header", new Object[0]));
    private final BooleanProperty doNotDisturb = new SimpleBooleanProperty(false);
    private final BooleanProperty showing = new SimpleBooleanProperty(false);
    private final BooleanProperty popupHover = new SimpleBooleanProperty(false){

        public void unbind() {
        }
    };
    private final DoubleProperty popupSpacing = new SimpleDoubleProperty(10.0);
    private final DoubleProperty popupWidth = new SimpleDoubleProperty(450.0);
    private final DoubleProperty popupHeight = new SimpleDoubleProperty(550.0);
    private MFXContextMenu contextMenu;
    private boolean animated = true;
    private boolean markAsReadOnShow = false;
    private boolean markAsReadOnDismiss = false;
    private EventHandler<MouseEvent> onIconClicked = event -> this.setShowing(!this.isShowing());
    private final ReusableScheduledExecutor notificationsUpdater;

    public MFXNotificationCenter() {
        this.virtualFlow = new SimpleVirtualFlow(this.notifications, notification -> new MFXNotificationCell(this, (INotification)notification), Orientation.VERTICAL);
        this.unreadCountBinding = Bindings.createLongBinding(() -> this.notifications.stream().filter(notification -> notification.getState() == NotificationState.UNREAD).count(), (Observable[])new Observable[]{this.notifications});
        this.notificationsUpdater = new ReusableScheduledExecutor(Executors.newScheduledThreadPool(1, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }));
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-notification-center");
        this.setPrefSize(400.0, 550.0);
        this.defaultContextMenu();
        this.unreadCount.bind((ObservableValue)this.unreadCountBinding);
        this.notifications.addListener((ListChangeListener<INotification>)((ListChangeListener)change -> {
            if (!this.selectionModel.getSelection().isEmpty()) {
                if (change.getList().isEmpty()) {
                    this.selectionModel.clearSelection();
                } else {
                    ListChangeHelper.Change c = ListChangeHelper.processChange(change, IntegerRange.of((Integer)0, (Integer)Integer.MAX_VALUE));
                    ListChangeProcessor updater = new ListChangeProcessor(this.selectionModel.getSelection().keySet());
                    c.processReplacement((changed, removed) -> this.selectionModel.replaceSelection(changed.toArray(new Integer[0])));
                    c.processAddition((TriConsumer<Integer, Integer, Set<Integer>>)((TriConsumer)(from, to, added) -> {
                        updater.computeAddition(added.size(), (int)from);
                        this.selectionModel.replaceSelection(updater.getIndexes().toArray(new Integer[0]));
                    }));
                    c.processRemoval((TriConsumer<Integer, Integer, Set<Integer>>)((TriConsumer)(from, to, removed) -> {
                        updater.computeRemoval((Set<Integer>)removed, (int)from);
                        this.selectionModel.replaceSelection(updater.getIndexes().toArray(new Integer[0]));
                    }));
                }
            }
        }));
        this.notifications.predicateProperty().addListener(invalidated -> {
            this.setSelectionMode(false);
            this.selectionModel.clearSelection();
        });
        this.notifications.comparatorProperty().addListener(invalidated -> {
            this.setSelectionMode(false);
            this.selectionModel.clearSelection();
        });
        this.showing.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && this.markAsReadOnShow) {
                this.markVisibleNotificationsAs(NotificationState.READ);
            }
        });
        this.startNotificationsUpdater(60L, TimeUnit.SECONDS);
        this.sceneBuilderIntegration();
    }

    protected void defaultContextMenu() {
        MFXContextMenuItem selectAll = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.selectAll", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (this.notifications.isEmpty()) {
                return;
            }
            this.setSelectionMode(true);
            IntegerRange indexes = IntegerRange.of((Integer)0, (Integer)(this.notifications.size() - 1));
            this.selectionModel.replaceSelection((Integer[])IntegerRange.expandRange((IntegerRange)indexes).toArray(Integer[]::new));
        })).get();
        MFXContextMenuItem selectRead = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.selectRead", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (this.notifications.isEmpty()) {
                return;
            }
            this.setSelectionMode(true);
            Integer[] indexes = (Integer[])IntStream.range(0, this.notifications.size()).filter(i -> this.notifications.get(i).getState() == NotificationState.READ).boxed().toArray(Integer[]::new);
            this.selectionModel.replaceSelection(indexes);
        })).get();
        MFXContextMenuItem selectUnread = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.selectUnread", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (this.notifications.isEmpty()) {
                return;
            }
            this.setSelectionMode(true);
            Integer[] indexes = (Integer[])IntStream.range(0, this.notifications.size()).filter(i -> this.notifications.get(i).getState() == NotificationState.UNREAD).boxed().toArray(Integer[]::new);
            this.selectionModel.replaceSelection(indexes);
        })).get();
        MFXContextMenuItem clearSelection = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.clearSelection", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.selectionModel.clearSelection())).get();
        MFXContextMenuItem sortByState = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.sortState", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.notifications.setComparator(Comparator.comparing(INotification::getState)))).get();
        MFXContextMenuItem sortByTime = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.sortTime", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.notifications.setComparator(Comparator.comparing(INotification::getTime)))).get();
        MFXContextMenuItem reverseSort = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.reverseSort", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> {
            if (this.notifications.getComparator() == null) {
                return;
            }
            Comparator<INotification> comparator = this.notifications.getComparator();
            this.notifications.setComparator(comparator.reversed());
        })).get();
        MFXContextMenuItem filterRead = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.filterRead", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.notifications.setPredicate(notification -> notification.getState() == NotificationState.READ))).get();
        MFXContextMenuItem filterUnread = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.filterUnread", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.notifications.setPredicate(notification -> notification.getState() == NotificationState.UNREAD))).get();
        MFXContextMenuItem clearFilter = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.clearFilter", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.notifications.setPredicate(null))).get();
        MFXContextMenuItem clearSort = MFXContextMenuItem.Builder.build().setText(I18N.getOrDefault("notificationCenter.contextMenu.clearSort", new Object[0])).setOnAction((EventHandler<ActionEvent>)((EventHandler)event -> this.notifications.setComparator(null))).get();
        this.contextMenu = MFXContextMenu.Builder.build(this.virtualFlow).addSeparator((Node)new Label(I18N.getOrDefault("notificationCenter.contextMenu.selectionSeparator", new Object[0]))).addItems(selectAll, selectRead, selectUnread, clearSelection).addSeparator((Node)new Label(I18N.getOrDefault("notificationCenter.contextMenu.sortingSeparator", new Object[0]))).addItems(sortByState, sortByTime, reverseSort, clearSort).addSeparator((Node)new Label(I18N.getOrDefault("notificationCenter.contextMenu.filterSeparator", new Object[0]))).addItems(filterRead, filterUnread, clearFilter).setPopupStyleableParent((Parent)this).installAndGet();
    }

    public void startNotificationsUpdater(long period, TimeUnit timeUnit) {
        this.notificationsUpdater.scheduleAtFixedRate(() -> this.notifications.forEach(INotification::updateElapsed), 0L, period, timeUnit);
    }

    public void stopNotificationsUpdater() {
        this.notificationsUpdater.cancelNow();
    }

    public void markNotificationsAs(NotificationState state, INotification ... notifications) {
        for (INotification notification : notifications) {
            notification.setNotificationState(state);
        }
        this.unreadCountBinding.invalidate();
    }

    public void markVisibleNotificationsAs(NotificationState state) {
        this.markNotificationsAs(state, (INotification[])this.getCells().values().stream().map(MFXNotificationCell::getNotification).toArray(INotification[]::new));
    }

    public void markSelectedNotificationsAs(NotificationState state) {
        this.markNotificationsAs(state, (INotification[])this.selectionModel.getSelection().values().toArray(INotification[]::new));
    }

    public void markAllNotificationsAs(NotificationState state) {
        this.markNotificationsAs(state, (INotification[])this.notifications.toArray(INotification[]::new));
    }

    public void dismiss(INotification ... notifications) {
        if (this.markAsReadOnDismiss) {
            this.markNotificationsAs(NotificationState.READ, notifications);
        }
        this.notifications.removeAll((INotification[])notifications);
    }

    public void dismissVisible() {
        this.dismiss((INotification[])this.getCells().values().stream().map(MFXNotificationCell::getNotification).toArray(INotification[]::new));
    }

    public void dismissSelected() {
        this.dismiss((INotification[])this.getSelectionModel().getSelection().values().toArray(INotification[]::new));
    }

    public void dismissAll() {
        this.dismiss((INotification[])this.notifications.toArray(INotification[]::new));
    }

    public TransformableListWrapper<INotification> getNotifications() {
        return this.notifications;
    }

    public MultipleSelectionModel<INotification> getSelectionModel() {
        return this.selectionModel;
    }

    public boolean isSelectionMode() {
        return this.selectionMode.get();
    }

    public BooleanProperty selectionModeProperty() {
        return this.selectionMode;
    }

    public void setSelectionMode(boolean selectionMode) {
        this.selectionMode.set(selectionMode);
    }

    public long getUnreadCount() {
        return this.unreadCount.get();
    }

    public ReadOnlyLongProperty unreadCountProperty() {
        return this.unreadCount.getReadOnlyProperty();
    }

    public NotificationCounterStyle getCounterStyle() {
        return (NotificationCounterStyle)((Object)this.counterStyle.get());
    }

    public ObjectProperty<NotificationCounterStyle> counterStyleProperty() {
        return this.counterStyle;
    }

    public void setCounterStyle(NotificationCounterStyle counterStyle) {
        this.counterStyle.set((Object)counterStyle);
    }

    public String getHeaderTextProperty() {
        return (String)this.headerTextProperty.get();
    }

    public StringProperty headerTextPropertyProperty() {
        return this.headerTextProperty;
    }

    public void setHeaderTextProperty(String headerTextProperty) {
        this.headerTextProperty.set((Object)headerTextProperty);
    }

    public boolean isDoNotDisturb() {
        return this.doNotDisturb.get();
    }

    public BooleanProperty doNotDisturbProperty() {
        return this.doNotDisturb;
    }

    public void setDoNotDisturb(boolean doNotDisturb) {
        this.doNotDisturb.set(doNotDisturb);
    }

    public boolean isShowing() {
        return this.showing.get();
    }

    public BooleanProperty showingProperty() {
        return this.showing;
    }

    public void setShowing(boolean showing) {
        this.showing.set(showing);
    }

    public boolean isPopupHover() {
        return this.popupHover.get();
    }

    public BooleanProperty popupHoverProperty() {
        return this.popupHover;
    }

    public double getPopupSpacing() {
        return this.popupSpacing.get();
    }

    public DoubleProperty popupSpacingProperty() {
        return this.popupSpacing;
    }

    public void setPopupSpacing(double popupSpacing) {
        this.popupSpacing.set(popupSpacing);
    }

    public double getPopupWidth() {
        return this.popupWidth.get();
    }

    public DoubleProperty popupWidthProperty() {
        return this.popupWidth;
    }

    public void setPopupWidth(double popupWidth) {
        this.popupWidth.set(popupWidth);
    }

    public double getPopupHeight() {
        return this.popupHeight.get();
    }

    public DoubleProperty popupHeightProperty() {
        return this.popupHeight;
    }

    public void setPopupHeight(double popupHeight) {
        this.popupHeight.set(popupHeight);
    }

    @Override
    public MFXContextMenu getMFXContextMenu() {
        return this.contextMenu;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated = animated;
    }

    public boolean isMarkAsReadOnShow() {
        return this.markAsReadOnShow;
    }

    public void setMarkAsReadOnShow(boolean markAsReadOnShow) {
        this.markAsReadOnShow = markAsReadOnShow;
    }

    public boolean isMarkAsReadOnDismiss() {
        return this.markAsReadOnDismiss;
    }

    public void setMarkAsReadOnDismiss(boolean markAsReadOnDismiss) {
        this.markAsReadOnDismiss = markAsReadOnDismiss;
    }

    public EventHandler<MouseEvent> getOnIconClicked() {
        return this.onIconClicked;
    }

    public void setOnIconClicked(EventHandler<MouseEvent> onIconClicked) {
        this.onIconClicked = onIconClicked;
    }

    public MFXNotificationCell getCell(int index) {
        return (MFXNotificationCell)this.virtualFlow.getCell(index);
    }

    public Map<Integer, MFXNotificationCell> getCells() {
        return this.virtualFlow.getCells();
    }

    public void scrollBy(double pixels) {
        this.virtualFlow.scrollBy(pixels);
    }

    public void scrollTo(int index) {
        this.virtualFlow.scrollTo(index);
    }

    public void scrollToFirst() {
        this.virtualFlow.scrollToFirst();
    }

    public void scrollToLast() {
        this.virtualFlow.scrollToLast();
    }

    public void scrollToPixel(double pixel) {
        this.virtualFlow.scrollToPixel(pixel);
    }

    public void setHSpeed(double unit, double block) {
        this.virtualFlow.setHSpeed(unit, block);
    }

    public void setVSpeed(double unit, double block) {
        this.virtualFlow.setVSpeed(unit, block);
    }

    public double getVerticalPosition() {
        return this.virtualFlow.getVerticalPosition();
    }

    public double getHorizontalPosition() {
        return this.virtualFlow.getHorizontalPosition();
    }

    public void setCellFactory(Function<INotification, MFXNotificationCell> cellFactory) {
        this.virtualFlow.setCellFactory(cellFactory);
    }

    public SimpleVirtualFlow.Features features() {
        return this.virtualFlow.features();
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.NOTIFICATION_CENTER;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXNotificationCenterSkin(this, this.virtualFlow);
    }
}

