/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.functional.FunctionProperty;
import io.github.palexdev.materialfx.beans.properties.functional.SupplierProperty;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.controls.cell.MFXPage;
import io.github.palexdev.materialfx.skins.MFXPaginationSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.NumberUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Orientation;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;

public class MFXPagination
extends Control
implements Themable {
    private final String STYLE_CLASS = "mfx-pagination";
    private final IntegerProperty currentPage = new SimpleIntegerProperty(1){

        public void set(int newValue) {
            int number = NumberUtils.clamp(newValue, 1, MFXPagination.this.getMaxPage());
            super.set(number);
        }
    };
    private final IntegerProperty maxPage = new SimpleIntegerProperty();
    private final IntegerProperty pagesToShow = new SimpleIntegerProperty();
    private final SupplierProperty<List<Integer>> indexesSupplier = new SupplierProperty();
    private final FunctionProperty<Integer, MFXPage> pageCellFactory = new FunctionProperty<Integer, MFXPage>(index -> new MFXPage(this, (int)index));
    private final StringProperty ellipseString = new SimpleStringProperty("...");
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)Orientation.HORIZONTAL);
    private final BooleanProperty showPopupForTruncatedPages = new SimpleBooleanProperty(false);

    public MFXPagination() {
        this(0);
    }

    public MFXPagination(int maxPage) {
        this(maxPage, 9);
    }

    public MFXPagination(int maxPage, int toShow) {
        this.setMaxPage(maxPage);
        this.setPagesToShow(toShow);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-pagination");
        this.defaultIndexesSupplier();
        this.sceneBuilderIntegration();
    }

    public void defaultIndexesSupplier() {
        this.setIndexesSupplier(this::computePagesIndex);
    }

    protected List<Integer> computePagesIndex() {
        int toShow;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        int current = this.getCurrentPage();
        int nPages = this.getMaxPage();
        if (nPages < (toShow = this.getPagesToShow()) || toShow < 5) {
            for (int i = 1; i <= nPages; ++i) {
                indexes.add(i);
            }
            return indexes;
        }
        int middle = (int)Math.ceil((double)toShow / 2.0);
        if (current < middle) {
            int end = NumberUtils.isEven(toShow) ? middle + 1 : middle;
            for (int i = 1; i < end; ++i) {
                indexes.add(i);
            }
            indexes.add(-1);
            int remaining = toShow - indexes.size();
            for (int i = nPages - remaining + 1; i <= nPages; ++i) {
                indexes.add(i);
            }
        } else if (current <= nPages - middle + 1) {
            indexes.add(1);
            indexes.add(-1);
            indexes.addAll(this.computeMiddleIndexes(current, toShow));
            indexes.add(-1);
            indexes.add(nPages);
        } else {
            for (int i = 1; i < middle; ++i) {
                indexes.add(i);
            }
            indexes.add(-1);
            int remaining = toShow - indexes.size();
            for (int i = nPages - remaining + 1; i <= nPages; ++i) {
                indexes.add(i);
            }
        }
        return indexes;
    }

    protected List<Integer> computeMiddleIndexes(int current, int toShow) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        indexes.add(current);
        int lastMin = current - 1;
        int lastMax = current + 1;
        boolean after = true;
        for (int remaining = toShow - 5; remaining > 0; --remaining) {
            if (after) {
                indexes.add(lastMax);
                ++lastMax;
                after = false;
                continue;
            }
            indexes.add(0, lastMin);
            --lastMin;
            after = true;
        }
        return indexes;
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.PAGINATION;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXPaginationSkin(this);
    }

    public int getCurrentPage() {
        return this.currentPage.get();
    }

    public IntegerProperty currentPageProperty() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage.set(currentPage);
    }

    public int getMaxPage() {
        return this.maxPage.get();
    }

    public IntegerProperty maxPageProperty() {
        return this.maxPage;
    }

    public void setMaxPage(int maxPage) {
        this.maxPage.set(maxPage);
    }

    public int getPagesToShow() {
        return this.pagesToShow.get();
    }

    public IntegerProperty pagesToShowProperty() {
        return this.pagesToShow;
    }

    public void setPagesToShow(int pagesToShow) {
        this.pagesToShow.set(pagesToShow);
    }

    public Supplier<List<Integer>> getIndexesSupplier() {
        return (Supplier)this.indexesSupplier.get();
    }

    public SupplierProperty<List<Integer>> indexesSupplierProperty() {
        return this.indexesSupplier;
    }

    public void setIndexesSupplier(Supplier<List<Integer>> indexesSupplier) {
        this.indexesSupplier.set(indexesSupplier);
    }

    public Function<Integer, MFXPage> getPageCellFactory() {
        return (Function)this.pageCellFactory.get();
    }

    public FunctionProperty<Integer, MFXPage> pageCellFactoryProperty() {
        return this.pageCellFactory;
    }

    public void setPageCellFactory(Function<Integer, MFXPage> pageCellFactory) {
        this.pageCellFactory.set(pageCellFactory);
    }

    public String getEllipseString() {
        return (String)this.ellipseString.get();
    }

    public StringProperty ellipseStringProperty() {
        return this.ellipseString;
    }

    public void setEllipseString(String ellipseString) {
        this.ellipseString.set((Object)ellipseString);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public boolean isShowPopupForTruncatedPages() {
        return this.showPopupForTruncatedPages.get();
    }

    public BooleanProperty showPopupForTruncatedPagesProperty() {
        return this.showPopupForTruncatedPages;
    }

    public void setShowPopupForTruncatedPages(boolean showPopupForTruncatedPages) {
        this.showPopupForTruncatedPages.set(showPopupForTruncatedPages);
    }
}

