/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableDoubleProperty;
import io.github.palexdev.materialfx.beans.properties.styleable.StyleableObjectProperty;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.skins.MFXProgressSpinnerSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class MFXProgressSpinner
extends ProgressIndicator
implements Themable {
    private final String STYLE_CLASS = "mfx-progress-spinner";
    private final ObservableList<NumberRange<Double>> ranges1 = FXCollections.observableArrayList();
    private final ObservableList<NumberRange<Double>> ranges2 = FXCollections.observableArrayList();
    private final ObservableList<NumberRange<Double>> ranges3 = FXCollections.observableArrayList();
    protected final PseudoClass RANGE1_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range1");
    protected final PseudoClass RANGE2_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range2");
    protected final PseudoClass RANGE3_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range3");
    private final StyleableObjectProperty<Color> color1 = new StyleableObjectProperty<Color>(StyleableProperties.COLOR1, this, "color1", Color.web((String)"#4285f4"));
    private final StyleableObjectProperty<Color> color2 = new StyleableObjectProperty<Color>(StyleableProperties.COLOR2, this, "color2", Color.web((String)"#db4437"));
    private final StyleableObjectProperty<Color> color3 = new StyleableObjectProperty<Color>(StyleableProperties.COLOR3, this, "color3", Color.web((String)"#f4b400"));
    private final StyleableObjectProperty<Color> color4 = new StyleableObjectProperty<Color>(StyleableProperties.COLOR4, this, "color4", Color.web((String)"#0F9D58"));
    private final StyleableDoubleProperty radius = new StyleableDoubleProperty(StyleableProperties.RADIUS, this, "radius", -1.0);
    private final StyleableDoubleProperty startingAngle = new StyleableDoubleProperty(StyleableProperties.STARTING_ANGLE, this, "startingAngle", 360.0 - Math.random() * 720.0);

    public MFXProgressSpinner() {
        this(-1.0);
    }

    public MFXProgressSpinner(double progress) {
        super(progress);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-progress-spinner");
        this.addListeners();
        this.sceneBuilderIntegration();
    }

    private void addListeners() {
        this.ranges1.addListener(c -> this.handlePseudoClasses());
        this.ranges2.addListener(c -> this.handlePseudoClasses());
        this.ranges3.addListener(c -> this.handlePseudoClasses());
        this.progressProperty().addListener((observable, oldValue, newValue) -> this.handlePseudoClasses());
    }

    private void handlePseudoClasses() {
        double val = this.getProgress();
        if (!NodeUtils.isPseudoClassActive((Control)this, this.RANGE1_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges1)) {
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, false);
        } else if (!NodeUtils.isPseudoClassActive((Control)this, this.RANGE2_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges2)) {
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, false);
        } else if (!NodeUtils.isPseudoClassActive((Control)this, this.RANGE3_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges3)) {
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, false);
        }
    }

    public ObservableList<NumberRange<Double>> getRanges1() {
        return this.ranges1;
    }

    public ObservableList<NumberRange<Double>> getRanges2() {
        return this.ranges2;
    }

    public ObservableList<NumberRange<Double>> getRanges3() {
        return this.ranges3;
    }

    public Color getColor1() {
        return (Color)this.color1.get();
    }

    public StyleableObjectProperty<Color> color1Property() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1.set(color1);
    }

    public Color getColor2() {
        return (Color)this.color2.get();
    }

    public StyleableObjectProperty<Color> color2Property() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2.set(color2);
    }

    public Color getColor3() {
        return (Color)this.color3.get();
    }

    public StyleableObjectProperty<Color> color3Property() {
        return this.color3;
    }

    public void setColor3(Color color3) {
        this.color3.set(color3);
    }

    public Color getColor4() {
        return (Color)this.color4.get();
    }

    public StyleableObjectProperty<Color> color4Property() {
        return this.color4;
    }

    public void setColor4(Color color4) {
        this.color4.set(color4);
    }

    public double getRadius() {
        return this.radius.get();
    }

    public StyleableDoubleProperty radiusProperty() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius.set(radius);
    }

    public double getStartingAngle() {
        return this.startingAngle.get();
    }

    public StyleableDoubleProperty startingAngleProperty() {
        return this.startingAngle;
    }

    public void setStartingAngle(double startingAngle) {
        this.startingAngle.set(startingAngle);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.PROGRESS_SPINNER;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXProgressSpinnerSkin(this);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXProgressSpinner.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final StyleablePropertyFactory<MFXProgressSpinner> FACTORY = new StyleablePropertyFactory(ProgressIndicator.getClassCssMetaData());
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXProgressSpinner, Color> COLOR1;
        private static final CssMetaData<MFXProgressSpinner, Color> COLOR2;
        private static final CssMetaData<MFXProgressSpinner, Color> COLOR3;
        private static final CssMetaData<MFXProgressSpinner, Color> COLOR4;
        private static final CssMetaData<MFXProgressSpinner, Number> RADIUS;
        private static final CssMetaData<MFXProgressSpinner, Number> STARTING_ANGLE;

        private StyleableProperties() {
        }

        static {
            COLOR1 = FACTORY.createColorCssMetaData("-mfx-color1", MFXProgressSpinner::color1Property, Color.web((String)"#4285f4"));
            COLOR2 = FACTORY.createColorCssMetaData("-mfx-color2", MFXProgressSpinner::color2Property, Color.web((String)"#db4437"));
            COLOR3 = FACTORY.createColorCssMetaData("-mfx-color3", MFXProgressSpinner::color3Property, Color.web((String)"#f4b400"));
            COLOR4 = FACTORY.createColorCssMetaData("-mfx-color4", MFXProgressSpinner::color4Property, Color.web((String)"#0F9D58"));
            RADIUS = FACTORY.createSizeCssMetaData("-mfx-radius", MFXProgressSpinner::radiusProperty, (Number)-1.0);
            STARTING_ANGLE = FACTORY.createSizeCssMetaData("-mfx-starting-angle", MFXProgressSpinner::startingAngleProperty, (Number)(360.0 - Math.random() * 720.0));
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(ProgressIndicator.getClassCssMetaData(), COLOR1, COLOR2, COLOR3, COLOR4, RADIUS, STARTING_ANGLE);
        }
    }
}

