/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.skins.MFXScrollPaneSkin;
import io.github.palexdev.materialfx.theming.CSSFragment;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.ColorUtils;
import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MFXScrollPane
extends ScrollPane
implements Themable {
    private final String STYLE_CLASS = "mfx-scroll-pane";
    private String colorsStylesheet;
    private final ObjectProperty<Paint> trackColor = new SimpleObjectProperty<Paint>((Paint)Color.rgb((int)132, (int)132, (int)132)){

        public void set(Paint newValue) {
            Paint old = (Paint)this.get();
            if (!Objects.equals(old, newValue)) {
                MFXScrollPane.this.setColors();
            }
            super.set((Object)newValue);
        }
    };
    private final ObjectProperty<Paint> thumbColor = new SimpleObjectProperty<Paint>((Paint)Color.rgb((int)137, (int)137, (int)137)){

        public void set(Paint newValue) {
            Paint old = (Paint)this.get();
            if (!Objects.equals(old, newValue)) {
                MFXScrollPane.this.setColors();
            }
            super.set((Object)newValue);
        }
    };
    private final ObjectProperty<Paint> thumbHoverColor = new SimpleObjectProperty<Paint>((Paint)Color.rgb((int)89, (int)88, (int)91)){

        public void set(Paint newValue) {
            Paint old = (Paint)this.get();
            if (!Objects.equals(old, newValue)) {
                MFXScrollPane.this.setColors();
            }
            super.set((Object)newValue);
        }
    };

    public MFXScrollPane() {
        this.initialize();
    }

    public MFXScrollPane(Node content) {
        super(content);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-scroll-pane");
        this.sceneBuilderIntegration();
    }

    public Paint getTrackColor() {
        return (Paint)this.trackColor.get();
    }

    public ObjectProperty<Paint> trackColorProperty() {
        return this.trackColor;
    }

    public void setTrackColor(Paint trackColor) {
        this.trackColor.set((Object)trackColor);
    }

    public Paint getThumbColor() {
        return (Paint)this.thumbColor.get();
    }

    public ObjectProperty<Paint> thumbColorProperty() {
        return this.thumbColor;
    }

    public void setThumbColor(Paint thumbColor) {
        this.thumbColor.set((Object)thumbColor);
    }

    public Paint getThumbHoverColor() {
        return (Paint)this.thumbHoverColor.get();
    }

    public ObjectProperty<Paint> thumbHoverColorProperty() {
        return this.thumbHoverColor;
    }

    public void setThumbHoverColor(Paint thumbHoverColor) {
        this.thumbHoverColor.set((Object)thumbHoverColor);
    }

    private void setColors() {
        if (this.colorsStylesheet != null) {
            this.getStylesheets().remove((Object)this.colorsStylesheet);
        }
        this.colorsStylesheet = CSSFragment.Builder.build().addSelector(".mfx-scroll-pane").addStyle("-track-color: " + ColorUtils.toCss((Paint)this.trackColor.get())).addStyle("-thumb-color: " + ColorUtils.toCss((Paint)this.thumbColor.get())).addStyle("-thumb-hover-color: " + ColorUtils.toCss((Paint)this.thumbHoverColor.get())).closeSelector().toCSS().toDataUri();
        this.getStylesheets().add((Object)this.colorsStylesheet);
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.SCROLL_PANE;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXScrollPaneSkin(this);
    }
}

