/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.beans.properties.functional.SupplierProperty;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.enums.SliderEnums;
import io.github.palexdev.materialfx.skins.MFXSliderSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.NumberUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.mfxresources.fonts.MFXFontIcon;
import java.util.List;
import java.util.function.Supplier;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableIntegerProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextBoundsType;

public class MFXSlider
extends Control
implements Themable {
    private static final StyleablePropertyFactory<MFXSlider> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-slider";
    private final DoubleProperty min = new SimpleDoubleProperty(){

        public void set(double newValue) {
            if (newValue > MFXSlider.this.getMax()) {
                throw new IllegalArgumentException("The minimum value cannot be greater than the max value");
            }
            super.set(newValue);
        }
    };
    private final DoubleProperty max = new SimpleDoubleProperty(){

        public void set(double newValue) {
            if (newValue < MFXSlider.this.getMin()) {
                throw new IllegalArgumentException("The maximum value cannot be lesser than the min value");
            }
            super.set(newValue);
        }
    };
    private final DoubleProperty value = new SimpleDoubleProperty(){

        public void set(double newValue) {
            double clamped = NumberUtils.clamp(newValue, MFXSlider.this.getMin(), MFXSlider.this.getMax());
            super.set(NumberUtils.formatTo(clamped, MFXSlider.this.getDecimalPrecision()));
        }
    };
    private final SupplierProperty<Node> thumbSupplier = new SupplierProperty<Node>(){

        public void set(Supplier<Node> newValue) {
            Node node = newValue.get();
            if (node == null) {
                throw new NullPointerException("Thumb supplier not set as the return values was null!");
            }
            super.set(newValue);
        }
    };
    private final SupplierProperty<Region> popupSupplier = new SupplierProperty();
    private final DoubleProperty popupPadding = new SimpleDoubleProperty(5.0);
    private final IntegerProperty decimalPrecision = new SimpleIntegerProperty(0);
    private final BooleanProperty enableKeyboard = new SimpleBooleanProperty(true);
    private final ObservableList<NumberRange<Double>> ranges1 = FXCollections.observableArrayList();
    private final ObservableList<NumberRange<Double>> ranges2 = FXCollections.observableArrayList();
    private final ObservableList<NumberRange<Double>> ranges3 = FXCollections.observableArrayList();
    protected final PseudoClass RANGE1_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range1");
    protected final PseudoClass RANGE2_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range2");
    protected final PseudoClass RANGE3_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"range3");
    private final StyleableObjectProperty<SliderEnums.SliderMode> sliderMode = new SimpleStyleableObjectProperty(StyleableProperties.SLIDER_MODE, (Object)this, "sliderMode", (Object)SliderEnums.SliderMode.DEFAULT);
    private final StyleableDoubleProperty unitIncrement = new SimpleStyleableDoubleProperty(StyleableProperties.UNIT_INCREMENT, (Object)this, "unitIncrement", Double.valueOf(10.0));
    private final StyleableDoubleProperty alternativeUnitIncrement = new SimpleStyleableDoubleProperty(StyleableProperties.ALTERNATIVE_UNIT_INCREMENT, (Object)this, "alternativeUnitIncrement", Double.valueOf(5.0));
    private final StyleableDoubleProperty tickUnit = new SimpleStyleableDoubleProperty(StyleableProperties.TICK_UNIT, (Object)this, "tickUnit", Double.valueOf(25.0));
    private final StyleableBooleanProperty showMajorTicks = new SimpleStyleableBooleanProperty(StyleableProperties.SHOW_MAJOR_TICKS, (Object)this, "showMajorTicks", false);
    private final StyleableBooleanProperty showMinorTicks = new SimpleStyleableBooleanProperty(StyleableProperties.SHOW_MINOR_TICKS, (Object)this, "showMinorTicks", false);
    private final StyleableBooleanProperty showTicksAtEdges = new SimpleStyleableBooleanProperty(StyleableProperties.SHOW_TICKS_AT_EDGE, (Object)this, "showTicksAtEdge", true);
    private final StyleableIntegerProperty minorTicksCount = new SimpleStyleableIntegerProperty(StyleableProperties.MINOR_TICKS_COUNT, (Object)this, "minorTicksCount", Integer.valueOf(5));
    private final StyleableBooleanProperty animateOnPress = new SimpleStyleableBooleanProperty(StyleableProperties.ANIMATE_ON_PRESS, (Object)this, "animateOnPress", true);
    private final StyleableBooleanProperty bidirectional = new SimpleStyleableBooleanProperty(StyleableProperties.BIDIRECTIONAL, (Object)this, "bidirectional", true);
    private final StyleableObjectProperty<Orientation> orientation = new SimpleStyleableObjectProperty(StyleableProperties.ORIENTATION, (Object)this, "orientation", (Object)Orientation.HORIZONTAL);
    private final StyleableObjectProperty<SliderEnums.SliderPopupSide> popupSide = new SimpleStyleableObjectProperty(StyleableProperties.POPUP_SIDE, (Object)this, "popupSide", (Object)SliderEnums.SliderPopupSide.DEFAULT);

    public MFXSlider() {
        this(0.0);
    }

    public MFXSlider(double initialValue) {
        this(0.0, 100.0, initialValue);
    }

    public MFXSlider(double min, double max, double initialValue) {
        if (min > max) {
            throw new IllegalArgumentException("The minimum value cannot be greater than the max value");
        }
        this.setMin(min);
        this.setMax(max);
        this.setValue(NumberUtils.clamp(initialValue, min, max));
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-slider");
        this.addListeners();
        this.defaultThumbSupplier();
        this.defaultPopupSupplier();
        this.sceneBuilderIntegration();
    }

    private void addListeners() {
        this.ranges1.addListener(c -> this.handlePseudoClasses());
        this.ranges2.addListener(c -> this.handlePseudoClasses());
        this.ranges3.addListener(c -> this.handlePseudoClasses());
        this.value.addListener((observable, oldValue, newValue) -> this.handlePseudoClasses());
    }

    private void handlePseudoClasses() {
        double val = this.getValue();
        if (!NodeUtils.isPseudoClassActive(this, this.RANGE1_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges1)) {
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, false);
        } else if (!NodeUtils.isPseudoClassActive(this, this.RANGE2_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges2)) {
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, false);
        } else if (!NodeUtils.isPseudoClassActive(this, this.RANGE3_PSEUDO_CLASS) && NumberRange.inRangeOf(val, this.ranges3)) {
            this.pseudoClassStateChanged(this.RANGE3_PSEUDO_CLASS, true);
            this.pseudoClassStateChanged(this.RANGE1_PSEUDO_CLASS, false);
            this.pseudoClassStateChanged(this.RANGE2_PSEUDO_CLASS, false);
        }
    }

    protected void defaultThumbSupplier() {
        this.setThumbSupplier(() -> {
            MFXFontIcon thumb = new MFXFontIcon("fas-circle", 12.0);
            MFXFontIcon thumbRadius = new MFXFontIcon("fas-circle", 30.0);
            thumb.setMouseTransparent(true);
            thumbRadius.setMouseTransparent(true);
            thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
            thumbRadius.getStyleClass().setAll((Object[])new String[]{"thumb-radius"});
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().add((Object)"thumb-container");
            stackPane.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            stackPane.setPrefSize(NodeUtils.getNodeWidth((Node)thumb), NodeUtils.getNodeHeight((Node)thumb));
            stackPane.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            stackPane.getChildren().setAll((Object[])new Node[]{thumb, thumbRadius});
            MFXCircleRippleGenerator rippleGenerator = new MFXCircleRippleGenerator((Region)stackPane);
            rippleGenerator.setAnimateBackground(false);
            rippleGenerator.setAnimationSpeed(2.0);
            rippleGenerator.setCheckBounds(false);
            rippleGenerator.setClipSupplier(() -> null);
            rippleGenerator.setMouseTransparent(true);
            rippleGenerator.setRadiusMultiplier(2.5);
            rippleGenerator.setRippleRadius(6.0);
            rippleGenerator.setRipplePositionFunction(mouseEvent -> PositionBean.of(stackPane.getWidth() / 2.0, stackPane.getHeight() / 2.0));
            stackPane.addEventFilter(MouseEvent.MOUSE_PRESSED, rippleGenerator::generateRipple);
            stackPane.getChildren().add((Object)rippleGenerator);
            return stackPane;
        });
    }

    protected void defaultPopupSupplier() {
        this.setPopupSupplier(() -> {
            Label text = new Label();
            text.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            text.setAlignment(Pos.CENTER);
            text.setId("popupText");
            text.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> NumberUtils.formatToString(this.getValue(), this.getDecimalPrecision()), (Observable[])new Observable[]{this.value}));
            text.rotateProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.getPopupSide() == SliderEnums.SliderPopupSide.DEFAULT ? 0.0 : 180.0, (Observable[])new Observable[]{this.popupSideProperty()}));
            VBox.setVgrow((Node)text, (Priority)Priority.ALWAYS);
            final MFXFontIcon caret = new MFXFontIcon("fas-caret-down", 22.0);
            caret.setId("popupCaret");
            caret.setBoundsType(TextBoundsType.VISUAL);
            caret.setManaged(false);
            VBox container = new VBox(new Node[]{text, caret}){

                protected void layoutChildren() {
                    super.layoutChildren();
                    Orientation orientation = MFXSlider.this.getOrientation();
                    double x = orientation == Orientation.HORIZONTAL ? this.getWidth() / 2.0 - caret.prefWidth(-1.0) / 2.0 : this.getHeight();
                    double y = orientation == Orientation.HORIZONTAL ? this.getHeight() : -(caret.prefHeight(-1.0) / 2.0) + this.getHeight() / 2.0;
                    caret.relocate(this.snapPositionX(x), this.snapPositionY(y));
                }
            };
            container.setId("popupContent");
            container.setAlignment(Pos.TOP_CENTER);
            container.setMinSize(45.0, 40.0);
            caret.rotateProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                container.requestLayout();
                return this.getOrientation() == Orientation.HORIZONTAL ? 0.0 : -90.0;
            }, (Observable[])new Observable[]{this.needsLayoutProperty(), this.rotateProperty(), this.popupSideProperty()}));
            return container;
        });
    }

    public double getMin() {
        return this.min.get();
    }

    public DoubleProperty minProperty() {
        return this.min;
    }

    public void setMin(double min) {
        this.min.set(min);
    }

    public double getMax() {
        return this.max.get();
    }

    public DoubleProperty maxProperty() {
        return this.max;
    }

    public void setMax(double max) {
        this.max.set(max);
    }

    public double getValue() {
        return this.value.get();
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public void setValue(double value) {
        this.value.set(value);
    }

    public Supplier<Node> getThumbSupplier() {
        return (Supplier)this.thumbSupplier.get();
    }

    public SupplierProperty<Node> thumbSupplierProperty() {
        return this.thumbSupplier;
    }

    public void setThumbSupplier(Supplier<Node> thumbSupplier) {
        this.thumbSupplier.set(thumbSupplier);
    }

    public Supplier<Region> getPopupSupplier() {
        return (Supplier)this.popupSupplier.get();
    }

    public SupplierProperty<Region> popupSupplierProperty() {
        return this.popupSupplier;
    }

    public void setPopupSupplier(Supplier<Region> popupSupplier) {
        this.popupSupplier.set(popupSupplier);
    }

    public double getPopupPadding() {
        return this.popupPadding.get();
    }

    public DoubleProperty popupPaddingProperty() {
        return this.popupPadding;
    }

    public void setPopupPadding(double popupPadding) {
        this.popupPadding.set(popupPadding);
    }

    public int getDecimalPrecision() {
        return this.decimalPrecision.get();
    }

    public IntegerProperty decimalPrecisionProperty() {
        return this.decimalPrecision;
    }

    public void setDecimalPrecision(int decimalPrecision) {
        this.decimalPrecision.set(decimalPrecision);
    }

    public boolean isEnableKeyboard() {
        return this.enableKeyboard.get();
    }

    public BooleanProperty enableKeyboardProperty() {
        return this.enableKeyboard;
    }

    public void setEnableKeyboard(boolean enableKeyboard) {
        this.enableKeyboard.set(enableKeyboard);
    }

    public ObservableList<NumberRange<Double>> getRanges1() {
        return this.ranges1;
    }

    public ObservableList<NumberRange<Double>> getRanges2() {
        return this.ranges2;
    }

    public ObservableList<NumberRange<Double>> getRanges3() {
        return this.ranges3;
    }

    public SliderEnums.SliderMode getSliderMode() {
        return (SliderEnums.SliderMode)((Object)this.sliderMode.get());
    }

    public StyleableObjectProperty<SliderEnums.SliderMode> sliderModeProperty() {
        return this.sliderMode;
    }

    public void setSliderMode(SliderEnums.SliderMode sliderMode) {
        this.sliderMode.set((Object)sliderMode);
    }

    public double getUnitIncrement() {
        return this.unitIncrement.get();
    }

    public StyleableDoubleProperty unitIncrementProperty() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(double unitIncrement) {
        this.unitIncrement.set(unitIncrement);
    }

    public double getAlternativeUnitIncrement() {
        return this.alternativeUnitIncrement.get();
    }

    public StyleableDoubleProperty alternativeUnitIncrementProperty() {
        return this.alternativeUnitIncrement;
    }

    public void setAlternativeUnitIncrement(double alternativeUnitIncrement) {
        this.alternativeUnitIncrement.set(alternativeUnitIncrement);
    }

    public double getTickUnit() {
        return this.tickUnit.get();
    }

    public StyleableDoubleProperty tickUnitProperty() {
        return this.tickUnit;
    }

    public void setTickUnit(double tickUnit) {
        this.tickUnit.set(tickUnit);
    }

    public boolean isShowMajorTicks() {
        return this.showMajorTicks.get();
    }

    public StyleableBooleanProperty showMajorTicksProperty() {
        return this.showMajorTicks;
    }

    public void setShowMajorTicks(boolean showMajorTicks) {
        this.showMajorTicks.set(showMajorTicks);
    }

    public boolean isShowMinorTicks() {
        return this.showMinorTicks.get();
    }

    public StyleableBooleanProperty showMinorTicksProperty() {
        return this.showMinorTicks;
    }

    public void setShowMinorTicks(boolean showMinorTicks) {
        this.showMinorTicks.set(showMinorTicks);
    }

    public boolean isShowTicksAtEdges() {
        return this.showTicksAtEdges.get();
    }

    public StyleableBooleanProperty showTicksAtEdgesProperty() {
        return this.showTicksAtEdges;
    }

    public void setShowTicksAtEdges(boolean showTicksAtEdges) {
        this.showTicksAtEdges.set(showTicksAtEdges);
    }

    public int getMinorTicksCount() {
        return this.minorTicksCount.get();
    }

    public StyleableIntegerProperty minorTicksCountProperty() {
        return this.minorTicksCount;
    }

    public void setMinorTicksCount(int minorTicksCount) {
        this.minorTicksCount.set(minorTicksCount);
    }

    public boolean isAnimateOnPress() {
        return this.animateOnPress.get();
    }

    public StyleableBooleanProperty animateOnPressProperty() {
        return this.animateOnPress;
    }

    public void setAnimateOnPress(boolean animateOnPress) {
        this.animateOnPress.set(animateOnPress);
    }

    public boolean isBidirectional() {
        return this.bidirectional.get();
    }

    public StyleableBooleanProperty bidirectionalProperty() {
        return this.bidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional.set(bidirectional);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public StyleableObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    public SliderEnums.SliderPopupSide getPopupSide() {
        return (SliderEnums.SliderPopupSide)((Object)this.popupSide.get());
    }

    public StyleableObjectProperty<SliderEnums.SliderPopupSide> popupSideProperty() {
        return this.popupSide;
    }

    public void setPopupSide(SliderEnums.SliderPopupSide popupSide) {
        this.popupSide.set((Object)popupSide);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.SLIDER;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXSliderSkin(this);
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXSlider.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXSlider, SliderEnums.SliderMode> SLIDER_MODE;
        private static final CssMetaData<MFXSlider, Number> UNIT_INCREMENT;
        private static final CssMetaData<MFXSlider, Number> ALTERNATIVE_UNIT_INCREMENT;
        private static final CssMetaData<MFXSlider, Number> TICK_UNIT;
        private static final CssMetaData<MFXSlider, Boolean> SHOW_MAJOR_TICKS;
        private static final CssMetaData<MFXSlider, Boolean> SHOW_MINOR_TICKS;
        private static final CssMetaData<MFXSlider, Boolean> SHOW_TICKS_AT_EDGE;
        private static final CssMetaData<MFXSlider, Number> MINOR_TICKS_COUNT;
        private static final CssMetaData<MFXSlider, Boolean> ANIMATE_ON_PRESS;
        private static final CssMetaData<MFXSlider, Boolean> BIDIRECTIONAL;
        private static final CssMetaData<MFXSlider, Orientation> ORIENTATION;
        private static final CssMetaData<MFXSlider, SliderEnums.SliderPopupSide> POPUP_SIDE;

        private StyleableProperties() {
        }

        static {
            SLIDER_MODE = FACTORY.createEnumCssMetaData(SliderEnums.SliderMode.class, "-mfx-slider-mode", MFXSlider::sliderModeProperty, (Enum)SliderEnums.SliderMode.DEFAULT);
            UNIT_INCREMENT = FACTORY.createSizeCssMetaData("-mfx-unit-increment", MFXSlider::unitIncrementProperty, (Number)10.0);
            ALTERNATIVE_UNIT_INCREMENT = FACTORY.createSizeCssMetaData("-mfx-alternative-unit-increment", MFXSlider::alternativeUnitIncrementProperty, (Number)5.0);
            TICK_UNIT = FACTORY.createSizeCssMetaData("-mfx-tick-unit", MFXSlider::tickUnitProperty, (Number)25.0);
            SHOW_MAJOR_TICKS = FACTORY.createBooleanCssMetaData("-mfx-show-major-ticks", MFXSlider::showMajorTicksProperty, false);
            SHOW_MINOR_TICKS = FACTORY.createBooleanCssMetaData("-mfx-show-minor-ticks", MFXSlider::showMinorTicksProperty, false);
            SHOW_TICKS_AT_EDGE = FACTORY.createBooleanCssMetaData("-mfx-show-ticks-at-edge", MFXSlider::showTicksAtEdgesProperty, true);
            MINOR_TICKS_COUNT = FACTORY.createSizeCssMetaData("-mfx-minor-ticks-count", MFXSlider::minorTicksCountProperty, (Number)5);
            ANIMATE_ON_PRESS = FACTORY.createBooleanCssMetaData("-mfx-animate-on-press", MFXSlider::animateOnPressProperty, true);
            BIDIRECTIONAL = FACTORY.createBooleanCssMetaData("-mfx-bidirectional", MFXSlider::bidirectionalProperty, true);
            ORIENTATION = FACTORY.createEnumCssMetaData(Orientation.class, "-mfx-orientation", MFXSlider::orientationProperty, (Enum)Orientation.HORIZONTAL);
            POPUP_SIDE = FACTORY.createEnumCssMetaData(SliderEnums.SliderPopupSide.class, "-mfx-popup-side", MFXSlider::popupSideProperty, (Enum)SliderEnums.SliderPopupSide.DEFAULT);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(Control.getClassCssMetaData(), SLIDER_MODE, UNIT_INCREMENT, ALTERNATIVE_UNIT_INCREMENT, TICK_UNIT, SHOW_MAJOR_TICKS, SHOW_MINOR_TICKS, SHOW_TICKS_AT_EDGE, MINOR_TICKS_COUNT, ANIMATE_ON_PRESS, BIDIRECTIONAL, ORIENTATION, POPUP_SIDE);
        }
    }
}

