/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.EventHandlerProperty;
import io.github.palexdev.materialfx.controls.MFXStepperToggle;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.enums.StepperToggleState;
import io.github.palexdev.materialfx.skins.MFXStepperSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.StyleablePropertiesUtils;
import io.github.palexdev.materialfx.validation.MFXValidator;
import io.github.palexdev.materialfx.validation.Validated;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MFXStepper
extends Control
implements Themable {
    private static final StyleablePropertyFactory<MFXStepper> FACTORY = new StyleablePropertyFactory(Control.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-stepper";
    private final ObservableList<MFXStepperToggle> stepperToggles = FXCollections.observableArrayList();
    private final DoubleProperty animationDuration = new SimpleDoubleProperty(700.0);
    private final ReadOnlyDoubleWrapper progress = new ReadOnlyDoubleWrapper();
    private final ReadOnlyIntegerWrapper currentIndex = new ReadOnlyIntegerWrapper(-1);
    private final ReadOnlyObjectWrapper<Node> currentContent = new ReadOnlyObjectWrapper();
    private final ReadOnlyBooleanWrapper lastToggle = new ReadOnlyBooleanWrapper(false);
    private boolean enableContentValidationOnError = true;
    private final StyleableDoubleProperty spacing = new SimpleStyleableDoubleProperty(StyleableProperties.SPACING, (Object)this, "spacing", Double.valueOf(128.0));
    private final StyleableDoubleProperty extraSpacing = new SimpleStyleableDoubleProperty(StyleableProperties.EXTRA_SPACING, (Object)this, "extraSpacing", Double.valueOf(64.0));
    private final StyleableObjectProperty<Pos> alignment = new SimpleStyleableObjectProperty(StyleableProperties.ALIGNMENT, (Object)this, "alignment", (Object)Pos.CENTER);
    private final StyleableObjectProperty<Paint> baseColor = new SimpleStyleableObjectProperty(StyleableProperties.BASE_COLOR, (Object)this, "baseColor", (Object)Color.web((String)"#7F0FFF"));
    private final StyleableObjectProperty<Paint> altColor = new SimpleStyleableObjectProperty(StyleableProperties.ALT_COLOR, (Object)this, "altColor", (Object)Color.web((String)"BEBEBE"));
    private final StyleableDoubleProperty progressBarBorderRadius = new SimpleStyleableDoubleProperty(StyleableProperties.BORDER_RADIUS, (Object)this, "progressBarBorderRadius", Double.valueOf(7.0));
    private final StyleableObjectProperty<Paint> progressBarBackground = new SimpleStyleableObjectProperty(StyleableProperties.PROGRESS_BAR_BACKGROUND, (Object)this, "progressBarBackground", (Object)Color.web((String)"#F8F8FF"));
    private final StyleableObjectProperty<Paint> progressColor = new SimpleStyleableObjectProperty(StyleableProperties.PROGRESS_COLOR, (Object)this, "progressColor", (Object)Color.web((String)"#7F0FFF"));
    private final StyleableBooleanProperty animated = new SimpleStyleableBooleanProperty(StyleableProperties.PROGRESS_BAR_ANIMATED, (Object)this, "animated", true);
    private final EventHandlerProperty<MFXStepperEvent> onBeforeNext = new EventHandlerProperty<MFXStepperEvent>(){

        protected void invalidated() {
            MFXStepper.this.setEventHandler(MFXStepperEvent.BEFORE_NEXT_EVENT, (EventHandler)this.get());
        }
    };
    private final EventHandlerProperty<MFXStepperEvent> onNext = new EventHandlerProperty<MFXStepperEvent>(){

        protected void invalidated() {
            MFXStepper.this.setEventHandler(MFXStepperEvent.NEXT_EVENT, (EventHandler)this.get());
        }
    };
    private final EventHandlerProperty<MFXStepperEvent> onBeforePrevious = new EventHandlerProperty<MFXStepperEvent>(){

        protected void invalidated() {
            MFXStepper.this.setEventHandler(MFXStepperEvent.BEFORE_PREVIOUS_EVENT, (EventHandler)this.get());
        }
    };
    private final EventHandlerProperty<MFXStepperEvent> onPrevious = new EventHandlerProperty<MFXStepperEvent>(){

        protected void invalidated() {
            MFXStepper.this.setEventHandler(MFXStepperEvent.PREVIOUS_EVENT, (EventHandler)this.get());
        }
    };
    private final EventHandlerProperty<MFXStepperEvent> onLastNext = new EventHandlerProperty<MFXStepperEvent>(){

        protected void invalidated() {
            MFXStepper.this.setEventHandler(MFXStepperEvent.LAST_NEXT_EVENT, (EventHandler)this.get());
        }
    };
    private final EventHandlerProperty<MFXStepperEvent> onValidationFailed = new EventHandlerProperty<MFXStepperEvent>(){

        protected void invalidated() {
            MFXStepper.this.setEventHandler(MFXStepperEvent.VALIDATION_FAILED_EVENT, (EventHandler)this.get());
        }
    };

    public MFXStepper() {
        this(new ArrayList<MFXStepperToggle>());
    }

    public MFXStepper(List<MFXStepperToggle> stepperToggles) {
        this.setStepperToggles(stepperToggles);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().setAll((Object[])new String[]{"mfx-stepper"});
        this.setMinHeight(400.0);
        this.addListeners();
        this.sceneBuilderIntegration();
    }

    private void addListeners() {
        this.addEventHandler(MFXStepperToggle.MFXStepperToggleEvent.STATE_CHANGED, event -> this.updateProgress());
    }

    public void next() {
        if (this.stepperToggles.isEmpty()) {
            return;
        }
        this.fireEvent(MFXStepperEvent.BEFORE_NEXT_EVENT);
        int currentIndex = this.getCurrentIndex();
        if (currentIndex == -1) {
            MFXStepperToggle first = (MFXStepperToggle)this.stepperToggles.get(0);
            first.setState(StepperToggleState.SELECTED);
            this.currentIndex.set(0);
            this.setCurrentContent(first.getContent());
            return;
        }
        MFXStepperToggle current = (MFXStepperToggle)this.stepperToggles.get(currentIndex);
        if (!current.isValid()) {
            if (current.getState() != StepperToggleState.ERROR) {
                current.setState(StepperToggleState.ERROR);
            }
            if (this.isEnableContentValidationOnError()) {
                this.forceContentValidation();
            }
            this.fireEvent(MFXStepperEvent.VALIDATION_FAILED_EVENT);
            return;
        }
        if (currentIndex < this.stepperToggles.size() - 1) {
            MFXStepperToggle next = (MFXStepperToggle)this.stepperToggles.get(currentIndex + 1);
            current.setState(StepperToggleState.COMPLETED);
            next.setState(StepperToggleState.SELECTED);
            this.currentIndex.set(currentIndex + 1);
            this.setCurrentContent(next.getContent());
            this.fireEvent(MFXStepperEvent.NEXT_EVENT);
        } else {
            this.setLastToggle(true);
            current.setState(StepperToggleState.COMPLETED);
            this.fireEvent(MFXStepperEvent.LAST_NEXT_EVENT);
        }
    }

    public void previous() {
        if (this.stepperToggles.isEmpty()) {
            return;
        }
        this.fireEvent(MFXStepperEvent.BEFORE_PREVIOUS_EVENT);
        int currentIndex = this.getCurrentIndex();
        if (this.isLastToggle()) {
            this.setLastToggle(false);
            MFXStepperToggle last = this.getCurrentStepperNode();
            last.setState(StepperToggleState.SELECTED);
            return;
        }
        if (currentIndex == -1) {
            MFXStepperToggle stepperNode = (MFXStepperToggle)this.stepperToggles.get(0);
            stepperNode.setState(StepperToggleState.SELECTED);
            this.currentIndex.set(0);
            this.setCurrentContent(stepperNode.getContent());
            return;
        }
        if (currentIndex > 0) {
            MFXStepperToggle current = (MFXStepperToggle)this.stepperToggles.get(currentIndex);
            MFXStepperToggle previous = (MFXStepperToggle)this.stepperToggles.get(currentIndex - 1);
            current.setState(StepperToggleState.NONE);
            previous.setState(StepperToggleState.SELECTED);
            this.currentIndex.set(currentIndex - 1);
            this.setCurrentContent(previous.getContent());
            this.fireEvent(MFXStepperEvent.PREVIOUS_EVENT);
        }
    }

    private void forceContentValidation() {
        if (this.getCurrentContent() == null) {
            return;
        }
        ArrayList<MFXValidator> validators = new ArrayList<MFXValidator>();
        Node currentContent = this.getCurrentContent();
        if (currentContent instanceof Validated) {
            Validated validated = (Validated)currentContent;
            if (validated.getValidator() != null) {
                validators.add(validated.getValidator());
            }
        } else if (currentContent instanceof Parent) {
            ArrayList<Node> allChildren = NodeUtils.getAllNodes((Parent)currentContent);
            allChildren.stream().filter(node -> node instanceof Validated).map(node -> ((Validated)node).getValidator()).filter(Objects::nonNull).forEach(validators::add);
        }
        validators.forEach(MFXValidator::update);
    }

    public void reset() {
        this.setLastToggle(false);
        this.currentIndex.set(-1);
        this.stepperToggles.forEach(stepperToggle -> stepperToggle.setState(StepperToggleState.NONE));
    }

    public MFXStepperToggle getCurrentStepperNode() {
        try {
            return (MFXStepperToggle)this.stepperToggles.get(this.getCurrentIndex());
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public void updateProgress() {
        double completed = Math.toIntExact(this.stepperToggles.stream().filter(s -> s.getState() == StepperToggleState.COMPLETED).count());
        this.progress.set(completed / (double)this.stepperToggles.size());
    }

    public ObservableList<MFXStepperToggle> getStepperToggles() {
        return this.stepperToggles;
    }

    public void setStepperToggles(List<MFXStepperToggle> stepperToggles) {
        this.stepperToggles.setAll(stepperToggles);
    }

    public double getAnimationDuration() {
        return this.animationDuration.get();
    }

    public DoubleProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public void setAnimationDuration(double animationDuration) {
        this.animationDuration.set(animationDuration);
    }

    public double getProgress() {
        return this.progress.get();
    }

    public ReadOnlyDoubleProperty progressProperty() {
        return this.progress.getReadOnlyProperty();
    }

    protected void setProgress(double progress) {
        this.progress.set(progress);
    }

    public int getCurrentIndex() {
        return this.currentIndex.get();
    }

    public ReadOnlyIntegerProperty currentIndexProperty() {
        return this.currentIndex.getReadOnlyProperty();
    }

    protected void setCurrentIndex(int currentIndex) {
        this.currentIndex.set(currentIndex);
    }

    public Node getCurrentContent() {
        return (Node)this.currentContent.get();
    }

    public ReadOnlyObjectProperty<Node> currentContentProperty() {
        return this.currentContent.getReadOnlyProperty();
    }

    protected void setCurrentContent(Node content) {
        this.currentContent.set((Object)content);
    }

    public boolean isLastToggle() {
        return this.lastToggle.get();
    }

    public ReadOnlyBooleanProperty lastToggleProperty() {
        return this.lastToggle.getReadOnlyProperty();
    }

    protected void setLastToggle(boolean lastToggle) {
        this.lastToggle.set(lastToggle);
    }

    public boolean isEnableContentValidationOnError() {
        return this.enableContentValidationOnError;
    }

    public void setEnableContentValidationOnError(boolean enableContentValidationOnError) {
        this.enableContentValidationOnError = enableContentValidationOnError;
    }

    public double getSpacing() {
        return this.spacing.get();
    }

    public StyleableDoubleProperty spacingProperty() {
        return this.spacing;
    }

    public void setSpacing(double spacing) {
        this.spacing.set(spacing);
    }

    public double getExtraSpacing() {
        return this.extraSpacing.get();
    }

    public StyleableDoubleProperty extraSpacingProperty() {
        return this.extraSpacing;
    }

    public void setExtraSpacing(double extraSpacing) {
        this.extraSpacing.set(extraSpacing);
    }

    public Pos getAlignment() {
        return (Pos)this.alignment.get();
    }

    public StyleableObjectProperty<Pos> alignmentProperty() {
        return this.alignment;
    }

    public void setAlignment(Pos alignment) {
        this.alignment.set((Object)alignment);
    }

    public Paint getBaseColor() {
        return (Paint)this.baseColor.get();
    }

    public StyleableObjectProperty<Paint> baseColorProperty() {
        return this.baseColor;
    }

    public void setBaseColor(Paint baseColor) {
        this.baseColor.set((Object)baseColor);
    }

    public Paint getAltColor() {
        return (Paint)this.altColor.get();
    }

    public StyleableObjectProperty<Paint> altColorProperty() {
        return this.altColor;
    }

    public void setAltColor(Paint altColor) {
        this.altColor.set((Object)altColor);
    }

    public double getProgressBarBorderRadius() {
        return this.progressBarBorderRadius.get();
    }

    public StyleableDoubleProperty progressBarBorderRadiusProperty() {
        return this.progressBarBorderRadius;
    }

    public void setProgressBarBorderRadius(double progressBarBorderRadius) {
        this.progressBarBorderRadius.set(progressBarBorderRadius);
    }

    public Paint getProgressBarBackground() {
        return (Paint)this.progressBarBackground.get();
    }

    public StyleableObjectProperty<Paint> progressBarBackgroundProperty() {
        return this.progressBarBackground;
    }

    public void setProgressBarBackground(Paint progressBarBackground) {
        this.progressBarBackground.set((Object)progressBarBackground);
    }

    public Paint getProgressColor() {
        return (Paint)this.progressColor.get();
    }

    public StyleableObjectProperty<Paint> progressColorProperty() {
        return this.progressColor;
    }

    public void setProgressColor(Paint progressColor) {
        this.progressColor.set((Object)progressColor);
    }

    public boolean isAnimated() {
        return this.animated.get();
    }

    public StyleableBooleanProperty animatedProperty() {
        return this.animated;
    }

    public void setAnimated(boolean animated) {
        this.animated.set(animated);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.STEPPER;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXStepperSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXStepper.getControlCssMetaDataList();
    }

    public EventHandler<MFXStepperEvent> getOnBeforeNext() {
        return (EventHandler)this.onBeforeNext.get();
    }

    public EventHandlerProperty<MFXStepperEvent> onBeforeNextProperty() {
        return this.onBeforeNext;
    }

    public void setOnBeforeNext(EventHandler<MFXStepperEvent> onBeforeNext) {
        this.onBeforeNext.set(onBeforeNext);
    }

    public EventHandler<MFXStepperEvent> getOnNext() {
        return (EventHandler)this.onNext.get();
    }

    public EventHandlerProperty<MFXStepperEvent> onNextProperty() {
        return this.onNext;
    }

    public void setOnNext(EventHandler<MFXStepperEvent> onNext) {
        this.onNext.set(onNext);
    }

    public EventHandler<MFXStepperEvent> getOnBeforePrevious() {
        return (EventHandler)this.onBeforePrevious.get();
    }

    public EventHandlerProperty<MFXStepperEvent> onBeforePreviousProperty() {
        return this.onBeforePrevious;
    }

    public void setOnBeforePrevious(EventHandler<MFXStepperEvent> onBeforePrevious) {
        this.onBeforePrevious.set(onBeforePrevious);
    }

    public EventHandler<MFXStepperEvent> getOnPrevious() {
        return (EventHandler)this.onPrevious.get();
    }

    public EventHandlerProperty<MFXStepperEvent> onPreviousProperty() {
        return this.onPrevious;
    }

    public void setOnPrevious(EventHandler<MFXStepperEvent> onPrevious) {
        this.onPrevious.set(onPrevious);
    }

    public EventHandler<MFXStepperEvent> getOnLastNext() {
        return (EventHandler)this.onLastNext.get();
    }

    public EventHandlerProperty<MFXStepperEvent> onLastNextProperty() {
        return this.onLastNext;
    }

    public void setOnLastNext(EventHandler<MFXStepperEvent> onLastNext) {
        this.onLastNext.set(onLastNext);
    }

    public EventHandler<MFXStepperEvent> getOnValidationFailed() {
        return (EventHandler)this.onValidationFailed.get();
    }

    public EventHandlerProperty<MFXStepperEvent> onValidationFailedProperty() {
        return this.onValidationFailed;
    }

    public void setOnValidationFailed(EventHandler<MFXStepperEvent> onValidationFailed) {
        this.onValidationFailed.set(onValidationFailed);
    }

    public void fireEvent(EventType<MFXStepperEvent> eventType) {
        this.fireEvent(new MFXStepperEvent(eventType));
    }

    public void forceLayoutUpdate() {
        this.fireEvent(MFXStepperEvent.FORCE_LAYOUT_UPDATE_EVENT);
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXStepper, Number> SPACING;
        private static final CssMetaData<MFXStepper, Number> EXTRA_SPACING;
        private static final CssMetaData<MFXStepper, Pos> ALIGNMENT;
        private static final CssMetaData<MFXStepper, Paint> BASE_COLOR;
        private static final CssMetaData<MFXStepper, Paint> ALT_COLOR;
        private static final CssMetaData<MFXStepper, Number> BORDER_RADIUS;
        private static final CssMetaData<MFXStepper, Paint> PROGRESS_BAR_BACKGROUND;
        private static final CssMetaData<MFXStepper, Paint> PROGRESS_COLOR;
        private static final CssMetaData<MFXStepper, Boolean> PROGRESS_BAR_ANIMATED;

        private StyleableProperties() {
        }

        static {
            SPACING = FACTORY.createSizeCssMetaData("-mfx-spacing", MFXStepper::spacingProperty, (Number)128.0);
            EXTRA_SPACING = FACTORY.createSizeCssMetaData("-mfx-extra-spacing", MFXStepper::extraSpacingProperty, (Number)64.0);
            ALIGNMENT = FACTORY.createEnumCssMetaData(Pos.class, "-mfx-alignment", MFXStepper::alignmentProperty, (Enum)Pos.CENTER);
            BASE_COLOR = FACTORY.createPaintCssMetaData("-mfx-base-color", MFXStepper::baseColorProperty, (Paint)Color.web((String)"7F0FFF"));
            ALT_COLOR = FACTORY.createPaintCssMetaData("-mfx-alt-color", MFXStepper::altColorProperty, (Paint)Color.web((String)"BEBEBE"));
            BORDER_RADIUS = FACTORY.createSizeCssMetaData("-mfx-bar-borders-radius", MFXStepper::progressBarBorderRadiusProperty, (Number)7.0);
            PROGRESS_BAR_BACKGROUND = FACTORY.createPaintCssMetaData("-mfx-bar-background", MFXStepper::progressBarBackgroundProperty, (Paint)Color.web((String)"#F8F8FF"));
            PROGRESS_COLOR = FACTORY.createPaintCssMetaData("-mfx-progress-color", MFXStepper::progressColorProperty, (Paint)Color.web((String)"#7F0FFF"));
            PROGRESS_BAR_ANIMATED = FACTORY.createBooleanCssMetaData("-mfx-bar-animated", MFXStepper::animatedProperty, true);
            cssMetaDataList = StyleablePropertiesUtils.cssMetaDataList(Control.getClassCssMetaData(), SPACING, EXTRA_SPACING, ALIGNMENT, BASE_COLOR, ALT_COLOR, BORDER_RADIUS, PROGRESS_BAR_BACKGROUND, PROGRESS_COLOR, PROGRESS_BAR_ANIMATED);
        }
    }

    public static class MFXStepperEvent
    extends Event {
        public static final EventType<MFXStepperEvent> FORCE_LAYOUT_UPDATE_EVENT = new EventType(ANY, "FORCE_LAYOUT_UPDATE_EVENT");
        public static final EventType<MFXStepperEvent> BEFORE_NEXT_EVENT = new EventType(ANY, "BEFORE_NEXT_EVENT");
        public static final EventType<MFXStepperEvent> NEXT_EVENT = new EventType(ANY, "NEXT_EVENT");
        public static final EventType<MFXStepperEvent> BEFORE_PREVIOUS_EVENT = new EventType(ANY, "BEFORE_PREVIOUS_EVENT");
        public static final EventType<MFXStepperEvent> PREVIOUS_EVENT = new EventType(ANY, "PREVIOUS_EVENT");
        public static final EventType<MFXStepperEvent> LAST_NEXT_EVENT = new EventType(ANY, "LAST_NEXT_EVENT");
        public static final EventType<MFXStepperEvent> VALIDATION_FAILED_EVENT = new EventType(ANY, "VALIDATION_FAILED_EVENT");

        public MFXStepperEvent(EventType<? extends Event> eventType) {
            super(eventType);
        }
    }
}

