/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls;

import io.github.palexdev.materialfx.beans.properties.functional.FunctionProperty;
import io.github.palexdev.materialfx.collections.TransformableListWrapper;
import io.github.palexdev.materialfx.controls.MFXTableColumn;
import io.github.palexdev.materialfx.controls.MFXTableRow;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.materialfx.controls.cell.MFXTableRowCell;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import io.github.palexdev.materialfx.selection.MultipleSelectionModel;
import io.github.palexdev.materialfx.selection.base.IMultipleSelectionModel;
import io.github.palexdev.materialfx.skins.MFXTableViewSkin;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.ListChangeHelper;
import io.github.palexdev.materialfx.utils.ListChangeProcessor;
import io.github.palexdev.materialfx.utils.others.observables.When;
import io.github.palexdev.mfxcore.base.TriConsumer;
import io.github.palexdev.mfxcore.base.beans.range.IntegerRange;
import io.github.palexdev.virtualizedfx.unused.simple.SimpleVirtualFlow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class MFXTableView<T>
extends Control
implements Themable {
    private final String STYLE_CLASS = "mfx-table-view";
    protected final SimpleVirtualFlow<T, MFXTableRow<T>> rowsFlow;
    protected final ReadOnlyBooleanWrapper virtualFlowInitialized = new ReadOnlyBooleanWrapper();
    private final ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty();
    private final ListChangeListener<? super T> itemsChanged = this::itemsChanged;
    private final IMultipleSelectionModel<T> selectionModel = new MultipleSelectionModel<T>(this.items);
    private final ObservableList<MFXTableColumn<T>> tableColumns = FXCollections.observableArrayList();
    private final FunctionProperty<T, MFXTableRow<T>> tableRowFactory = new FunctionProperty<Object, MFXTableRow>(item -> new MFXTableRow<Object>(this, item));
    private final TransformableListWrapper<T> transformableList = new TransformableListWrapper(FXCollections.observableArrayList());
    private final ObservableList<AbstractFilter<T, ?>> filters = FXCollections.observableArrayList();
    private final InvalidationListener itemsInvalid = invalidated -> this.transformableList.setAll((Collection<T>)this.getItems());
    private final BooleanProperty footerVisible = new SimpleBooleanProperty(true);

    public MFXTableView() {
        this(FXCollections.observableArrayList());
    }

    public MFXTableView(ObservableList<T> items) {
        this.setItems(items);
        this.rowsFlow = new SimpleVirtualFlow(this.transformableList, this.getTableRowFactory(), Orientation.VERTICAL);
        this.rowsFlow.cellFactoryProperty().bind(this.tableRowFactoryProperty());
        VBox.setVgrow(this.rowsFlow, (Priority)Priority.ALWAYS);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-table-view");
        this.transformableList.setAll((Collection<T>)this.getItems());
        this.itemsProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeListener(this.itemsChanged);
                oldValue.removeListener(this.itemsInvalid);
            }
            if (newValue != null) {
                newValue.addListener(this.itemsChanged);
                newValue.addListener(this.itemsInvalid);
                this.transformableList.setAll((Collection<T>)newValue);
            }
        });
        this.getItems().addListener(this.itemsChanged);
        this.getItems().addListener(this.itemsInvalid);
        this.sceneBuilderIntegration();
    }

    protected void itemsChanged(ListChangeListener.Change<? extends T> change) {
        IMultipleSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel.getSelection().isEmpty()) {
            return;
        }
        if (change.getList().isEmpty()) {
            selectionModel.clearSelection();
            return;
        }
        ListChangeHelper.Change c = ListChangeHelper.processChange(change, IntegerRange.of((Integer)0, (Integer)Integer.MAX_VALUE));
        ListChangeProcessor updater = new ListChangeProcessor(new HashSet<Integer>(selectionModel.getSelection().keySet()));
        c.processReplacement((changed, removed) -> selectionModel.replaceSelection((Integer[])changed.toArray(Integer[]::new)));
        c.processAddition((TriConsumer<Integer, Integer, Set<Integer>>)((TriConsumer)(from, to, added) -> {
            updater.computeAddition(added.size(), (int)from);
            selectionModel.replaceSelection((Integer[])updater.getIndexes().toArray(Integer[]::new));
        }));
        c.processRemoval((TriConsumer<Integer, Integer, Set<Integer>>)((TriConsumer)(from, to, removed) -> {
            updater.computeRemoval((Set<Integer>)removed, (int)from);
            this.getSelectionModel().replaceSelection((Integer[])updater.getIndexes().toArray(Integer[]::new));
        }));
    }

    public void update() {
        this.rowsFlow.getCells().values().forEach(MFXTableRow::updateRow);
    }

    public void autosizeColumns() {
        this.tableColumns.forEach(this::autosizeColumn);
    }

    public void autosizeColumn(int index) {
        try {
            MFXTableColumn column = (MFXTableColumn)((Object)this.tableColumns.get(index));
            this.autosizeColumn(column);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void autosizeColumn(MFXTableColumn<T> column) {
        int index = this.tableColumns.indexOf(column);
        if (index == -1) {
            return;
        }
        Collection rows = this.rowsFlow.getCells().values();
        ArrayList<Double> minSizes = new ArrayList<Double>();
        minSizes.add(column.getWidth());
        rows.forEach(row -> {
            ObservableList rowCells = row.getCells();
            if (rowCells.isEmpty()) {
                return;
            }
            MFXTableRowCell rowCell = (MFXTableRowCell)((Object)((Object)rowCells.get(index)));
            rowCell.requestLayout();
            minSizes.add(rowCell.computePrefWidth(-1.0));
        });
        double max = minSizes.stream().max(Double::compareTo).orElse(-1.0);
        if (max != -1.0) {
            column.setMinWidth(max);
        }
    }

    public void autosizeColumnsOnInitialization() {
        if (this.isVirtualFlowInitialized()) {
            return;
        }
        When.onChanged(this.virtualFlowInitialized).then((oldValue, newValue) -> this.autosizeColumns()).oneShot().listen();
    }

    public MFXTableRow<T> getCell(int index) {
        return (MFXTableRow)this.rowsFlow.getCell(index);
    }

    public Map<Integer, MFXTableRow<T>> getCells() {
        return this.rowsFlow.getCells();
    }

    public void scrollBy(double pixels) {
        this.rowsFlow.scrollBy(pixels);
    }

    public void scrollTo(int index) {
        this.rowsFlow.scrollTo(index);
    }

    public void scrollToFirst() {
        this.rowsFlow.scrollToFirst();
    }

    public void scrollToLast() {
        this.rowsFlow.scrollToLast();
    }

    public void scrollToPixel(double pixel) {
        this.rowsFlow.scrollToPixel(pixel);
    }

    public void setHSpeed(double unit, double block) {
        this.rowsFlow.setHSpeed(unit, block);
    }

    public void setVSpeed(double unit, double block) {
        this.rowsFlow.setVSpeed(unit, block);
    }

    public SimpleVirtualFlow.Features features() {
        return this.rowsFlow.features();
    }

    @Override
    public Parent toParent() {
        return this;
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.TABLE_VIEW;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXTableViewSkin<T>(this, this.rowsFlow);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (!this.isVirtualFlowInitialized() && this.rowsFlow.getCellHeight() > 0.0) {
            this.virtualFlowInitialized.set(true);
        }
    }

    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    public IMultipleSelectionModel<T> getSelectionModel() {
        return this.selectionModel;
    }

    public ObservableList<MFXTableColumn<T>> getTableColumns() {
        return this.tableColumns;
    }

    public Function<T, MFXTableRow<T>> getTableRowFactory() {
        return (Function)this.tableRowFactory.get();
    }

    public FunctionProperty<T, MFXTableRow<T>> tableRowFactoryProperty() {
        return this.tableRowFactory;
    }

    public void setTableRowFactory(Function<T, MFXTableRow<T>> tableRowFactory) {
        this.tableRowFactory.set(tableRowFactory);
    }

    public TransformableListWrapper<T> getTransformableList() {
        return this.transformableList;
    }

    public ObservableList<AbstractFilter<T, ?>> getFilters() {
        return this.filters;
    }

    public boolean isFooterVisible() {
        return this.footerVisible.get();
    }

    public BooleanProperty footerVisibleProperty() {
        return this.footerVisible;
    }

    public void setFooterVisible(boolean footerVisible) {
        this.footerVisible.set(footerVisible);
    }

    public boolean isVirtualFlowInitialized() {
        return this.virtualFlowInitialized.get();
    }

    public ReadOnlyBooleanProperty virtualFlowInitializedProperty() {
        return this.virtualFlowInitialized.getReadOnlyProperty();
    }
}

