/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.base;

import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.SceneBuilderIntegration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Locale;
import javafx.scene.Parent;

public interface Themable {
    public Parent toParent();

    public Theme getTheme();

    default public boolean sceneBuilderIntegration() {
        if (!SceneBuilderIntegration.isInSceneBuilder() || Helper.isInhibitSBSupport()) {
            return false;
        }
        Helper.themeIt(this);
        return true;
    }

    public static class Helper {
        public static final Path SB_WIN_PATH = Path.of(System.getenv("APPDATA") + "/Scene Builder", new String[0]);
        public static final Path SB_MAC_PATH = Path.of(System.getProperty("user.home") + "/Library/Application Support/Scene Builder", new String[0]);
        public static final Path SB_LIN_PATH = Path.of(System.getProperty("user.home") + "/.scenebuilder", new String[0]);
        private static OSType os = null;
        private static Boolean inhibitSBSupport = null;

        protected static void themeIt(Themable t) {
            String theme;
            Parent parent = t.toParent();
            HashSet stylesheets = new HashSet(parent.getStylesheets());
            if (stylesheets.contains(theme = t.getTheme().toData())) {
                return;
            }
            parent.getStylesheets().add((Object)theme);
        }

        protected static OSType detectOS() {
            if (os == null) {
                String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
                os = OS.contains("mac") || OS.contains("darwin") ? OSType.MacOS : (OS.contains("win") ? OSType.Windows : (OS.contains("nux") ? OSType.Linux : OSType.Other));
            }
            return os;
        }

        protected static boolean isInhibitSBSupport() {
            if (inhibitSBSupport == null) {
                switch (Helper.detectOS().ordinal()) {
                    case 0: {
                        inhibitSBSupport = Files.exists(SB_WIN_PATH.resolve("MFX_SB_OFF"), new LinkOption[0]);
                        break;
                    }
                    case 1: {
                        inhibitSBSupport = Files.exists(SB_MAC_PATH.resolve("MFX_SB_OFF"), new LinkOption[0]);
                        break;
                    }
                    case 2: {
                        inhibitSBSupport = Files.exists(SB_LIN_PATH.resolve("MFX_SB_OFF"), new LinkOption[0]);
                        break;
                    }
                    default: {
                        inhibitSBSupport = false;
                    }
                }
            }
            return inhibitSBSupport;
        }

        public static enum OSType {
            Windows,
            MacOS,
            Linux,
            Other;

        }
    }
}

