/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.beans.PositionBean;
import io.github.palexdev.materialfx.controls.MFXCheckListView;
import io.github.palexdev.materialfx.controls.MFXCheckbox;
import io.github.palexdev.materialfx.controls.cell.base.AbstractMFXListCell;
import io.github.palexdev.materialfx.effects.ripple.MFXCircleRippleGenerator;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.NodeUtils;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;

public class MFXCheckListCell<T>
extends AbstractMFXListCell<T> {
    private final String STYLE_CLASS = "mfx-check-list-cell";
    protected final MFXCircleRippleGenerator rippleGenerator = new MFXCircleRippleGenerator((Region)this);
    private final MFXCheckListView<T> listView;
    protected final MFXCheckbox checkbox;
    protected final Label label;

    public MFXCheckListCell(MFXCheckListView<T> listView, T data) {
        super(listView, data);
        this.listView = listView;
        this.checkbox = new MFXCheckbox("");
        if (!(data instanceof Node)) {
            this.label = new Label();
            this.label.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> listView.getConverter() != null ? listView.getConverter().toString(this.getData()) : this.getData().toString(), (Observable[])new Observable[]{this.dataProperty(), listView.converterProperty()}));
            this.label.getStyleClass().add((Object)"data-label");
        } else {
            this.label = null;
        }
        this.initialize();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.getStyleClass().add((Object)"mfx-check-list-cell");
        this.setupRippleGenerator();
        this.render(this.getData());
        this.sceneBuilderIntegration();
    }

    protected void setupRippleGenerator() {
        this.rippleGenerator.setManaged(false);
        this.rippleGenerator.setRipplePositionFunction(event -> PositionBean.of(event.getX(), event.getY()));
        this.rippleGenerator.rippleRadiusProperty().bind((ObservableValue)this.widthProperty().divide(2.0));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (NodeUtils.inHierarchy(event, (Node)this.checkbox)) {
                this.rippleGenerator.generateRipple((MouseEvent)event);
            }
        });
    }

    private void updateSelection(boolean checked) {
        int index = this.getIndex();
        if (checked) {
            this.listView.getSelectionModel().selectIndex(index);
        } else {
            this.listView.getSelectionModel().deselectIndex(index);
        }
    }

    @Override
    protected void setBehavior() {
        this.selected.addListener(invalidated -> this.pseudoClassStateChanged(this.SELECTED_PSEUDO_CLASS, this.selected.get()));
        this.selected.bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            boolean contained = this.listView.getSelectionModel().getSelection().containsKey((Object)this.index.get());
            this.checkbox.setSelected(contained);
            return contained;
        }, (Observable[])new Observable[]{this.listView.getSelectionModel().selectionProperty(), this.index}));
        this.checkbox.selectedProperty().addListener((observable, oldValue, newValue) -> this.updateSelection((boolean)newValue));
    }

    @Override
    protected void render(T data) {
        if (data instanceof Node) {
            this.getChildren().setAll((Object[])new Node[]{this.rippleGenerator, this.checkbox, (Node)data});
        } else {
            this.getChildren().setAll((Object[])new Node[]{this.rippleGenerator, this.checkbox, this.label});
        }
    }

    @Override
    public void updateItem(T item) {
        super.updateItem(item);
        if (item instanceof Node) {
            this.render(item);
        }
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.CHECK_LIST_CELL;
    }
}

