/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell;

import io.github.palexdev.materialfx.beans.Alignment;
import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.controls.MFXListView;
import io.github.palexdev.materialfx.controls.MFXPagination;
import io.github.palexdev.materialfx.controls.MFXPopup;
import io.github.palexdev.materialfx.controls.cell.MFXListCell;
import io.github.palexdev.virtualizedfx.cell.Cell;
import java.util.function.Function;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class MFXPage
extends Label
implements Cell<Integer> {
    private final String STYLE_CLASS = "mfx-page";
    private final MFXPagination pagination;
    private final ReadOnlyIntegerWrapper index = new ReadOnlyIntegerWrapper();
    private NumberRange<Integer> between;
    private final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper();
    protected static final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");

    public MFXPage(MFXPagination pagination, int index) {
        this.pagination = pagination;
        this.updateItem(index);
        this.initialize();
        this.addListeners();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-page");
        this.setAlignment(Pos.CENTER);
    }

    private void addListeners() {
        this.selected.addListener(invalidated -> this.pseudoClassStateChanged(SELECTED_PSEUDO_CLASS, this.selected.get()));
        this.selected.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.pagination.getCurrentPage() == this.getIndex(), (Observable[])new Observable[]{this.indexProperty(), this.pagination.currentPageProperty()}));
        this.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.getIndex() == -1 ? this.pagination.getEllipseString() : String.valueOf(this.getIndex()), (Observable[])new Observable[]{this.indexProperty()}));
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            if (this.getIndex() != -1) {
                this.pagination.setCurrentPage(this.getIndex());
            } else {
                this.showPopup();
            }
        });
    }

    protected void showPopup() {
        if (!this.pagination.isShowPopupForTruncatedPages() || this.between == null) {
            return;
        }
        ObservableList indexes = FXCollections.observableArrayList(NumberRange.expandRange(this.between));
        MFXListView<Integer> listView = new MFXListView<Integer>(indexes);
        MFXPopup popup = new MFXPopup((Node)listView);
        popup.getStyleClass().add((Object)"pages-popup");
        popup.setPopupStyleableParent((Parent)this.pagination);
        listView.setCellFactory((Function<Integer, MFXListCell<Integer>>)((Function<Integer, MFXListCell>)integer -> {
            MFXListCell<Integer> cell = new MFXListCell<Integer>(listView, (Integer)integer);
            cell.setOnMouseClicked(event -> {
                this.pagination.setCurrentPage((Integer)cell.getData());
                popup.hide();
            });
            return cell;
        }));
        popup.show((Node)this, Alignment.of(HPos.CENTER, VPos.BOTTOM), 0.0, 5.0);
    }

    public Node getNode() {
        return this;
    }

    public void updateItem(Integer index) {
        this.setIndex(index);
    }

    public int getIndex() {
        return this.index.get();
    }

    public ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    protected void setIndex(int index) {
        this.index.set(index);
    }

    public NumberRange<Integer> getBetween() {
        return this.between;
    }

    public void setBetween(NumberRange<Integer> between) {
        this.between = between;
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    protected void setSelected(boolean selected) {
        this.selected.set(selected);
    }
}

