/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.cell.base;

import io.github.palexdev.materialfx.controls.base.AbstractMFXListView;
import io.github.palexdev.materialfx.controls.base.Themable;
import io.github.palexdev.virtualizedfx.cell.Cell;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;

public abstract class AbstractMFXListCell<T>
extends HBox
implements Cell<T>,
Themable {
    protected final AbstractMFXListView<T, ?> listView;
    protected final ReadOnlyObjectWrapper<T> data = new ReadOnlyObjectWrapper();
    protected final ReadOnlyIntegerWrapper index = new ReadOnlyIntegerWrapper();
    protected final ReadOnlyBooleanWrapper selected = new ReadOnlyBooleanWrapper();
    protected final PseudoClass SELECTED_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"selected");

    public AbstractMFXListCell(AbstractMFXListView<T, ?> listView, T data) {
        this.listView = listView;
        this.setData(data);
        this.setPrefHeight(32.0);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setSpacing(5.0);
    }

    protected abstract void render(T var1);

    protected void initialize() {
        this.setBehavior();
    }

    protected void setBehavior() {
        this.selected.addListener(invalidated -> this.pseudoClassStateChanged(this.SELECTED_PSEUDO_CLASS, this.selected.get()));
        this.selected.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.listView.getSelectionModel().getSelection().containsKey((Object)this.index.get()), (Observable[])new Observable[]{this.listView.getSelectionModel().selectionProperty(), this.index}));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, this::updateSelection);
    }

    protected void updateSelection(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        int index = this.getIndex();
        if (event.isControlDown()) {
            if (this.isSelected()) {
                this.listView.getSelectionModel().deselectIndex(index);
            } else {
                this.listView.getSelectionModel().selectIndex(index);
            }
            return;
        }
        if (event.isShiftDown()) {
            this.listView.getSelectionModel().expandSelection(index);
            return;
        }
        this.listView.getSelectionModel().replaceSelection(index);
    }

    @Override
    public Parent toParent() {
        return this;
    }

    public Node getNode() {
        return this;
    }

    public void updateIndex(int index) {
        this.setIndex(index);
    }

    public void updateItem(T item) {
        this.setData(item);
    }

    public T getData() {
        return (T)this.data.get();
    }

    public ReadOnlyObjectProperty<T> dataProperty() {
        return this.data.getReadOnlyProperty();
    }

    protected void setData(T data) {
        this.data.set(data);
    }

    public int getIndex() {
        return this.index.get();
    }

    public ReadOnlyIntegerProperty indexProperty() {
        return this.index.getReadOnlyProperty();
    }

    protected void setIndex(int index) {
        this.index.set(index);
    }

    public boolean isSelected() {
        return this.selected.get();
    }

    public ReadOnlyBooleanProperty selectedProperty() {
        return this.selected.getReadOnlyProperty();
    }

    protected void setSelected(boolean selected) {
        this.selected.set(selected);
    }
}

