/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.controls.legacy;

import io.github.palexdev.materialfx.controls.legacy.MFXLegacyListCell;
import io.github.palexdev.materialfx.effects.DepthLevel;
import io.github.palexdev.materialfx.skins.legacy.MFXLegacyListViewSkin;
import io.github.palexdev.materialfx.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class MFXLegacyListView<T>
extends ListView<T> {
    private static final StyleablePropertyFactory<MFXLegacyListView<?>> FACTORY = new StyleablePropertyFactory(ListView.getClassCssMetaData());
    private final String STYLE_CLASS = "mfx-legacy-list-view";
    private final ObjectProperty<Paint> trackColor = new SimpleObjectProperty((Object)Color.rgb((int)132, (int)132, (int)132));
    private final ObjectProperty<Paint> thumbColor = new SimpleObjectProperty((Object)Color.rgb((int)137, (int)137, (int)137));
    private final ObjectProperty<Paint> thumbHoverColor = new SimpleObjectProperty((Object)Color.rgb((int)89, (int)88, (int)91));
    private final ObjectProperty<Duration> hideAfter = new SimpleObjectProperty((Object)Duration.seconds((double)1.0));
    private final StyleableBooleanProperty hideScrollBars = new SimpleStyleableBooleanProperty(StyleableProperties.HIDE_SCROLLBARS, (Object)this, "hideScrollBars", false);
    private final StyleableObjectProperty<DepthLevel> depthLevel = new SimpleStyleableObjectProperty(StyleableProperties.DEPTH_LEVEL, (Object)this, "depthLevel", (Object)DepthLevel.LEVEL2);

    public MFXLegacyListView() {
        this.initialize();
    }

    public MFXLegacyListView(ObservableList<T> observableList) {
        super(observableList);
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-legacy-list-view");
        this.setCellFactory(cell -> new MFXLegacyListCell());
        this.addListeners();
    }

    private void addListeners() {
        this.trackColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
        this.thumbColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
        this.thumbHoverColor.addListener((observable, oldValue, newValue) -> {
            if (!newValue.equals(oldValue)) {
                this.setColors();
            }
        });
    }

    private void setColors() {
        StringBuilder sb = new StringBuilder();
        sb.append("-mfx-track-color: ").append(ColorUtils.toCss((Paint)this.trackColor.get())).append(";\n-mfx-thumb-color: ").append(ColorUtils.toCss((Paint)this.thumbColor.get())).append(";\n-mfx-thumb-hover-color: ").append(ColorUtils.toCss((Paint)this.thumbHoverColor.get())).append(";");
        this.setStyle(sb.toString());
    }

    public Paint getTrackColor() {
        return (Paint)this.trackColor.get();
    }

    public ObjectProperty<Paint> trackColorProperty() {
        return this.trackColor;
    }

    public void setTrackColor(Paint trackColor) {
        this.trackColor.set((Object)trackColor);
    }

    public Paint getThumbColor() {
        return (Paint)this.thumbColor.get();
    }

    public ObjectProperty<Paint> thumbColorProperty() {
        return this.thumbColor;
    }

    public void setThumbColor(Paint thumbColor) {
        this.thumbColor.set((Object)thumbColor);
    }

    public Paint getThumbHoverColor() {
        return (Paint)this.thumbHoverColor.get();
    }

    public ObjectProperty<Paint> thumbHoverColorProperty() {
        return this.thumbHoverColor;
    }

    public void setThumbHoverColor(Paint thumbHoverColor) {
        this.thumbHoverColor.set((Object)thumbHoverColor);
    }

    public Duration getHideAfter() {
        return (Duration)this.hideAfter.get();
    }

    public ObjectProperty<Duration> hideAfterProperty() {
        return this.hideAfter;
    }

    public void setHideAfter(Duration hideAfter) {
        this.hideAfter.set((Object)hideAfter);
    }

    public boolean isHideScrollBars() {
        return this.hideScrollBars.get();
    }

    public StyleableBooleanProperty hideScrollBarsProperty() {
        return this.hideScrollBars;
    }

    public void setHideScrollBars(boolean hideScrollBars) {
        this.hideScrollBars.set(hideScrollBars);
    }

    public DepthLevel getDepthLevel() {
        return (DepthLevel)((Object)this.depthLevel.get());
    }

    public StyleableObjectProperty<DepthLevel> depthLevelProperty() {
        return this.depthLevel;
    }

    public void setDepthLevel(DepthLevel depthLevel) {
        this.depthLevel.set((Object)depthLevel);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getControlCssMetaDataList() {
        return StyleableProperties.cssMetaDataList;
    }

    protected Skin<?> createDefaultSkin() {
        return new MFXLegacyListViewSkin(this);
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return MFXLegacyListView.getControlCssMetaDataList();
    }

    private static class StyleableProperties {
        private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;
        private static final CssMetaData<MFXLegacyListView<?>, Boolean> HIDE_SCROLLBARS;
        private static final CssMetaData<MFXLegacyListView<?>, DepthLevel> DEPTH_LEVEL;

        private StyleableProperties() {
        }

        static {
            HIDE_SCROLLBARS = FACTORY.createBooleanCssMetaData("-mfx-hide-scrollbars", MFXLegacyListView::hideScrollBarsProperty, false);
            DEPTH_LEVEL = FACTORY.createEnumCssMetaData(DepthLevel.class, "-mfx-depth-level", MFXLegacyListView::depthLevelProperty, (Enum)DepthLevel.LEVEL2);
            ArrayList lsvCssMetaData = new ArrayList(ListView.getClassCssMetaData());
            Collections.addAll(lsvCssMetaData, HIDE_SCROLLBARS, DEPTH_LEVEL);
            cssMetaDataList = Collections.unmodifiableList(lsvCssMetaData);
        }
    }
}

