/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.dialogs;

import io.github.palexdev.materialfx.beans.FilterBean;
import io.github.palexdev.materialfx.controls.MFXFilterPane;
import io.github.palexdev.materialfx.dialogs.MFXGenericDialog;
import io.github.palexdev.materialfx.filter.base.AbstractFilter;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import java.util.function.Predicate;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;

public class MFXFilterDialog<T>
extends MFXGenericDialog {
    private final String STYLE_CLASS = "mfx-filter-dialog";
    private final MFXFilterPane<T> filterPane;

    public MFXFilterDialog(MFXFilterPane<T> filterPane) {
        this.filterPane = filterPane;
        this.initialize();
    }

    private void initialize() {
        this.getStyleClass().add((Object)"mfx-filter-dialog");
        this.setHeaderText("");
        this.setHeaderIcon(null);
        this.buildContent();
    }

    @Override
    protected void buildContent() {
        this.setContent((Node)this.filterPane);
    }

    @Override
    protected void buildScrollableContent(boolean smoothScrolling) {
        this.buildContent();
    }

    protected double computeMinWidth(double height) {
        return this.snappedLeftInset() + this.filterPane.prefWidth(-1.0) + this.snappedRightInset();
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.FILTER_DIALOG;
    }

    public Predicate<T> filter() {
        return this.filterPane.filter();
    }

    public ObservableList<AbstractFilter<T, ?>> getFilters() {
        return this.filterPane.getFilters();
    }

    public ObservableList<FilterBean<T, ?>> getActiveFilters() {
        return this.filterPane.getActiveFilters();
    }

    public void setOnFilter(EventHandler<MouseEvent> onFilter) {
        this.filterPane.setOnFilter(onFilter);
    }

    public void setOnReset(EventHandler<MouseEvent> onReset) {
        this.filterPane.setOnReset(onReset);
    }

    public MFXFilterPane<T> getFilterPane() {
        return this.filterPane;
    }
}

