/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.dialogs;

import io.github.palexdev.materialfx.beans.properties.EventHandlerProperty;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXScrollPane;
import io.github.palexdev.materialfx.dialogs.AbstractMFXDialog;
import io.github.palexdev.materialfx.theming.MaterialFXStylesheets;
import io.github.palexdev.materialfx.theming.base.Theme;
import io.github.palexdev.materialfx.utils.NodeUtils;
import io.github.palexdev.materialfx.utils.ScrollUtils;
import java.util.Collection;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;

public class MFXGenericDialog
extends AbstractMFXDialog {
    protected HBox header;
    protected Label headerLabel;
    protected MFXIconWrapper alwaysOnTopIcon;
    protected MFXIconWrapper minimizeIcon;
    protected MFXIconWrapper closeIcon;
    protected Pane actions;
    private final ObjectProperty<Node> headerIcon = new SimpleObjectProperty();
    private final StringProperty headerText = new SimpleStringProperty();
    private final ObjectProperty<Node> content = new SimpleObjectProperty();
    private final StringProperty contentText = new SimpleStringProperty();
    private final BooleanProperty showClose = new SimpleBooleanProperty(true);
    private final BooleanProperty showMinimize = new SimpleBooleanProperty(true);
    private final BooleanProperty showAlwaysOnTop = new SimpleBooleanProperty(true);
    private final ObjectProperty<Orientation> actionsOrientation = new SimpleObjectProperty((Object)Orientation.HORIZONTAL);
    private final EventHandlerProperty<MouseEvent> onClose = new EventHandlerProperty();
    private final EventHandlerProperty<MouseEvent> onMinimize = new EventHandlerProperty();
    private final EventHandlerProperty<MouseEvent> onAlwaysOnTop = new EventHandlerProperty();
    private final BooleanProperty alwaysOnTop = new SimpleBooleanProperty();
    protected static final PseudoClass ALWAYS_ON_TOP_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"always-on-top");

    public MFXGenericDialog() {
        this("", "");
    }

    public MFXGenericDialog(String headerText, String contentText) {
        this.setHeaderText(headerText);
        this.setContentText(contentText);
        this.buildHeader();
        this.buildContent();
        this.buildActionsPane();
        this.setTop((Node)this.header);
        this.setCenter(this.getContent());
        this.setBottom((Node)this.actions);
        this.initialize();
    }

    private void initialize() {
        this.pseudoClassStateChanged(ALWAYS_ON_TOP_PSEUDO_CLASS, this.isAlwaysOnTop());
        this.alwaysOnTopProperty().addListener(invalidated -> this.pseudoClassStateChanged(ALWAYS_ON_TOP_PSEUDO_CLASS, this.isAlwaysOnTop()));
        this.contentProperty().addListener(invalidated -> this.setCenter(this.getContent()));
        this.showAlwaysOnTopProperty().addListener(invalidated -> this.initHeader());
        this.showMinimizeProperty().addListener(invalidated -> this.initHeader());
        this.showCloseProperty().addListener(invalidated -> this.initHeader());
        this.onAlwaysOnTopProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.alwaysOnTopIcon.removeEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)oldValue);
            }
            if (newValue != null) {
                this.alwaysOnTopIcon.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)newValue);
            }
        });
        this.onMinimizeProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.minimizeIcon.removeEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)oldValue);
            }
            if (newValue != null) {
                this.minimizeIcon.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)newValue);
            }
        });
        this.onCloseProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.closeIcon.removeEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)oldValue);
            }
            if (newValue != null) {
                this.closeIcon.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)newValue);
            }
        });
        this.actionsOrientationProperty().addListener(invalidated -> this.buildActionsPane());
    }

    protected void buildHeader() {
        this.headerLabel = new Label();
        this.headerLabel.graphicProperty().bind(this.headerIcon);
        this.headerLabel.getStyleClass().add((Object)"header-label");
        this.headerLabel.textProperty().bind((ObservableValue)this.headerTextProperty());
        this.headerLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        HBox.setHgrow((Node)this.headerLabel, (Priority)Priority.ALWAYS);
        this.alwaysOnTopIcon = new MFXIconWrapper("fas-caret-up", 12.0, 24.0);
        this.minimizeIcon = new MFXIconWrapper("fas-minus", 12.0, 24.0);
        this.closeIcon = new MFXIconWrapper("fas-xmark", 12.0, 24.0);
        this.alwaysOnTopIcon.setId("alwaysOnTop");
        this.minimizeIcon.setId("minimize");
        this.closeIcon.setId("close");
        this.alwaysOnTopIcon.visibleProperty().bind((ObservableValue)this.showAlwaysOnTopProperty());
        this.minimizeIcon.visibleProperty().bind((ObservableValue)this.showMinimizeProperty());
        this.closeIcon.visibleProperty().bind((ObservableValue)this.showCloseProperty());
        NodeUtils.makeRegionCircular((Region)this.alwaysOnTopIcon);
        NodeUtils.makeRegionCircular((Region)this.minimizeIcon);
        NodeUtils.makeRegionCircular((Region)this.closeIcon);
        this.header = new HBox(10.0, new Node[]{this.headerLabel});
        this.header.setAlignment(Pos.CENTER_LEFT);
        this.initHeader();
    }

    private void initHeader() {
        this.header.getChildren().removeAll((Object[])new Node[]{this.alwaysOnTopIcon, this.minimizeIcon, this.closeIcon});
        if (this.isShowAlwaysOnTop()) {
            this.header.getChildren().add((Object)this.alwaysOnTopIcon);
        }
        if (this.isShowMinimize()) {
            this.header.getChildren().add((Object)this.minimizeIcon);
        }
        if (this.isShowClose()) {
            this.header.getChildren().add((Object)this.closeIcon);
        }
    }

    protected void buildContent() {
        Label content = new Label();
        content.setWrapText(true);
        content.getStyleClass().add((Object)"content");
        content.textProperty().bind((ObservableValue)this.contentTextProperty());
        StackPane contentContainer = new StackPane(new Node[]{content});
        contentContainer.getStyleClass().add((Object)"content-container");
        contentContainer.setAlignment(Pos.TOP_LEFT);
        this.setContent((Node)contentContainer);
    }

    protected void buildScrollableContent(boolean smoothScrolling) {
        Label content = new Label();
        content.setWrapText(true);
        content.getStyleClass().add((Object)"content");
        content.textProperty().bind((ObservableValue)this.contentTextProperty());
        this.buildScrollableContent((Node)content, smoothScrolling);
    }

    protected void buildScrollableContent(Node content, boolean smoothScrolling) {
        MFXScrollPane scrollPane = new MFXScrollPane(content);
        scrollPane.getStyleClass().add((Object)"content-container");
        scrollPane.setFitToWidth(true);
        if (smoothScrolling) {
            ScrollUtils.addSmoothScrolling(scrollPane, 0.5);
        }
        this.setContent((Node)scrollPane);
    }

    protected void buildActionsPane() {
        ObservableList children = FXCollections.observableArrayList();
        if (this.actions != null) {
            this.getChildren().remove((Object)this.actions);
            children.addAll((Collection)this.actions.getChildren());
        }
        if (this.getActionsOrientation() == Orientation.HORIZONTAL) {
            HBox actions = new HBox(10.0);
            actions.setAlignment(Pos.CENTER_RIGHT);
            this.actions = actions;
        } else {
            VBox actions = new VBox(10.0);
            actions.setAlignment(Pos.TOP_RIGHT);
            this.actions = actions;
        }
        this.actions.getChildren().setAll((Collection)children);
        this.actions.getStyleClass().add((Object)"actions-pane");
    }

    public void addActions(Node ... actions) {
        this.actions.getChildren().addAll((Object[])actions);
    }

    @SafeVarargs
    public final void addActions(Map.Entry<Node, EventHandler<MouseEvent>> ... actions) {
        for (Map.Entry<Node, EventHandler<MouseEvent>> action : actions) {
            action.getKey().addEventHandler(MouseEvent.MOUSE_CLICKED, action.getValue());
            this.actions.getChildren().add((Object)action.getKey());
        }
    }

    public void clearActions() {
        this.actions.getChildren().clear();
    }

    @Override
    public Theme getTheme() {
        return MaterialFXStylesheets.DIALOGS;
    }

    public Node getHeaderIcon() {
        return (Node)this.headerIcon.get();
    }

    public ObjectProperty<Node> headerIconProperty() {
        return this.headerIcon;
    }

    public void setHeaderIcon(Node headerIcon) {
        this.headerIcon.set((Object)headerIcon);
    }

    public String getHeaderText() {
        return (String)this.headerText.get();
    }

    public StringProperty headerTextProperty() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText.set((Object)headerText);
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content.set((Object)content);
    }

    public String getContentText() {
        return (String)this.contentText.get();
    }

    public StringProperty contentTextProperty() {
        return this.contentText;
    }

    public void setContentText(String contentText) {
        this.contentText.set((Object)contentText);
    }

    public boolean isShowClose() {
        return this.showClose.get();
    }

    public BooleanProperty showCloseProperty() {
        return this.showClose;
    }

    public void setShowClose(boolean showClose) {
        this.showClose.set(showClose);
    }

    public boolean isShowMinimize() {
        return this.showMinimize.get();
    }

    public BooleanProperty showMinimizeProperty() {
        return this.showMinimize;
    }

    public void setShowMinimize(boolean showMinimize) {
        this.showMinimize.set(showMinimize);
    }

    public boolean isShowAlwaysOnTop() {
        return this.showAlwaysOnTop.get();
    }

    public BooleanProperty showAlwaysOnTopProperty() {
        return this.showAlwaysOnTop;
    }

    public void setShowAlwaysOnTop(boolean showAlwaysOnTop) {
        this.showAlwaysOnTop.set(showAlwaysOnTop);
    }

    public Orientation getActionsOrientation() {
        return (Orientation)this.actionsOrientation.get();
    }

    public ObjectProperty<Orientation> actionsOrientationProperty() {
        return this.actionsOrientation;
    }

    public void setActionsOrientation(Orientation actionsOrientation) {
        this.actionsOrientation.set((Object)actionsOrientation);
    }

    public EventHandler<MouseEvent> getOnClose() {
        return (EventHandler)this.onClose.get();
    }

    public EventHandlerProperty<MouseEvent> onCloseProperty() {
        return this.onClose;
    }

    public void setOnClose(EventHandler<MouseEvent> onClose) {
        this.onClose.set(onClose);
    }

    public EventHandler<MouseEvent> getOnMinimize() {
        return (EventHandler)this.onMinimize.get();
    }

    public EventHandlerProperty<MouseEvent> onMinimizeProperty() {
        return this.onMinimize;
    }

    public void setOnMinimize(EventHandler<MouseEvent> onMinimize) {
        this.onMinimize.set(onMinimize);
    }

    public EventHandler<MouseEvent> getOnAlwaysOnTop() {
        return (EventHandler)this.onAlwaysOnTop.get();
    }

    public EventHandlerProperty<MouseEvent> onAlwaysOnTopProperty() {
        return this.onAlwaysOnTop;
    }

    public void setOnAlwaysOnTop(EventHandler<MouseEvent> onAlwaysOnTop) {
        this.onAlwaysOnTop.set(onAlwaysOnTop);
    }

    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop.get();
    }

    public BooleanProperty alwaysOnTopProperty() {
        return this.alwaysOnTop;
    }

    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop.set(alwaysOnTop);
    }
}

