/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.dialogs;

import io.github.palexdev.materialfx.dialogs.AbstractMFXDialog;
import io.github.palexdev.materialfx.effects.MFXScrimEffect;
import io.github.palexdev.materialfx.enums.ScrimPriority;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import java.io.IOException;
import java.net.URL;
import javafx.animation.Interpolator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class MFXStageDialog
extends Stage {
    private final ObjectProperty<AbstractMFXDialog> content = new SimpleObjectProperty();
    private boolean draggable = false;
    private double xPos;
    private double yPos;
    private EventHandler<MouseEvent> mousePressed = event -> {
        this.xPos = this.getX() - event.getScreenX();
        this.yPos = this.getY() - event.getScreenY();
    };
    private EventHandler<MouseEvent> mouseDragged = event -> {
        this.setX(event.getScreenX() + this.xPos);
        this.setY(event.getScreenY() + this.yPos);
    };
    private boolean overlayClose = false;
    private EventHandler<MouseEvent> overlayCloseHandler = event -> this.close();
    private Pane ownerNode;
    private final BooleanProperty centerInOwnerNode = new SimpleBooleanProperty(){

        protected void invalidated() {
            boolean state = this.get();
            if (state) {
                MFXStageDialog.this.widthProperty().addListener(MFXStageDialog.this.widthChangeListener);
                MFXStageDialog.this.heightProperty().addListener(MFXStageDialog.this.heightChangeListener);
            } else {
                MFXStageDialog.this.widthProperty().removeListener(MFXStageDialog.this.widthChangeListener);
                MFXStageDialog.this.heightProperty().removeListener(MFXStageDialog.this.heightChangeListener);
            }
        }
    };
    private final BooleanProperty scrimOwner = new SimpleBooleanProperty(false);
    private final DoubleProperty scrimStrength = new SimpleDoubleProperty(0.5);
    private MFXScrimEffect scrimEffect = new MFXScrimEffect();
    private ScrimPriority scrimPriority = ScrimPriority.NODE;
    private final ChangeListener<Number> widthChangeListener = (o, ov, nv) -> {
        if (this.centerInOwnerNode.getValue().booleanValue()) {
            this.centerXInOwner(nv.doubleValue());
        }
    };
    private final ChangeListener<Number> heightChangeListener = (o, ov, nv) -> {
        if (this.centerInOwnerNode.getValue().booleanValue()) {
            this.centerYInOwner(nv.doubleValue());
        }
    };

    public MFXStageDialog() {
        this(null);
    }

    public MFXStageDialog(AbstractMFXDialog content) {
        this.setContent(content);
        this.initialize();
    }

    private void initialize() {
        this.initStyle(StageStyle.TRANSPARENT);
        this.scrimEffect.getScrimNode().setOpacity(0.0);
        if (this.getContent() != null) {
            this.setScene(this.buildScene(this.getContent()));
            this.initDraggable();
        }
        if (this.getOwnerNode() != null) {
            this.initOverlayClose();
        }
        this.contentProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressed);
                oldValue.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseDragged);
                oldValue.widthProperty().removeListener(this.widthChangeListener);
                oldValue.heightProperty().removeListener(this.heightChangeListener);
            }
            this.setScene(this.buildScene(this.getContent()));
            this.initDraggable();
        });
        this.addEventHandler(WindowEvent.WINDOW_SHOWING, event -> {
            if (this.getWidth() == 0.0) {
                return;
            }
            if (this.centerInOwnerNode.getValue().booleanValue()) {
                this.centerXInOwner(this.getWidth());
                this.centerYInOwner(this.getHeight());
            }
        });
        this.setCenterInOwnerNode(true);
    }

    protected Scene buildScene(AbstractMFXDialog content) {
        Scene scene = new Scene((Parent)content);
        scene.setFill((Paint)Color.TRANSPARENT);
        return scene;
    }

    protected void initDraggable() {
        if (this.getContent() == null) {
            return;
        }
        AbstractMFXDialog content = this.getContent();
        if (this.isDraggable()) {
            content.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressed);
            content.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseDragged);
        } else {
            content.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressed);
            content.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseDragged);
        }
    }

    protected void initOverlayClose() {
        if (this.getOwnerNode() == null) {
            return;
        }
        if (this.isOverlayClose()) {
            this.ownerNode.addEventFilter(MouseEvent.MOUSE_PRESSED, this.overlayCloseHandler);
        } else {
            this.ownerNode.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.overlayCloseHandler);
        }
    }

    public void showDialog() {
        this.scrimOwner();
        super.show();
    }

    public void showAndWait() {
        this.scrimOwner();
        super.showAndWait();
    }

    public void hide() {
        this.unScrimOwner();
        super.hide();
    }

    protected void scrimOwner() {
        if (!this.isScrimOwner()) {
            return;
        }
        switch (this.scrimPriority) {
            case NODE: {
                if (this.ownerNode == null) break;
                this.scrimEffect.modalScrim(this.ownerNode, this.getScrimStrength());
                break;
            }
            case WINDOW: {
                if (this.getOwner() == null) break;
                this.scrimEffect.scrimWindow(this.getOwner(), this.getScrimStrength());
            }
        }
        AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(200.0, this.scrimEffect.getScrimNode().opacityProperty(), Double.valueOf(this.getScrimStrength()), Interpolator.EASE_BOTH)).getAnimation().play();
    }

    protected void unScrimOwner() {
        if (this.ownerNode != null) {
            this.scrimEffect.removeEffect(this.ownerNode);
        }
        if (this.getOwner() != null) {
            this.scrimEffect.removeEffect(this.getOwner());
        }
        AnimationUtils.TimelineBuilder.build().add(AnimationUtils.KeyFrames.of(200.0, this.scrimEffect.getScrimNode().opacityProperty(), Integer.valueOf(0), Interpolator.EASE_BOTH)).getAnimation().play();
    }

    protected void centerXInOwner(double dialogWidth) {
        Bounds screenBounds = this.ownerNode.localToScreen(this.ownerNode.getBoundsInLocal());
        double startX = screenBounds.getMinX();
        double nodeWidth = this.ownerNode.getWidth();
        double x = startX + (nodeWidth / 2.0 - dialogWidth / 2.0);
        this.setX(x);
    }

    protected void centerYInOwner(double dialogHeight) {
        Bounds screenBounds = this.ownerNode.localToScreen(this.ownerNode.getBoundsInLocal());
        double startY = screenBounds.getMinY();
        double nodeHeight = this.ownerNode.getHeight();
        double y = startY + (nodeHeight / 2.0 - dialogHeight / 2.0);
        this.setY(y);
    }

    public void dispose() {
        AbstractMFXDialog content = this.getContent();
        if (content != null) {
            content.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mousePressed);
            content.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseDragged);
        }
        if (this.ownerNode != null) {
            this.ownerNode.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.overlayCloseHandler);
        }
        this.mousePressed = null;
        this.mouseDragged = null;
        this.overlayCloseHandler = null;
        this.ownerNode = null;
        this.scrimEffect = null;
    }

    public static MFXStageDialog load(Class<?> clazz, String fxmlPath) throws IOException {
        AbstractMFXDialog root = (AbstractMFXDialog)FXMLLoader.load((URL)clazz.getResource(fxmlPath));
        return new MFXStageDialog(root);
    }

    public static MFXStageDialog loadOrNull(Class<?> clazz, String fxmlPath) {
        try {
            return MFXStageDialog.load(clazz, fxmlPath);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public AbstractMFXDialog getContent() {
        return (AbstractMFXDialog)this.content.get();
    }

    public ObjectProperty<AbstractMFXDialog> contentProperty() {
        return this.content;
    }

    public void setContent(AbstractMFXDialog content) {
        this.content.set((Object)content);
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
        this.initDraggable();
    }

    public boolean isOverlayClose() {
        return this.overlayClose;
    }

    public void setOverlayClose(boolean overlayClose) {
        this.overlayClose = overlayClose;
        this.initOverlayClose();
    }

    public Pane getOwnerNode() {
        return this.ownerNode;
    }

    public void setOwnerNode(Pane ownerNode) {
        if (this.ownerNode != null) {
            this.ownerNode.removeEventFilter(MouseEvent.MOUSE_PRESSED, this.overlayCloseHandler);
        }
        this.ownerNode = ownerNode;
        this.initOverlayClose();
    }

    public boolean isCenterInOwnerNode() {
        return this.centerInOwnerNode.get();
    }

    public BooleanProperty centerInOwnerNodeProperty() {
        return this.centerInOwnerNode;
    }

    public void setCenterInOwnerNode(boolean centerInOwnerNode) {
        this.centerInOwnerNode.set(centerInOwnerNode);
    }

    public boolean isScrimOwner() {
        return this.scrimOwner.get();
    }

    public BooleanProperty scrimOwnerProperty() {
        return this.scrimOwner;
    }

    public void setScrimOwner(boolean scrimOwner) {
        this.scrimOwner.set(scrimOwner);
    }

    public double getScrimStrength() {
        return this.scrimStrength.get();
    }

    public DoubleProperty scrimStrengthProperty() {
        return this.scrimStrength;
    }

    public void setScrimStrength(double scrimStrength) {
        this.scrimStrength.set(scrimStrength);
    }

    public ScrimPriority getScrimPriority() {
        return this.scrimPriority;
    }

    public void setScrimPriority(ScrimPriority scrimPriority) {
        this.scrimPriority = scrimPriority;
    }
}

