/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.effects;

import java.util.function.Function;
import javafx.animation.Interpolator;

public enum Interpolators {
    INTERPOLATOR_V1(null){

        @Override
        public Interpolator toInterpolator() {
            return Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
        }
    }
    ,
    INTERPOLATOR_V2(null){

        @Override
        public Interpolator toInterpolator() {
            return Interpolator.SPLINE((double)0.0825, (double)0.3025, (double)0.0875, (double)0.9975);
        }
    }
    ,
    LINEAR(t -> t){

        @Override
        public Interpolator toInterpolator() {
            return new Interpolator(){

                protected double curve(double t) {
                    return this.getCurve().apply(t);
                }
            };
        }
    }
    ,
    EASE_IN(t -> t * t * t){

        @Override
        public Interpolator toInterpolator() {
            return new Interpolator(){

                protected double curve(double t) {
                    return this.getCurve().apply(t);
                }
            };
        }
    }
    ,
    EASE_IN_SINE(t -> 1.0 - Math.cos(t * Math.PI / 2.0)){

        @Override
        public Interpolator toInterpolator() {
            return new Interpolator(){

                protected double curve(double t) {
                    return this.getCurve().apply(t);
                }
            };
        }
    }
    ,
    EASE_OUT(t -> 1.0 - (1.0 - t) * (1.0 - t) * (1.0 - t)){

        @Override
        public Interpolator toInterpolator() {
            return new Interpolator(){

                protected double curve(double t) {
                    return this.getCurve().apply(t);
                }
            };
        }
    }
    ,
    EASE_OUT_SINE(t -> Math.sin(t * Math.PI / 2.0)){

        @Override
        public Interpolator toInterpolator() {
            return new Interpolator(){

                protected double curve(double t) {
                    return this.getCurve().apply(t);
                }
            };
        }
    }
    ,
    EASE_IN_OUT(t -> t < 0.5 ? 4.0 * t * t * t : 1.0 - Math.pow(-2.0 * t + 2.0, 3.0) / 2.0){

        @Override
        public Interpolator toInterpolator() {
            return new Interpolator(){

                protected double curve(double t) {
                    return this.getCurve().apply(t);
                }
            };
        }
    }
    ,
    EASE_IN_OUT_SINE(t -> -(Math.cos(Math.PI * t) - 1.0) / 2.0){

        @Override
        public Interpolator toInterpolator() {
            return new Interpolator(){

                protected double curve(double t) {
                    return this.getCurve().apply(t);
                }
            };
        }
    };

    private final Function<Double, Double> curve;

    private Interpolators(Function<Double, Double> curve) {
        this.curve = curve;
    }

    public abstract Interpolator toInterpolator();

    public Function<Double, Double> getCurve() {
        return this.curve;
    }
}

