/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.factories;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.util.Duration;

public enum MFXAnimationFactory {
    FADE_IN{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.opacityProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.opacityProperty(), (Object)1.0, INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    FADE_OUT{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.opacityProperty(), (Object)1.0, INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.opacityProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    SLIDE_IN_BOTTOM{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.translateYProperty(), (Object)(-node.getBoundsInParent().getHeight() * 2.0), INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.translateYProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    SLIDE_OUT_BOTTOM{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.translateYProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.translateYProperty(), (Object)(node.getBoundsInParent().getHeight() * 2.0), INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    SLIDE_IN_LEFT{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.translateXProperty(), (Object)(-node.getBoundsInParent().getWidth() * 2.0), INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.translateXProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    SLIDE_OUT_LEFT{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.translateXProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.translateXProperty(), (Object)(-node.getBoundsInParent().getWidth() * 2.0), INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    SLIDE_IN_RIGHT{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.translateXProperty(), (Object)(node.getBoundsInParent().getWidth() * 2.0), INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.translateXProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    SLIDE_OUT_RIGHT{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.translateXProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.translateXProperty(), (Object)(node.getBoundsInParent().getWidth() * 2.0), INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    SLIDE_IN_TOP{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.translateYProperty(), (Object)(node.getBoundsInParent().getHeight() * 2.0), INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.translateYProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    }
    ,
    SLIDE_OUT_TOP{

        @Override
        public Timeline build(Node node, double durationMillis) {
            MFXAnimationFactory.resetNode(node);
            KeyValue keyValue1 = new KeyValue((WritableValue)node.translateYProperty(), (Object)0, INTERPOLATOR_V1);
            KeyFrame keyFrame1 = new KeyFrame(Duration.ZERO, new KeyValue[]{keyValue1});
            KeyValue keyValue2 = new KeyValue((WritableValue)node.translateYProperty(), (Object)(-node.getBoundsInParent().getHeight() * 2.0), INTERPOLATOR_V1);
            KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)durationMillis), new KeyValue[]{keyValue2});
            return new Timeline(new KeyFrame[]{keyFrame1, keyFrame2});
        }
    };

    public static final Interpolator INTERPOLATOR_V1;
    public static final Interpolator INTERPOLATOR_V2;

    private static void resetNode(Node node) {
        if (node != null) {
            node.setTranslateX(0.0);
            node.setTranslateY(0.0);
        }
    }

    public abstract Timeline build(Node var1, double var2);

    static {
        INTERPOLATOR_V1 = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
        INTERPOLATOR_V2 = Interpolator.SPLINE((double)0.0825, (double)0.3025, (double)0.0875, (double)0.9975);
    }
}

