/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.filter;

import io.github.palexdev.materialfx.beans.BiPredicateBean;
import io.github.palexdev.materialfx.filter.base.NumberFilter;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.FXCollectors;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.util.StringConverter;

public class BigDecimalFilter<T>
extends NumberFilter<T, BigDecimal> {
    public BigDecimalFilter(String name, Function<T, BigDecimal> extractor) {
        super(name, extractor, new StringConverter<BigDecimal>(){

            public String toString(BigDecimal d) {
                return d.toPlainString();
            }

            public BigDecimal fromString(String s) {
                return new BigDecimal(s);
            }
        });
    }

    @Override
    protected ObservableList<BiPredicateBean<BigDecimal, BigDecimal>> defaultPredicates() {
        return Stream.of(new BiPredicateBean<BigDecimal, BigDecimal>(I18N.getOrDefault("filter.is", new Object[0]), BigDecimal::equals), new BiPredicateBean<BigDecimal, BigDecimal>(I18N.getOrDefault("filter.isNot", new Object[0]), (aFloat, aFloat2) -> !aFloat.equals(aFloat2)), new BiPredicateBean<BigDecimal, BigDecimal>(I18N.getOrDefault("filter.greater", new Object[0]), (aFloat, aFloat2) -> aFloat.compareTo((BigDecimal)aFloat2) > 0), new BiPredicateBean<BigDecimal, BigDecimal>(I18N.getOrDefault("filter.greaterEqual", new Object[0]), (aFloat, aFloat2) -> aFloat.compareTo((BigDecimal)aFloat2) >= 0), new BiPredicateBean<BigDecimal, BigDecimal>(I18N.getOrDefault("filter.lesser", new Object[0]), (aFloat, aFloat2) -> aFloat.compareTo((BigDecimal)aFloat2) < 0), new BiPredicateBean<BigDecimal, BigDecimal>(I18N.getOrDefault("filter.lesserEqual", new Object[0]), (aFloat, aFloat2) -> aFloat.compareTo((BigDecimal)aFloat2) <= 0)).collect(FXCollectors.toList());
    }

    @SafeVarargs
    protected final BigDecimalFilter<T> extend(BiPredicateBean<BigDecimal, BigDecimal> ... predicateBeans) {
        Collections.addAll(this.predicates, predicateBeans);
        return this;
    }
}

