/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.notifications;

import io.github.palexdev.materialfx.beans.CustomBounds;
import io.github.palexdev.materialfx.beans.TransitionPositionBean;
import io.github.palexdev.materialfx.controls.MFXNotificationCenter;
import io.github.palexdev.materialfx.effects.ConsumerTransition;
import io.github.palexdev.materialfx.effects.Interpolators;
import io.github.palexdev.materialfx.notifications.base.AbstractMFXNotificationSystem;
import io.github.palexdev.materialfx.notifications.base.INotification;
import io.github.palexdev.materialfx.notifications.base.INotificationSystem;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.ExecutionUtils;
import io.github.palexdev.materialfx.utils.PositionUtils;
import javafx.animation.Animation;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.stage.Window;

public class MFXNotificationCenterSystem
extends AbstractMFXNotificationSystem {
    private static final MFXNotificationCenterSystem instance = new MFXNotificationCenterSystem();
    private final MFXNotificationCenter center = new MFXNotificationCenter();
    private boolean openOnNew = true;
    private boolean centerInit = false;

    public static MFXNotificationCenterSystem instance() {
        return instance;
    }

    private MFXNotificationCenterSystem() {
        this.popup.setContent((Node)this.center);
    }

    @Override
    public MFXNotificationCenterSystem initOwner(Window owner) {
        this.dispose();
        this.owner = owner;
        this.center.setOpacity(0.0);
        this.init();
        this.popup.show(owner);
        return this;
    }

    @Override
    protected void init() {
        TransitionPositionBean positionBean = this.computePosition();
        this.popup.setX(positionBean.getX());
        this.popup.setY(positionBean.getY());
        if (!this.centerInit) {
            this.center.setOnIconClicked((EventHandler<MouseEvent>)((EventHandler)event -> {
                if (!this.isShowing() && !this.center.getNotifications().isEmpty()) {
                    this.show();
                }
            }));
            this.center.showingProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.close();
                }
            });
            this.center.popupHoverProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.closeAfterTransition.stop();
                } else if (this.closeAutomatically) {
                    this.closeAfterTransition.playFromStart();
                }
            });
            this.center.addEventFilter(MouseEvent.MOUSE_ENTERED, event -> this.closeAfterTransition.stop());
            this.center.addEventFilter(MouseEvent.MOUSE_EXITED, event -> {
                if (this.closeAutomatically) {
                    this.closeAfterTransition.playFromStart();
                }
            });
            this.centerInit = true;
        }
    }

    @Override
    public INotificationSystem publish(INotification notification) {
        if (notification == null) {
            return this;
        }
        if (this.owner == null) {
            throw new IllegalStateException("The NotificationSystem has not been initialized!");
        }
        if (this.isClosing()) {
            this.scheduleReopen(notification);
        } else {
            this.center.getNotifications().add(notification);
            if (this.closeAutomatically) {
                this.closeAfterTransition.playFromStart();
            }
            if (!this.isShowing() && !this.center.isDoNotDisturb()) {
                this.init();
                this.popup.show(this.owner);
                if (this.animated) {
                    AnimationUtils.TimelineBuilder.build().show(250.0, (Node)this.center).getAnimation().play();
                } else {
                    this.center.setOpacity(1.0);
                }
                if (this.openOnNew) {
                    this.show();
                }
            }
        }
        return this;
    }

    @Override
    protected void show() {
        this.showing.set(true);
        TransitionPositionBean positionBean = this.computePosition();
        double x = positionBean.getX();
        double y = positionBean.getY();
        double deltaX = positionBean.deltaX();
        double deltaY = positionBean.deltaY();
        if (this.animated) {
            AnimationUtils.ParallelBuilder.build().add((Animation)ConsumerTransition.of(frac -> this.popup.setX(x - deltaX * frac), 250.0, Interpolators.INTERPOLATOR_V2)).add((Animation)ConsumerTransition.of(frac -> this.popup.setY(y - deltaY * frac), 250.0, Interpolators.INTERPOLATOR_V2)).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> this.center.setShowing(true))).getAnimation().play();
        } else {
            this.popup.setX(x - deltaX);
            this.popup.setY(y - deltaY);
            this.center.setShowing(true);
        }
    }

    @Override
    protected void close() {
        this.closing.set(true);
        this.center.setShowing(false);
        TransitionPositionBean positionBean = this.computePosition();
        double x = this.popup.getX();
        double y = this.popup.getY();
        double deltaX = positionBean.deltaX();
        double deltaY = positionBean.deltaY();
        if (this.animated) {
            AnimationUtils.ParallelBuilder.build().setDelay(100.0).hide(400.0, new Node[]{this.center}).add((Animation)ConsumerTransition.of(frac -> this.popup.setX(x + deltaX * frac), 250.0, Interpolators.INTERPOLATOR_V2)).add((Animation)ConsumerTransition.of(frac -> this.popup.setY(y + deltaY * frac), 250.0, Interpolators.INTERPOLATOR_V2)).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> {
                this.popup.hide();
                this.closing.reset();
                this.showing.reset();
            })).getAnimation().play();
        } else {
            AnimationUtils.PauseBuilder.build().setDuration(30.0).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> {
                this.popup.setX(x + deltaX);
                this.popup.setY(y + deltaY);
                this.center.setOpacity(0.0);
                this.popup.hide();
                this.showing.reset();
                this.closing.reset();
            })).getAnimation().play();
        }
    }

    @Override
    protected void scheduleReopen(INotification notification) {
        ExecutionUtils.executeWhen(this.closing, (oldValue, newValue) -> this.publish(notification), false, (oldValue, newValue) -> newValue == false, true);
    }

    @Override
    protected TransitionPositionBean computePosition() {
        double endX;
        double x;
        double endY;
        double y;
        Rectangle2D screenBounds = this.screen.getVisualBounds();
        CustomBounds centerBounds = this.getBounds();
        double counterWidth = centerBounds.getMaxX() - centerBounds.getMinX();
        if (PositionUtils.isTop(this.position)) {
            endY = y = screenBounds.getMinY() + this.spacing.getTop();
        } else {
            y = screenBounds.getMaxY() - centerBounds.getMaxY() - this.spacing.getBottom();
            endY = screenBounds.getMaxY() - centerBounds.getHeight() - this.spacing.getBottom();
        }
        if (PositionUtils.isCenter(this.position)) {
            endX = x = screenBounds.getMaxX() / 2.0 - counterWidth / 2.0;
        } else if (PositionUtils.isRight(this.position)) {
            x = screenBounds.getMaxX() - counterWidth - this.spacing.getRight();
            endX = screenBounds.getMaxX() - centerBounds.getMaxX() - this.spacing.getRight();
        } else {
            x = screenBounds.getMinX() + this.spacing.getLeft();
            endX = centerBounds.getMinX() + this.spacing.getLeft();
        }
        return TransitionPositionBean.of(x, y, endX, endY);
    }

    @Override
    public INotificationSystem dispose() {
        if (this.owner != null) {
            this.owner = null;
        }
        return this;
    }

    private CustomBounds getBounds() {
        Bounds bounds = this.center.getLayoutBounds();
        double width = this.center.getPopupWidth();
        double height = bounds.getHeight() + this.center.getPopupHeight() + this.center.getPopupSpacing();
        double minX = width / 2.0 - bounds.getWidth() / 2.0;
        double maxX = minX + bounds.getWidth();
        return new CustomBounds(minX, bounds.getMinY(), maxX, bounds.getMaxY(), width, height);
    }

    public MFXNotificationCenter getCenter() {
        return this.center;
    }

    @Override
    public AbstractMFXNotificationSystem setAnimated(boolean animated) {
        this.animated = animated;
        this.center.setAnimated(animated);
        return this;
    }

    public boolean isOpenOnNew() {
        return this.openOnNew;
    }

    public MFXNotificationCenterSystem setOpenOnNew(boolean openOnNew) {
        this.openOnNew = openOnNew;
        return this;
    }
}

