/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.notifications;

import io.github.palexdev.materialfx.beans.TransitionPositionBean;
import io.github.palexdev.materialfx.collections.CircularQueue;
import io.github.palexdev.materialfx.effects.ConsumerTransition;
import io.github.palexdev.materialfx.effects.Interpolators;
import io.github.palexdev.materialfx.notifications.base.AbstractMFXNotificationSystem;
import io.github.palexdev.materialfx.notifications.base.INotification;
import io.github.palexdev.materialfx.notifications.base.INotificationSystem;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.ExecutionUtils;
import io.github.palexdev.materialfx.utils.PositionUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Animation;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.stage.Window;
import javafx.util.Duration;

public class MFXNotificationSystem
extends AbstractMFXNotificationSystem {
    private static final MFXNotificationSystem instance = new MFXNotificationSystem();
    private final CircularQueue<INotification> notifications = new CircularQueue(100);
    private final List<INotification> queued = new ArrayList<INotification>();
    private final Group notificationContainer = new Group();

    public static MFXNotificationSystem instance() {
        return instance;
    }

    private MFXNotificationSystem() {
        this.notificationContainer.setOpacity(0.0);
        this.popup.setContent((Node)this.notificationContainer);
    }

    @Override
    public MFXNotificationSystem initOwner(Window owner) {
        this.dispose();
        this.owner = owner;
        TransitionPositionBean positionBean = this.computePosition();
        this.popup.show(owner, positionBean.getX(), positionBean.getY());
        return this;
    }

    @Override
    protected void init() {
        TransitionPositionBean position = this.computePosition();
        this.popup.hoverProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.closeAfterTransition.stop();
            } else if (this.closeAutomatically) {
                this.closeAfterTransition.playFromStart();
            }
        });
        this.popup.show(this.owner, position.getX(), position.getY());
    }

    @Override
    public MFXNotificationSystem publish(INotification notification) {
        if (notification == null) {
            return this;
        }
        if (this.owner == null) {
            throw new IllegalStateException("The NotificationSystem has not been initialized!");
        }
        if (this.isClosing() || this.isShowing()) {
            this.scheduleReopen(notification);
        } else {
            this.notifications.add(notification);
            if (this.closeAutomatically) {
                this.closeAfterTransition.playFromStart();
            }
            if (!this.isShowing()) {
                this.init();
                this.popup.show(this.owner);
                this.notificationContainer.getChildren().setAll((Object[])new Node[]{notification.getContent()});
                this.notificationContainer.applyCss();
                this.notificationContainer.layout();
                if (this.animated) {
                    AnimationUtils.TimelineBuilder.build().show(400.0, (Node)this.notificationContainer).getAnimation().play();
                } else {
                    this.notificationContainer.setOpacity(1.0);
                }
                this.show();
            }
        }
        return this;
    }

    @Override
    protected void show() {
        this.showing.set(true);
        TransitionPositionBean positionBean = this.computePosition();
        double x = positionBean.getX();
        double y = positionBean.getY();
        double deltaX = positionBean.deltaX();
        double deltaY = positionBean.deltaY();
        if (this.animated) {
            AnimationUtils.ParallelBuilder.build().add((Animation)ConsumerTransition.of(frac -> this.popup.setY(y - deltaY * frac), Duration.millis((double)400.0), Interpolators.INTERPOLATOR_V2.toInterpolator())).add(AnimationUtils.KeyFrames.of(1.0, (EventHandler<ActionEvent>)((EventHandler)event -> this.popup.setX(x - deltaX)))).getAnimation().play();
        } else {
            this.popup.setX(x - deltaX);
            this.popup.setY(y - deltaY);
        }
    }

    @Override
    protected void close() {
        this.closing.set(true);
        if (this.animated) {
            AnimationUtils.TimelineBuilder.build().hide(400.0, (Node)this.notificationContainer).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> {
                this.popup.hide();
                this.showing.reset();
                this.closing.reset();
            })).getAnimation().play();
        } else {
            AnimationUtils.PauseBuilder.build().setDuration(30.0).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> {
                this.notificationContainer.setOpacity(0.0);
                this.popup.hide();
                this.showing.reset();
                this.closing.reset();
            })).getAnimation().play();
        }
    }

    @Override
    protected void scheduleReopen(INotification notification) {
        this.queued.add(notification);
        ExecutionUtils.executeWhen(this.closing, (oldValue, newValue) -> {
            if (!this.queued.isEmpty()) {
                AnimationUtils.PauseBuilder.build().setDuration(300.0).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> this.publish(this.queued.remove(0)))).getAnimation().play();
            }
        }, false, (oldValue, newValue) -> newValue == false, true);
    }

    @Override
    protected TransitionPositionBean computePosition() {
        double endX;
        double x;
        double endY;
        double y;
        Rectangle2D screenBounds = this.screen.getVisualBounds();
        Bounds containerBounds = this.notificationContainer.getLayoutBounds();
        if (PositionUtils.isTop(this.position)) {
            y = -containerBounds.getMaxY() - this.spacing.getTop();
            endY = screenBounds.getMinY() + this.spacing.getTop();
        } else {
            y = screenBounds.getMaxY() + this.spacing.getBottom();
            endY = screenBounds.getMaxY() - containerBounds.getMaxY() - this.spacing.getBottom();
        }
        if (PositionUtils.isCenter(this.position)) {
            endX = x = screenBounds.getMaxX() / 2.0 - containerBounds.getMaxX() / 2.0;
        } else if (PositionUtils.isRight(this.position)) {
            x = screenBounds.getMaxX() + this.spacing.getRight();
            endX = screenBounds.getMaxX() - containerBounds.getMaxX() - this.spacing.getRight();
        } else {
            x = -containerBounds.getMaxX() - this.spacing.getLeft();
            endX = screenBounds.getMinX() + this.spacing.getLeft();
        }
        return TransitionPositionBean.of(x, y, endX, endY);
    }

    @Override
    public INotificationSystem dispose() {
        if (this.owner != null) {
            this.owner = null;
        }
        return this;
    }

    public CircularQueue<INotification> history() {
        return this.notifications;
    }

    public MFXNotificationSystem setHistoryLimit(int size) {
        this.notifications.setSize(size);
        return this;
    }
}

