/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.notifications.base;

import io.github.palexdev.materialfx.beans.TransitionPositionBean;
import io.github.palexdev.materialfx.beans.properties.resettable.ResettableBooleanProperty;
import io.github.palexdev.materialfx.controls.MFXPopup;
import io.github.palexdev.materialfx.enums.NotificationPos;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.notifications.base.INotification;
import io.github.palexdev.materialfx.notifications.base.INotificationSystem;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.ExecutionUtils;
import javafx.animation.PauseTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.util.Duration;

public abstract class AbstractMFXNotificationSystem
implements INotificationSystem {
    protected Screen screen = Screen.getPrimary();
    protected Window owner;
    protected final MFXPopup popup;
    protected NotificationPos position;
    protected Insets spacing;
    protected boolean animated = true;
    protected boolean closeAutomatically = true;
    protected Duration closeAfter = Duration.seconds((double)3.0);
    protected final PauseTransition closeAfterTransition;
    protected final ResettableBooleanProperty showing = new ResettableBooleanProperty(false, false);
    protected final ResettableBooleanProperty closing = new ResettableBooleanProperty(false, false);

    protected AbstractMFXNotificationSystem() {
        this.position = NotificationPos.BOTTOM_RIGHT;
        this.spacing = InsetsFactory.all(15.0);
        this.popup = new MFXPopup();
        this.popup.setAnimated(false);
        this.closeAfterTransition = AnimationUtils.PauseBuilder.build().setDelay(100.0).setDuration(this.closeAfter).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> this.close())).getAnimation();
        this.closing.setFireChangeOnReset(true);
    }

    protected abstract void show();

    protected abstract void close();

    protected abstract void scheduleReopen(INotification var1);

    protected abstract TransitionPositionBean computePosition();

    protected void init() {
    }

    public Screen getScreen() {
        return this.screen;
    }

    public AbstractMFXNotificationSystem setScreen(Screen screen) {
        this.screen = screen;
        return this;
    }

    public NotificationPos getPosition() {
        return this.position;
    }

    public AbstractMFXNotificationSystem setPosition(NotificationPos position) {
        this.position = position;
        return this;
    }

    public AbstractMFXNotificationSystem delaySetPosition(NotificationPos position) {
        if (this.isShowing()) {
            ExecutionUtils.executeWhen(this.closing, (oldValue, newValue) -> this.setPosition(position), false, (oldValue, newValue) -> newValue == false, true);
        } else {
            this.setPosition(position);
        }
        return this;
    }

    public Insets getSpacing() {
        return this.spacing;
    }

    public AbstractMFXNotificationSystem setSpacing(Insets spacing) {
        this.spacing = spacing;
        return this;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public AbstractMFXNotificationSystem setAnimated(boolean animated) {
        this.animated = animated;
        return this;
    }

    public boolean isCloseAutomatically() {
        return this.closeAutomatically;
    }

    public AbstractMFXNotificationSystem setCloseAutomatically(boolean closeAutomatically) {
        this.closeAutomatically = closeAutomatically;
        return this;
    }

    public Duration getCloseAfter() {
        return this.closeAfter;
    }

    public AbstractMFXNotificationSystem setCloseAfter(Duration closeAfter) {
        this.closeAfter = closeAfter;
        this.closeAfterTransition.setDuration(closeAfter);
        return this;
    }

    public boolean isShowing() {
        return this.showing.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }
}

