/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PopupPositionBean;
import io.github.palexdev.materialfx.controls.MFXContextMenu;
import io.github.palexdev.materialfx.controls.MFXScrollPane;
import java.util.List;
import javafx.animation.Animation;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Line;
import javafx.scene.transform.Scale;
import javafx.stage.WindowEvent;

public class MFXContextMenuSkin
implements Skin<MFXContextMenu> {
    private MFXContextMenu contextMenu;
    private final MFXScrollPane scrollPane;
    private final VBox container;
    private final Scale scale;
    private Animation animation;
    private EventHandler<WindowEvent> initHandler;
    private EventHandler<WindowEvent> closeHandler;

    public MFXContextMenuSkin(MFXContextMenu contextMenu) {
        this.contextMenu = contextMenu;
        this.scale = new Scale(0.1, 0.1, 0.0, 0.0);
        this.container = new VBox(){

            protected void layoutChildren() {
                super.layoutChildren();
                ObservableList children = this.getChildren();
                for (Node child : children) {
                    if (!(child instanceof Line)) continue;
                    Line separator = (Line)child;
                    separator.setEndX(this.getWidth() - (this.snappedRightInset() + this.snappedLeftInset()));
                }
            }
        };
        Bindings.bindContent((List)this.container.getChildren(), contextMenu.getItems());
        this.scrollPane = new MFXScrollPane((Node)this.container);
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.scrollPane.getTransforms().add((Object)this.scale);
        contextMenu.setContent((Node)this.scrollPane);
        this.initHandler = event -> {
            this.init();
            if (contextMenu.isAnimated()) {
                this.animation = contextMenu.getAnimationProvider().apply((Node)this.scrollPane, this.scale);
                this.animation.play();
            } else {
                this.scale.setX(1.0);
                this.scale.setY(1.0);
                this.scrollPane.setOpacity(1.0);
            }
        };
        this.closeHandler = event -> {
            this.scrollPane.setOpacity(0.0);
            this.scale.setX(0.1);
            this.scale.setY(0.1);
        };
        contextMenu.addEventHandler(WindowEvent.WINDOW_SHOWN, this.initHandler);
        contextMenu.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.closeHandler);
        Bindings.bindContent((List)this.scrollPane.getStylesheets(), contextMenu.getStyleSheets());
    }

    protected void init() {
        this.scrollPane.setOpacity(0.0);
        PopupPositionBean position = this.contextMenu.getPosition();
        if (position == null) {
            return;
        }
        if (position.getAlignment() != null) {
            double containerW = this.container.prefWidth(-1.0);
            double containerH = this.container.prefHeight(-1.0);
            HPos hPos = position.getHPos();
            VPos vPos = position.getVPos();
            double xOffset = position.getXOffset();
            double yOffset = position.getYOffset();
            double px = hPos == HPos.RIGHT ? xOffset : containerW + xOffset;
            double py = vPos == VPos.BOTTOM ? yOffset : containerH + yOffset;
            this.scale.setPivotX(px);
            this.scale.setPivotY(py);
        }
        this.contextMenu.reposition();
    }

    public MFXContextMenu getSkinnable() {
        return this.contextMenu;
    }

    public Node getNode() {
        return this.scrollPane;
    }

    public void dispose() {
        this.animation.stop();
        this.animation = null;
        this.contextMenu.removeEventHandler(WindowEvent.WINDOW_SHOWN, this.initHandler);
        this.contextMenu.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.closeHandler);
        this.initHandler = null;
        this.closeHandler = null;
        this.contextMenu = null;
    }
}

