/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.NumberRange;
import io.github.palexdev.materialfx.controls.BoundTextField;
import io.github.palexdev.materialfx.controls.MFXComboBox;
import io.github.palexdev.materialfx.controls.MFXDatePicker;
import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXPopup;
import io.github.palexdev.materialfx.controls.cell.MFXDateCell;
import io.github.palexdev.materialfx.skins.MFXTextFieldSkin;
import io.github.palexdev.materialfx.utils.DateTimeUtils;
import io.github.palexdev.materialfx.utils.ExecutionUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class MFXDatePickerSkin
extends MFXTextFieldSkin {
    private Map<DayOfWeek, Integer> weekDays;
    private List<Label> weekDaysLabels = new ArrayList<Label>();
    private MFXDateCell[][] cells;
    private boolean cellsInitialized = false;
    private boolean weekDaysChanged = false;
    private final GridPane grid;
    private final MFXPopup popup;
    private EventHandler<MouseEvent> popupManager;
    private YearMonth currentYearMonth;
    private Integer[][] monthMatrix;
    private final ObservableList<Integer> years = FXCollections.observableArrayList();

    public MFXDatePickerSkin(MFXDatePicker datePicker, BoundTextField boundField) {
        super(datePicker, boundField);
        this.popup = new MFXPopup();
        this.popup.getStyleClass().add((Object)"date-picker-popup");
        this.popup.setPopupStyleableParent((Parent)datePicker);
        this.popup.setAutoHide(true);
        this.popupManager = event -> datePicker.show();
        this.weekDays = DateTimeUtils.weekDays(datePicker.getLocale());
        this.currentYearMonth = datePicker.getStartingYearMonth() != null ? datePicker.getStartingYearMonth() : DateTimeUtils.dateToYearMonth(datePicker.getCurrentDate());
        NumberRange<Integer> yearsRange = datePicker.getYearsRange();
        this.years.setAll((Collection)IntStream.rangeClosed(yearsRange.getMin(), yearsRange.getMax()).boxed().collect(Collectors.toList()));
        this.monthMatrix = datePicker.getGridAlgorithm().apply(datePicker.getLocale(), this.currentYearMonth);
        this.grid = new GridPane();
        this.grid.setMaxHeight(Double.MAX_VALUE);
        VBox.setVgrow((Node)this.grid, (Priority)Priority.ALWAYS);
        this.initialize();
        this.setBehavior();
    }

    protected void initialize() {
        MFXDatePicker datePicker = this.getDatePicker();
        this.popup.setContent(this.createPopupContent());
        LocalDate date = datePicker.getValue();
        if (date != null) {
            this.updateValue(date);
            ExecutionUtils.executeWhen(datePicker.delegateSelectedTextProperty(), (oldValue, newValue) -> datePicker.positionCaret(newValue.length()), false, (oldValue, newValue) -> !newValue.isEmpty(), true);
        }
    }

    protected void setBehavior() {
        this.datePickerBehavior();
        this.iconBehavior();
        this.popupBehavior();
    }

    private void datePickerBehavior() {
        MFXDatePicker datePicker = this.getDatePicker();
        datePicker.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (!datePicker.isEditable()) {
                return;
            }
            switch (event.getCode()) {
                case ENTER: {
                    datePicker.commit(datePicker.getText());
                    break;
                }
                case Z: {
                    if (!event.isShiftDown() || !event.isControlDown()) break;
                    datePicker.cancel(datePicker.getText());
                }
            }
        });
        datePicker.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.updateValue((LocalDate)newValue);
            if (datePicker.isClosePopupOnChange()) {
                this.popup.hide();
            }
        });
        datePicker.valueProperty().addListener(invalidated -> Event.fireEvent((EventTarget)datePicker, (Event)new ActionEvent()));
        datePicker.converterSupplierProperty().addListener((observable, oldValue, newValue) -> this.updateValue(datePicker.getValue()));
        datePicker.dayOfWeekConverterSupplierProperty().addListener((observable, oldValue, newValue) -> this.updateWeekDays());
        datePicker.cellFactoryProperty().addListener((observable, oldValue, newValue) -> {
            this.monthMatrix = null;
            this.cells = null;
            this.cellsInitialized = false;
            this.grid.getChildren().clear();
            this.weekDaysLabels.clear();
            this.updateWeekDays();
            this.updateGrid();
        });
        datePicker.localeProperty().addListener((observable, oldValue, newValue) -> {
            this.monthMatrix = null;
            this.weekDays = DateTimeUtils.weekDays(newValue);
            this.weekDaysChanged = true;
            this.updateWeekDays();
            this.updateGrid();
        });
        datePicker.yearsRangeProperty().addListener((observable, oldValue, newValue) -> this.years.setAll((Collection)IntStream.rangeClosed((Integer)newValue.getMin(), (Integer)newValue.getMax()).boxed().collect(Collectors.toList())));
        datePicker.gridAlgorithmProperty().addListener((observable, oldValue, newValue) -> {
            this.monthMatrix = null;
            this.updateGrid();
        });
    }

    private void iconBehavior() {
        MFXDatePicker datePicker = this.getDatePicker();
        Node trailingIcon = datePicker.getTrailingIcon();
        if (trailingIcon != null) {
            trailingIcon.addEventHandler(MouseEvent.MOUSE_PRESSED, this.popupManager);
        }
        datePicker.trailingIconProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.popupManager);
            }
            if (newValue != null) {
                newValue.addEventHandler(MouseEvent.MOUSE_PRESSED, this.popupManager);
            }
        });
        this.popup.showingProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                datePicker.hide();
                if (trailingIcon instanceof MFXIconWrapper) {
                    MFXIconWrapper icon = (MFXIconWrapper)trailingIcon;
                    icon.getRippleGenerator().generateRipple(null);
                }
            }
        });
    }

    private void popupBehavior() {
        MFXDatePicker datePicker = this.getDatePicker();
        this.popup.setOnShowing(event -> Event.fireEvent((EventTarget)datePicker, (Event)new Event((Object)this.popup, (EventTarget)datePicker, MFXComboBox.ON_SHOWING)));
        this.popup.setOnShown(event -> Event.fireEvent((EventTarget)datePicker, (Event)new Event((Object)this.popup, (EventTarget)datePicker, MFXComboBox.ON_SHOWN)));
        this.popup.setOnHiding(event -> Event.fireEvent((EventTarget)datePicker, (Event)new Event((Object)this.popup, (EventTarget)datePicker, MFXComboBox.ON_HIDING)));
        this.popup.setOnHidden(event -> Event.fireEvent((EventTarget)datePicker, (Event)new Event((Object)this.popup, (EventTarget)datePicker, MFXComboBox.ON_HIDDEN)));
        datePicker.showingProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.popup.show((Node)datePicker, datePicker.getPopupAlignment(), datePicker.getPopupOffsetX(), datePicker.getPopupOffsetY());
            }
        });
    }

    protected void updateValue(LocalDate date) {
        MFXDatePicker datePicker = this.getDatePicker();
        String s = "";
        if (date != null) {
            StringConverter<LocalDate> converter = datePicker.getConverterSupplier().get();
            s = converter != null ? converter.toString((Object)date) : date.toString();
        }
        datePicker.setText(s);
        datePicker.positionCaret(s.length());
    }

    protected Node createPopupContent() {
        int i;
        MFXDatePicker datePicker = this.getDatePicker();
        MFXComboBox monthCombo = new MFXComboBox(FXCollections.observableArrayList((Object[])Month.values()));
        monthCombo.getStyleClass().add((Object)"months-combo");
        monthCombo.converterProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> datePicker.getMonthConverterSupplier().get(), (Observable[])new Observable[]{datePicker.monthConverterSupplierProperty()}));
        monthCombo.selectItem(this.currentYearMonth.getMonth());
        monthCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.currentYearMonth = this.currentYearMonth.withMonth(newValue.getValue());
            this.monthMatrix = datePicker.getGridAlgorithm().apply(datePicker.getLocale(), this.currentYearMonth);
            this.updateGrid();
        });
        MFXComboBox<Integer> yearCombo = new MFXComboBox<Integer>(this.years);
        yearCombo.getStyleClass().add((Object)"years-combo");
        yearCombo.selectItem(this.currentYearMonth.getYear());
        yearCombo.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.currentYearMonth = this.currentYearMonth.withYear((int)newValue);
            this.monthMatrix = datePicker.getGridAlgorithm().apply(datePicker.getLocale(), this.currentYearMonth);
            this.updateGrid();
        });
        MFXIconWrapper leftArrow = new MFXIconWrapper("fas-arrow-left", 14.0, 30.0).defaultRippleGeneratorBehavior();
        MFXIconWrapper rightArrow = new MFXIconWrapper("fas-arrow-right", 14.0, 30.0).defaultRippleGeneratorBehavior();
        leftArrow.getStyleClass().add((Object)"left-arrow");
        rightArrow.getStyleClass().add((Object)"right-arrow");
        leftArrow.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            this.currentYearMonth = this.currentYearMonth.plusMonths(-1L);
            yearCombo.selectItem(this.currentYearMonth.getYear());
            monthCombo.selectItem(this.currentYearMonth.getMonth());
        });
        leftArrow.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> Objects.equals(yearCombo.getSelectedItem(), datePicker.getYearsRange().getMin()) && this.currentYearMonth.getMonth() == Month.JANUARY, (Observable[])new Observable[]{datePicker.yearsRangeProperty(), yearCombo.selectedItemProperty(), monthCombo.selectedItemProperty()}));
        rightArrow.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            this.currentYearMonth = this.currentYearMonth.plusMonths(1L);
            yearCombo.selectItem(this.currentYearMonth.getYear());
            monthCombo.selectItem(this.currentYearMonth.getMonth());
        });
        rightArrow.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> Objects.equals(yearCombo.getSelectedItem(), datePicker.getYearsRange().getMax()) && this.currentYearMonth.getMonth() == Month.DECEMBER, (Observable[])new Observable[]{datePicker.yearsRangeProperty(), yearCombo.selectedItemProperty(), monthCombo.selectedItemProperty()}));
        NodeUtils.makeRegionCircular((Region)leftArrow);
        NodeUtils.makeRegionCircular((Region)rightArrow);
        HBox comboContainer = new HBox(10.0, new Node[]{leftArrow, monthCombo, yearCombo, rightArrow});
        comboContainer.setAlignment(Pos.CENTER);
        this.grid.getColumnConstraints().clear();
        for (i = 0; i < 7; ++i) {
            ColumnConstraints cc = new ColumnConstraints();
            cc.setHalignment(HPos.CENTER);
            cc.setHgrow(Priority.ALWAYS);
            this.grid.getColumnConstraints().add((Object)cc);
        }
        this.grid.getRowConstraints().clear();
        for (i = 0; i < 6; ++i) {
            RowConstraints rc = new RowConstraints();
            rc.setVgrow(Priority.ALWAYS);
            this.grid.getRowConstraints().add((Object)rc);
        }
        this.updateWeekDays();
        this.updateGrid();
        VBox container = new VBox(20.0, new Node[]{comboContainer, this.grid});
        container.getStyleClass().add((Object)"content");
        container.setAlignment(Pos.TOP_CENTER);
        return container;
    }

    private void updateWeekDays() {
        MFXDatePicker datePicker = this.getDatePicker();
        StringConverter<DayOfWeek> dayOfWeekConverter = datePicker.getDayOfWeekConverterSupplier().get();
        if (this.weekDaysLabels.isEmpty()) {
            for (DayOfWeek dayOfWeek : this.weekDays.keySet()) {
                Label label = new Label(dayOfWeekConverter.toString((Object)dayOfWeek));
                label.getStyleClass().add((Object)"week-day");
                label.setAlignment(Pos.CENTER);
                this.weekDaysLabels.add(label);
            }
            this.grid.addRow(0, (Node[])this.weekDaysLabels.toArray(Node[]::new));
            return;
        }
        if (this.weekDaysChanged) {
            int i = 0;
            for (DayOfWeek dayOfWeek : this.weekDays.keySet()) {
                Label label = this.weekDaysLabels.get(i);
                label.setText(dayOfWeekConverter.toString((Object)dayOfWeek));
                ++i;
            }
            this.weekDaysChanged = false;
        }
    }

    private void updateGrid() {
        MFXDatePicker datePicker = this.getDatePicker();
        if (this.monthMatrix == null) {
            this.monthMatrix = datePicker.getGridAlgorithm().apply(datePicker.getLocale(), this.currentYearMonth);
        }
        if (this.cells == null) {
            this.cells = new MFXDateCell[this.monthMatrix.length][this.monthMatrix[0].length];
        }
        ArrayList<Parent> children = new ArrayList<Parent>();
        int row = 1;
        int startIndex = DateTimeUtils.startIndexFor(this.currentYearMonth, datePicker.getLocale());
        int endIndex = DateTimeUtils.endIndexFor(this.currentYearMonth, datePicker.getLocale());
        for (int i = 0; i < this.monthMatrix.length; ++i) {
            Integer[] matrixRow = this.monthMatrix[i];
            for (int j = 0; j < matrixRow.length; ++j) {
                LocalDate date;
                MFXDateCell cell;
                int index = i * 7 + j;
                Integer day = matrixRow[j];
                if (day == null) {
                    cell = this.getCell(i, j, null);
                    cell.updateItem(null);
                    this.cells[i][j] = cell;
                    children.add(cell.toParent());
                    continue;
                }
                if (index < startIndex) {
                    YearMonth previous = this.currentYearMonth.plusMonths(-1L);
                    date = LocalDate.of(previous.getYear(), previous.getMonth(), (int)day);
                    cell = this.getCell(i, j, date);
                    cell.markAsExtra();
                } else if (index > endIndex) {
                    YearMonth next = this.currentYearMonth.plusMonths(1L);
                    date = LocalDate.of(next.getYear(), next.getMonth(), (int)day);
                    cell = this.getCell(i, j, date);
                    cell.markAsExtra();
                } else {
                    date = LocalDate.of(this.currentYearMonth.getYear(), this.currentYearMonth.getMonth(), (int)day);
                    cell = this.getCell(i, j, date);
                    cell.unmarkAsExtra();
                }
                if (!this.cellsInitialized) {
                    this.cells[i][j] = cell;
                }
                cell.updateItem(date);
                children.add(cell.toParent());
            }
            if (!this.cellsInitialized) {
                this.grid.addRow(row, (Node[])children.toArray(Node[]::new));
            }
            children.clear();
            ++row;
        }
        this.cellsInitialized = true;
    }

    private MFXDateCell getCell(int row, int column, LocalDate date) {
        MFXDatePicker datePicker = (MFXDatePicker)this.getSkinnable();
        Function<LocalDate, MFXDateCell> cellFactory = datePicker.getCellFactory();
        if (!this.cellsInitialized) {
            return cellFactory.apply(date);
        }
        return this.cells[row][column];
    }

    public MFXDatePicker getDatePicker() {
        return (MFXDatePicker)this.getSkinnable();
    }

    public void dispose() {
        super.dispose();
        MFXDatePicker datePicker = this.getDatePicker();
        if (datePicker.getTrailingIcon() != null) {
            datePicker.getTrailingIcon().removeEventHandler(MouseEvent.MOUSE_PRESSED, this.popupManager);
        }
        this.popupManager = null;
        this.weekDaysLabels.clear();
        this.weekDaysLabels = null;
        this.cells = null;
    }
}

