/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.beans.PopupPositionBean;
import io.github.palexdev.materialfx.controls.MFXPopup;
import java.util.List;
import javafx.animation.Animation;
import javafx.beans.binding.Bindings;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.WindowEvent;

public class MFXPopupSkin
implements Skin<MFXPopup> {
    private MFXPopup popup;
    private final StackPane container;
    private final Scale scale;
    private Animation animation;
    private EventHandler<WindowEvent> initHandler;
    private EventHandler<WindowEvent> closeHandler;

    public MFXPopupSkin(MFXPopup popup) {
        this.popup = popup;
        this.scale = new Scale(0.1, 0.1, 0.0, 0.0);
        this.container = new StackPane(new Node[]{popup.getContent()});
        this.container.getTransforms().setAll((Object[])new Transform[]{this.scale});
        this.initHandler = event -> {
            this.init();
            if (popup.isAnimated()) {
                this.animation = popup.getAnimationProvider().apply((Node)this.container, this.scale);
                this.animation.play();
            } else {
                this.scale.setX(1.0);
                this.scale.setY(1.0);
                this.container.setOpacity(1.0);
            }
        };
        this.closeHandler = event -> {
            this.container.setOpacity(0.0);
            this.scale.setX(0.1);
            this.scale.setY(0.1);
        };
        popup.addEventHandler(WindowEvent.WINDOW_SHOWN, this.initHandler);
        popup.addEventHandler(WindowEvent.WINDOW_HIDDEN, this.closeHandler);
        Bindings.bindContent((List)this.container.getStylesheets(), popup.getStyleSheets());
    }

    protected void init() {
        this.container.setOpacity(0.0);
        PopupPositionBean position = this.popup.getPosition();
        if (position == null) {
            return;
        }
        if (position.getAlignment() != null) {
            double containerW = this.container.prefWidth(-1.0);
            double containerH = this.container.prefHeight(-1.0);
            HPos hPos = position.getHPos();
            VPos vPos = position.getVPos();
            double xOffset = position.getXOffset();
            double yOffset = position.getYOffset();
            double px = hPos == HPos.RIGHT ? xOffset : containerW + xOffset;
            double py = vPos == VPos.BOTTOM ? yOffset : containerH + yOffset;
            this.scale.setPivotX(px);
            this.scale.setPivotY(py);
        }
        this.popup.reposition();
    }

    public MFXPopup getSkinnable() {
        return this.popup;
    }

    public Node getNode() {
        return this.container;
    }

    public void dispose() {
        this.animation.stop();
        this.animation = null;
        this.popup.removeEventHandler(WindowEvent.WINDOW_SHOWN, this.initHandler);
        this.popup.removeEventHandler(WindowEvent.WINDOW_HIDDEN, this.closeHandler);
        this.initHandler = null;
        this.closeHandler = null;
        this.popup = null;
    }
}

