/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.MFXButton;
import io.github.palexdev.materialfx.controls.MFXStepper;
import io.github.palexdev.materialfx.controls.MFXStepperToggle;
import io.github.palexdev.materialfx.effects.ripple.RippleClipType;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.factories.RippleClipTypeFactory;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.util.Duration;

public class MFXStepperSkin
extends SkinBase<MFXStepper> {
    private final StackPane contentPane;
    private final HBox stepperBar;
    private final HBox buttonsBox;
    private final MFXButton nextButton;
    private final MFXButton previousButton;
    private final Group progressBarGroup;
    private final double height = 7.0;
    private final Rectangle bar;
    private final Rectangle track = this.buildRectangle("track");
    private Timeline progressAnimation;
    private boolean buttonWasPressed = false;

    public MFXStepperSkin(MFXStepper stepper) {
        super((Control)stepper);
        this.track.setHeight(7.0);
        this.track.widthProperty().bind((ObservableValue)stepper.widthProperty());
        this.bar = this.buildRectangle("bar");
        this.bar.setHeight(7.0);
        Rectangle clip = new Rectangle();
        clip.setHeight(7.0);
        clip.widthProperty().bind((ObservableValue)stepper.widthProperty());
        clip.arcHeightProperty().bind((ObservableValue)stepper.progressBarBorderRadiusProperty());
        clip.arcWidthProperty().bind((ObservableValue)stepper.progressBarBorderRadiusProperty());
        this.progressBarGroup = new Group(new Node[]{this.track, this.bar});
        this.progressBarGroup.setManaged(false);
        this.progressBarGroup.setClip((Node)clip);
        this.progressAnimation = new Timeline();
        this.progressAnimation.setOnFinished(event -> {
            this.buttonWasPressed = false;
        });
        this.stepperBar = new HBox(new Node[]{this.progressBarGroup});
        this.stepperBar.spacingProperty().bind((ObservableValue)stepper.spacingProperty());
        this.stepperBar.alignmentProperty().bind(stepper.alignmentProperty());
        this.stepperBar.getChildren().addAll(stepper.getStepperToggles());
        this.stepperBar.setMinHeight(100.0);
        this.stepperBar.setPrefSize(-1.0, -1.0);
        this.progressBarGroup.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> this.snapPositionY(this.stepperBar.getHeight() / 2.0 - 3.5), (Observable[])new Observable[]{this.stepperBar.heightProperty()}));
        this.nextButton = new MFXButton(I18N.getOrDefault("stepper.next", new Object[0]));
        this.nextButton.setManaged(false);
        this.nextButton.getRippleGenerator().setClipSupplier(() -> new RippleClipTypeFactory(RippleClipType.ROUNDED_RECTANGLE, 34.0, 34.0).build((Region)this.nextButton));
        this.previousButton = new MFXButton(I18N.getOrDefault("stepper.previous", new Object[0]));
        this.previousButton.setManaged(false);
        this.previousButton.getRippleGenerator().setClipSupplier(() -> new RippleClipTypeFactory(RippleClipType.ROUNDED_RECTANGLE, 34.0, 34.0).build((Region)this.previousButton));
        this.buttonsBox = new HBox(64.0, new Node[]{this.previousButton, this.nextButton});
        this.buttonsBox.getStyleClass().setAll((Object[])new String[]{"buttons-box"});
        this.buttonsBox.setAlignment(Pos.CENTER);
        this.buttonsBox.setMinHeight(50.0);
        this.contentPane = new StackPane();
        this.contentPane.getStyleClass().setAll((Object[])new String[]{"content-pane"});
        BorderPane container = new BorderPane();
        container.setTop((Node)this.stepperBar);
        container.setCenter((Node)this.contentPane);
        container.setBottom((Node)this.buttonsBox);
        this.getChildren().add((Object)container);
        this.setListeners();
    }

    private void setListeners() {
        MFXStepper stepper = (MFXStepper)this.getSkinnable();
        stepper.addEventFilter(MFXStepper.MFXStepperEvent.FORCE_LAYOUT_UPDATE_EVENT, event -> {
            stepper.requestLayout();
            this.computeProgress();
        });
        stepper.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> stepper.requestFocus());
        stepper.addEventFilter(MFXStepperToggle.MFXStepperToggleEvent.STATE_CHANGED, event -> this.computeProgress());
        stepper.getStepperToggles().addListener(invalidated -> {
            stepper.reset();
            this.stepperBar.getChildren().setAll(stepper.getStepperToggles());
            this.stepperBar.getChildren().add(0, (Object)this.progressBarGroup);
            stepper.next();
            AnimationUtils.PauseBuilder.build().setDuration(250.0).setOnFinished((EventHandler<ActionEvent>)((EventHandler)event -> stepper.requestLayout())).getAnimation().play();
        });
        stepper.currentContentProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.contentPane.getChildren().setAll((Object[])new Node[]{newValue});
            } else {
                this.contentPane.getChildren().clear();
            }
        });
        stepper.lastToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.computeProgress();
            }
        });
        this.nextButton.setOnAction(event -> {
            this.buttonWasPressed = true;
            stepper.next();
        });
        this.previousButton.setOnAction(event -> {
            this.buttonWasPressed = true;
            stepper.previous();
        });
        this.manageScene();
    }

    private void manageScene() {
        MFXStepper stepper = (MFXStepper)this.getSkinnable();
        Scene scene = stepper.getScene();
        if (scene != null) {
            stepper.next();
        }
        NodeUtils.waitForScene((Node)stepper, () -> {
            if (stepper.getCurrentIndex() == -1) {
                stepper.next();
            }
        }, true, false);
        stepper.needsLayoutProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.buttonWasPressed) {
                stepper.requestLayout();
            }
            this.computeProgress();
        });
    }

    private void computeProgress() {
        MFXStepper stepper = (MFXStepper)this.getSkinnable();
        if (stepper.isLastToggle()) {
            this.updateProgressBar(stepper.getWidth());
            return;
        }
        MFXStepperToggle stepperToggle = stepper.getCurrentStepperNode();
        if (stepperToggle != null) {
            Bounds bounds = stepperToggle.getGraphicBounds();
            if (bounds != null) {
                double minX = this.snapSizeX(stepperToggle.localToParent(bounds).getMinX());
                this.updateProgressBar(minX + 10.0);
            }
        } else {
            this.updateProgressBar(0.0);
        }
    }

    private void updateProgressBar(double width) {
        MFXStepper stepper = (MFXStepper)this.getSkinnable();
        if (!stepper.isAnimated() || !this.buttonWasPressed) {
            this.bar.setWidth(width);
            this.buttonWasPressed = false;
            return;
        }
        KeyFrame kf = new KeyFrame(Duration.millis((double)stepper.getAnimationDuration()), new KeyValue[]{new KeyValue((WritableValue)this.bar.widthProperty(), (Object)width, MFXAnimationFactory.INTERPOLATOR_V2)});
        this.progressAnimation.getKeyFrames().setAll((Object[])new KeyFrame[]{kf});
        this.progressAnimation.playFromStart();
    }

    protected Rectangle buildRectangle(String styleClass) {
        MFXStepper stepper = (MFXStepper)this.getSkinnable();
        Rectangle rectangle = new Rectangle();
        rectangle.getStyleClass().setAll((Object[])new String[]{styleClass});
        rectangle.setStroke((Paint)Color.TRANSPARENT);
        rectangle.setStrokeLineCap(StrokeLineCap.ROUND);
        rectangle.setStrokeLineJoin(StrokeLineJoin.ROUND);
        rectangle.setStrokeType(StrokeType.INSIDE);
        rectangle.setStrokeWidth(0.0);
        rectangle.arcHeightProperty().bind((ObservableValue)stepper.progressBarBorderRadiusProperty());
        rectangle.arcWidthProperty().bind((ObservableValue)stepper.progressBarBorderRadiusProperty());
        return rectangle;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(super.computeMinWidth(height, topInset, leftInset, bottomInset, rightInset) + ((MFXStepper)this.getSkinnable()).getExtraSpacing() * 2.0, 300.0);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.stepperBar.getHeight() + this.buttonsBox.getHeight() + bottomInset;
    }

    protected double computeMaxWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXStepper)this.getSkinnable()).prefWidth(height);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return ((MFXStepper)this.getSkinnable()).prefHeight(width);
    }

    public void dispose() {
        super.dispose();
        if (this.progressAnimation.getStatus() != Animation.Status.STOPPED) {
            this.progressAnimation.stop();
        }
        this.progressAnimation = null;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        this.progressBarGroup.resize(w, 7.0);
        double bw = 125.0;
        double bh = 34.0;
        double pbx = this.snapPositionX(15.0);
        double nbx = this.snapPositionX(w - bw - 15.0);
        double by = this.snapPositionY(this.buttonsBox.getHeight() / 2.0 - bh / 2.0);
        this.previousButton.resizeRelocate(pbx, by, bw, bh);
        this.nextButton.resizeRelocate(nbx, by, bw, bh);
    }
}

