/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.MFXStepperToggle;
import io.github.palexdev.materialfx.controls.MFXTextField;
import io.github.palexdev.materialfx.dialogs.MFXDialogs;
import io.github.palexdev.materialfx.enums.StepperToggleState;
import io.github.palexdev.materialfx.enums.TextPosition;
import io.github.palexdev.materialfx.i18n.I18N;
import io.github.palexdev.materialfx.validation.MFXValidator;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeType;
import javafx.stage.Modality;

public class MFXStepperToggleSkin
extends SkinBase<MFXStepperToggle> {
    private final StackPane container;
    private final Circle circle = new Circle(0.0, (Paint)Color.LIGHTGRAY);
    private final MFXTextField label;
    private final MFXIconWrapper errorIcon;

    public MFXStepperToggleSkin(MFXStepperToggle stepperToggle) {
        super((Control)stepperToggle);
        this.circle.setId("circle");
        this.circle.radiusProperty().bind((ObservableValue)stepperToggle.sizeProperty());
        this.circle.strokeWidthProperty().bind((ObservableValue)stepperToggle.strokeWidthProperty());
        this.circle.setStrokeType(StrokeType.CENTERED);
        this.container = new StackPane(new Node[]{this.circle, stepperToggle.getIcon()});
        this.label = MFXTextField.asLabel();
        this.label.setText(stepperToggle.getText());
        this.label.setManaged(false);
        this.errorIcon = new MFXIconWrapper("fas-triangle-exclamation", 10.0, Color.web((String)"#EF6E6B"), 16.0);
        this.errorIcon.setId("errorIcon");
        this.errorIcon.setVisible(false);
        this.errorIcon.setManaged(false);
        this.getChildren().addAll((Object[])new Node[]{this.container, this.label, this.errorIcon});
        this.setListeners();
    }

    private void setListeners() {
        MFXStepperToggle stepperToggle = (MFXStepperToggle)this.getSkinnable();
        MFXValidator validator = stepperToggle.getValidator();
        stepperToggle.stateProperty().addListener((observable, oldValue, newValue) -> this.errorIcon.setVisible(newValue == StepperToggleState.ERROR && stepperToggle.isShowErrorIcon()));
        stepperToggle.showErrorIconProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.errorIcon.setVisible(stepperToggle.getState() == StepperToggleState.ERROR);
            } else {
                this.errorIcon.setVisible(false);
            }
        });
        stepperToggle.labelTextGapProperty().addListener(invalidated -> stepperToggle.requestLayout());
        stepperToggle.textPositionProperty().addListener(invalidated -> stepperToggle.requestLayout());
        validator.validProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && stepperToggle.getState() == StepperToggleState.ERROR) {
                stepperToggle.setState(StepperToggleState.SELECTED);
            }
        });
        this.errorIcon.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.showErrorsDialog());
        this.label.visibleProperty().bind((ObservableValue)stepperToggle.textProperty().isEmpty().not());
    }

    protected void showErrorsDialog() {
        MFXStepperToggle stepperToggle = (MFXStepperToggle)this.getSkinnable();
        MFXValidator validator = stepperToggle.getValidator();
        MFXDialogs.error().setShowAlwaysOnTop(false).setShowMinimize(false).setHeaderText(I18N.getOrDefault("stepperToggle.invalidFields", new Object[0])).makeScrollable(true).setContentText(validator.validateToString()).toStageDialogBuilder().initOwner(stepperToggle.getScene().getWindow()).initModality(Modality.WINDOW_MODAL).setScrimOwner(true).get().showDialog();
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return topInset + this.container.prefWidth(-1.0) + ((MFXStepperToggle)this.getSkinnable()).getLabelTextGap() * 2.0 + this.label.getHeight() * 2.0 + bottomInset;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return leftInset + Math.max(this.circle.getRadius() * 2.0, this.label.getWidth()) + rightInset;
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        MFXStepperToggle stepperToggle = (MFXStepperToggle)this.getSkinnable();
        double lw = this.snapSizeX(this.label.prefWidth(-1.0));
        double lh = this.snapSizeY(this.label.prefHeight(-1.0));
        double lx = this.snapPositionX(this.circle.getBoundsInParent().getCenterX() - lw / 2.0);
        double ly = 0.0;
        if (stepperToggle.getTextPosition() == TextPosition.BOTTOM) {
            this.label.setTranslateY(0.0);
            ly = this.snapPositionY(this.circle.getBoundsInParent().getMaxY() + stepperToggle.getLabelTextGap());
            this.label.resizeRelocate(lx, ly, lw, lh);
        } else {
            this.label.resizeRelocate(lx, ly, lw, lh);
            this.label.setTranslateY(-stepperToggle.getLabelTextGap() - lh);
        }
        double ix = this.snapPositionX(this.circle.getBoundsInParent().getMaxX());
        double iy = this.snapPositionY(this.circle.getBoundsInParent().getMinY() - 6.0);
        this.errorIcon.resizeRelocate(ix, iy, 16.0, 16.0);
    }
}

