/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins;

import io.github.palexdev.materialfx.controls.MFXTreeItem;
import io.github.palexdev.materialfx.controls.MFXTreeView;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeCell;
import io.github.palexdev.materialfx.controls.base.AbstractMFXTreeItem;
import io.github.palexdev.materialfx.factories.InsetsFactory;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.utils.AnimationUtils;
import io.github.palexdev.materialfx.utils.NodeUtils;
import java.util.ArrayList;
import java.util.Comparator;
import javafx.animation.Animation;
import javafx.animation.ParallelTransition;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;

public class MFXTreeItemSkin<T>
extends SkinBase<MFXTreeItem<T>> {
    private final VBox box;
    private final AbstractMFXTreeCell<T> cell = this.createCell();
    private final ListChangeListener<AbstractMFXTreeItem<T>> itemsListener;
    private ParallelTransition animation;
    private boolean forcedUpdate = false;

    public MFXTreeItemSkin(MFXTreeItem<T> item) {
        super(item);
        this.box = new VBox(new Node[]{this.cell});
        this.box.setMinHeight(Double.NEGATIVE_INFINITY);
        this.box.setMaxHeight(Double.NEGATIVE_INFINITY);
        item.setInitialHeight(NodeUtils.getRegionHeight((Region)this.box));
        this.getChildren().add((Object)this.box);
        this.box.setPrefHeight(item.getInitialHeight());
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.box.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.box.heightProperty());
        this.box.setClip((Node)clip);
        this.itemsListener = change -> {
            double value;
            ArrayList tmpRemoved = new ArrayList();
            ArrayList tmpAdded = new ArrayList();
            while (change.next()) {
                tmpRemoved.addAll(change.getRemoved());
                tmpAdded.addAll(change.getAddedSubList());
            }
            if (!tmpRemoved.isEmpty() && (item.isExpanded() || item.isStartExpanded())) {
                value = tmpRemoved.stream().mapToDouble(Region::getHeight).sum();
                this.box.getChildren().removeAll(tmpRemoved);
                item.fireEvent(new MFXTreeItem.TreeItemEvent(MFXTreeItem.TreeItemEvent.ADD_REMOVE_ITEM_EVENT, item, -value));
            }
            if (!tmpAdded.isEmpty() && (item.isExpanded() || item.isStartExpanded())) {
                value = tmpAdded.stream().mapToDouble(NodeUtils::getRegionHeight).sum();
                this.box.getChildren().addAll(tmpAdded);
                FXCollections.sort((ObservableList)this.box.getChildren(), Comparator.comparingInt(arg_0 -> item.getItems().indexOf(arg_0)));
                item.fireEvent(new MFXTreeItem.TreeItemEvent(MFXTreeItem.TreeItemEvent.ADD_REMOVE_ITEM_EVENT, item, value));
            }
            this.cell.updateCell(item);
        };
        this.setListeners();
        if (item.isStartExpanded()) {
            this.forceUpdate();
        }
    }

    private void setListeners() {
        MFXTreeItem item = (MFXTreeItem)this.getSkinnable();
        item.getItems().addListener(this.itemsListener);
        item.expandedProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.forcedUpdate) {
                this.updateDisplay();
            }
        });
        item.addEventHandler(MFXTreeItem.TreeItemEvent.ADD_REMOVE_ITEM_EVENT, addItemEvent -> {
            NodeUtils.addPrefHeight((Region)this.box, addItemEvent.getValue());
            if (item.getItemParent() == null) {
                addItemEvent.consume();
            }
        });
        item.addEventHandler(MFXTreeItem.TreeItemEvent.EXPAND_EVENT, expandEvent -> {
            this.buildAnimation(item.getHeight() + expandEvent.getValue());
            if (expandEvent.getItem() == item) {
                item.getItems().forEach(treeItem -> this.animation.getChildren().add((Object)MFXAnimationFactory.FADE_IN.build((Node)treeItem, item.getAnimationDuration() * 2.0)));
            }
            this.animation.play();
            if (item.getItemParent() == null) {
                expandEvent.consume();
            }
        });
        item.addEventHandler(MFXTreeItem.TreeItemEvent.COLLAPSE_EVENT, collapseEvent -> {
            this.buildAnimation(item.getHeight() - collapseEvent.getValue());
            if (collapseEvent.getItem() == item) {
                item.getItems().forEach(treeItem -> this.animation.getChildren().add((Object)MFXAnimationFactory.FADE_OUT.build((Node)treeItem, item.getAnimationDuration() / 2.0)));
                this.animation.setOnFinished(event -> this.box.getChildren().subList(1, this.box.getChildren().size()).clear());
            }
            this.animation.play();
        });
        item.addEventHandler(MFXTreeView.TreeViewEvent.HIDE_ROOT_EVENT, hideRootEvent -> {
            if (!hideRootEvent.isShow()) {
                if (!item.isExpanded()) {
                    this.forceUpdate();
                }
                this.cell.setVisible(false);
                item.setPadding(InsetsFactory.of(-(item.getInitialHeight() * 2.0), 0.0, 0.0, -item.getChildrenMargin()));
            } else {
                this.cell.setVisible(true);
                item.setPadding(Insets.EMPTY);
            }
        });
        item.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            if (event.getButton() == MouseButton.PRIMARY && event.getClickCount() == 2) {
                NodeUtils.fireDummyEvent(this.cell.getDisclosureNode());
                return;
            }
            if (!NodeUtils.inHierarchy(event, this.cell.getDisclosureNode())) {
                item.getSelectionModel().select(item, (MouseEvent)event);
            }
        });
    }

    protected void updateDisplay() {
        MFXTreeItem item = (MFXTreeItem)this.getSkinnable();
        if (item.isExpanded()) {
            this.box.getChildren().addAll(item.getItems());
            this.box.applyCss();
            this.box.layout();
            item.fireEvent(new MFXTreeItem.TreeItemEvent(MFXTreeItem.TreeItemEvent.EXPAND_EVENT, item, this.computeExpandCollapse()));
        } else {
            item.fireEvent(new MFXTreeItem.TreeItemEvent(MFXTreeItem.TreeItemEvent.COLLAPSE_EVENT, item, this.computeExpandCollapse()));
        }
    }

    protected void buildAnimation(double fHeight) {
        MFXTreeItem item = (MFXTreeItem)this.getSkinnable();
        this.animation = (ParallelTransition)AnimationUtils.ParallelBuilder.build().add(AnimationUtils.KeyFrames.of(item.getAnimationDuration(), this.box.prefHeightProperty(), Double.valueOf(fHeight), MFXAnimationFactory.INTERPOLATOR_V2), AnimationUtils.KeyFrames.of(250.0, this.cell.getDisclosureNode().rotateProperty(), Integer.valueOf(item.isExpanded() ? 90 : 0), MFXAnimationFactory.INTERPOLATOR_V2)).getAnimation();
        item.animationRunningProperty().bind((ObservableValue)this.animation.statusProperty().isEqualTo((Object)Animation.Status.RUNNING));
    }

    protected boolean animationIsRunning() {
        ArrayList<MFXTreeItem> tmp = new ArrayList<MFXTreeItem>();
        for (MFXTreeItem item = (MFXTreeItem)this.getSkinnable(); item != null; item = (MFXTreeItem)item.getItemParent()) {
            tmp.add(item);
        }
        for (MFXTreeItem i : tmp) {
            if (i == null || !i.isAnimationRunning()) continue;
            return true;
        }
        return false;
    }

    protected double computeExpandCollapse() {
        MFXTreeItem item = (MFXTreeItem)this.getSkinnable();
        double value = item.getItems().stream().mapToDouble(Region::getHeight).sum();
        if (item.isRoot() && !this.forcedUpdate && !item.isExpanded()) {
            value = item.getHeight() - item.getInitialHeight();
        }
        return value;
    }

    private void forceUpdate() {
        MFXTreeItem item = (MFXTreeItem)this.getSkinnable();
        this.forcedUpdate = true;
        this.box.getChildren().addAll(item.getItems());
        this.box.applyCss();
        this.box.layout();
        this.box.setPrefHeight(item.getInitialHeight() + this.computeExpandCollapse());
        this.cell.updateCell(item);
        item.setExpanded(true);
        this.forcedUpdate = false;
    }

    protected AbstractMFXTreeCell<T> createCell() {
        MFXTreeItem item = (MFXTreeItem)this.getSkinnable();
        AbstractMFXTreeCell cell = (AbstractMFXTreeCell)item.getCellFactory().call((Object)item);
        Node disclosureNode = cell.getDisclosureNode();
        disclosureNode.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (item.getItems().isEmpty()) {
                event.consume();
                return;
            }
            if (this.animationIsRunning()) {
                event.consume();
                return;
            }
            item.setExpanded(!item.isExpanded());
        });
        cell.updateCell(item);
        return cell;
    }

    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        ((MFXTreeItem)this.getSkinnable()).getItems().removeListener(this.itemsListener);
        if (this.animation != null) {
            this.animation.getChildren().clear();
            this.animation = null;
        }
        super.dispose();
    }
}

