/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.materialfx.skins.legacy;

import io.github.palexdev.materialfx.controls.MFXIconWrapper;
import io.github.palexdev.materialfx.controls.legacy.MFXLegacyComboBox;
import io.github.palexdev.materialfx.factories.MFXAnimationFactory;
import io.github.palexdev.materialfx.utils.TextUtils;
import io.github.palexdev.materialfx.validation.Constraint;
import io.github.palexdev.materialfx.validation.MFXValidator;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javafx.animation.ScaleTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.util.Duration;

public class MFXLegacyComboBoxSkin<T>
extends ComboBoxListViewSkin<T> {
    private final double padding = 11.0;
    private final Line unfocusedLine = new Line();
    private final Line focusedLine;
    private final Label validate;

    public MFXLegacyComboBoxSkin(MFXLegacyComboBox<T> comboBox) {
        super(comboBox);
        this.unfocusedLine.getStyleClass().add((Object)"unfocused-line");
        this.unfocusedLine.setManaged(false);
        this.unfocusedLine.strokeWidthProperty().bind((ObservableValue)comboBox.lineStrokeWidthProperty());
        this.unfocusedLine.strokeLineCapProperty().bind(comboBox.lineStrokeCapProperty());
        this.unfocusedLine.strokeProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            ArrayList pseudoClasses = new ArrayList(comboBox.getPseudoClassStates());
            return pseudoClasses.stream().map(PseudoClass::getPseudoClassName).collect(Collectors.toList()).contains("invalid") ? comboBox.getInvalidLineColor() : comboBox.getUnfocusedLineColor();
        }, (Observable[])new Observable[]{comboBox.focusedProperty(), comboBox.getPseudoClassStates(), comboBox.unfocusedLineColorProperty()}));
        this.unfocusedLine.endXProperty().bind((ObservableValue)comboBox.widthProperty());
        this.unfocusedLine.setSmooth(true);
        this.unfocusedLine.setManaged(false);
        this.focusedLine = new Line();
        this.focusedLine.getStyleClass().add((Object)"focused-line");
        this.focusedLine.setManaged(false);
        this.focusedLine.strokeWidthProperty().bind((ObservableValue)comboBox.lineStrokeWidthProperty());
        this.focusedLine.strokeLineCapProperty().bind(comboBox.lineStrokeCapProperty());
        this.focusedLine.strokeProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            ArrayList pseudoClasses = new ArrayList(comboBox.getPseudoClassStates());
            return pseudoClasses.stream().map(PseudoClass::getPseudoClassName).collect(Collectors.toList()).contains("invalid") ? comboBox.getInvalidLineColor() : comboBox.getLineColor();
        }, (Observable[])new Observable[]{comboBox.focusedProperty(), comboBox.getPseudoClassStates(), comboBox.lineColorProperty()}));
        this.focusedLine.endXProperty().bind((ObservableValue)comboBox.widthProperty());
        this.focusedLine.setSmooth(true);
        this.focusedLine.setScaleX(0.0);
        this.focusedLine.setManaged(false);
        MFXIconWrapper warnWrapper = new MFXIconWrapper("fas-triangle-exclamation", 10.0, Color.RED, 10.0);
        this.validate = new Label();
        this.validate.setGraphic((Node)warnWrapper);
        this.validate.getStyleClass().add((Object)"validate-label");
        this.validate.setGraphicTextGap(11.0);
        this.validate.setVisible(false);
        this.validate.setManaged(false);
        this.getChildren().addAll((Object[])new Node[]{this.unfocusedLine, this.focusedLine, this.validate});
        this.setListeners();
    }

    private void setListeners() {
        MFXLegacyComboBox comboBox = (MFXLegacyComboBox)this.getSkinnable();
        MFXValidator validator = comboBox.getValidator();
        comboBox.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue() && comboBox.isValidated()) {
                comboBox.getValidator().update();
                this.validate.setVisible(!comboBox.isValid());
            }
            if (comboBox.isAnimateLines()) {
                this.buildAndPlayAnimation((boolean)newValue);
                return;
            }
            if (newValue.booleanValue()) {
                this.focusedLine.setScaleX(1.0);
            } else {
                this.focusedLine.setScaleX(0.0);
            }
        });
        comboBox.isValidatedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.validate.setVisible(false);
            }
        });
        comboBox.disabledProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.validate.setVisible(false);
            }
        });
        validator.setOnUpdated((valid, constraints) -> {
            if (!comboBox.isValidated()) {
                return;
            }
            if (!valid.booleanValue()) {
                Constraint first = (Constraint)constraints.get(0);
                this.validate.setText(first.getMessage());
            }
            this.validate.setVisible(valid == false);
        });
        this.validate.textProperty().addListener(invalidated -> comboBox.requestLayout());
    }

    private void buildAndPlayAnimation(boolean focused) {
        ScaleTransition scaleTransition = new ScaleTransition(Duration.millis((double)350.0), (Node)this.focusedLine);
        if (focused) {
            scaleTransition.setFromX(0.0);
            scaleTransition.setToX(1.0);
        } else {
            scaleTransition.setFromX(1.0);
            scaleTransition.setToX(0.0);
        }
        scaleTransition.setInterpolator(MFXAnimationFactory.INTERPOLATOR_V2);
        scaleTransition.play();
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        double lw = this.snapSizeX(TextUtils.computeLabelWidth(this.validate));
        double lh = this.snapSizeY(TextUtils.computeTextHeight(this.validate.getFont(), this.validate.getText()));
        double lx = 0.0;
        double ly = h + 7.699999999999999;
        this.validate.resizeRelocate(lx, ly, lw, lh);
        this.focusedLine.relocate(0.0, h);
        this.unfocusedLine.relocate(0.0, h);
    }
}

